/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyResolveException;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskReference;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTaskDependencyResolveContext
implements TaskDependencyResolveContext,
TaskDependency {
    private final LinkedList<Object> queue = new LinkedList();
    private final CachingDirectedGraphWalker<Object, Task> walker = new CachingDirectedGraphWalker<Object, Task>(new TaskGraphImpl());
    private Task task;

    @Override
    public Set<? extends Task> getDependencies(Task task) {
        this.add(task.getTaskDependencies());
        return this.resolve(task);
    }

    @Override
    public Task getTask() {
        return this.task;
    }

    public Set<Task> resolve(Task task) {
        this.task = task;
        try {
            Set<Task> set = this.doResolve();
            return set;
        }
        catch (Exception e) {
            throw new TaskDependencyResolveException(String.format("Could not determine the dependencies of %s.", task), e);
        }
        finally {
            this.queue.clear();
            this.task = null;
        }
    }

    private Set<Task> doResolve() {
        this.walker.add((Iterable<Object>)this.queue);
        return this.walker.findValues();
    }

    @Override
    public void add(Object dependency) {
        Preconditions.checkNotNull((Object)dependency);
        this.queue.add(dependency);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TaskGraphImpl
    implements DirectedGraph<Object, Task> {
        private TaskGraphImpl() {
        }

        @Override
        public void getNodeValues(Object node, Collection<? super Task> values, Collection<? super Object> connectedNodes) {
            if (node instanceof TaskDependencyContainer) {
                TaskDependencyContainer taskDependency = (TaskDependencyContainer)node;
                CachingTaskDependencyResolveContext.this.queue.clear();
                taskDependency.visitDependencies(CachingTaskDependencyResolveContext.this);
                connectedNodes.addAll(CachingTaskDependencyResolveContext.this.queue);
            } else if (node instanceof Buildable) {
                Buildable buildable = (Buildable)node;
                connectedNodes.add(buildable.getBuildDependencies());
            } else if (node instanceof TaskDependency) {
                TaskDependency dependency = (TaskDependency)node;
                values.addAll(dependency.getDependencies(CachingTaskDependencyResolveContext.this.task));
            } else if (node instanceof Task) {
                values.add((Task)node);
            } else if (node instanceof TaskReference) {
                TaskContainerInternal tasks = (TaskContainerInternal)CachingTaskDependencyResolveContext.this.task.getProject().getTasks();
                Task task = tasks.resolveTask((TaskReference)node);
                values.add(task);
            } else {
                throw new IllegalArgumentException(String.format("Cannot resolve object of unknown type %s to a Task.", node.getClass().getSimpleName()));
            }
        }
    }
}

