/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

class IncrementalCompilationInitializer {
    private final FileOperations fileOperations;

    public IncrementalCompilationInitializer(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void initializeCompilation(JavaCompileSpec spec, Collection<String> staleClasses) {
        if (staleClasses.isEmpty()) {
            spec.setSource(new SimpleFileCollection(new File[0]));
            return;
        }
        Factory<PatternSet> patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = patternSetFactory.create();
        PatternSet sourceToCompile = patternSetFactory.create();
        this.preparePatterns(staleClasses, classesToDelete, sourceToCompile);
        spec.setSource(spec.getSource().getAsFileTree().matching(sourceToCompile));
        ArrayList classpath = Lists.newArrayList(spec.getCompileClasspath());
        classpath.add(spec.getDestinationDir());
        spec.setCompileClasspath(classpath);
        FileTree deleteMe = this.fileOperations.fileTree(spec.getDestinationDir()).matching(classesToDelete);
        this.fileOperations.delete(deleteMe);
    }

    void preparePatterns(Collection<String> staleClasses, PatternSet classesToDelete, PatternSet sourceToCompile) {
        assert (!staleClasses.isEmpty());
        for (String staleClass : staleClasses) {
            String path = staleClass.replaceAll("\\.", "/");
            classesToDelete.include(path.concat(".class"));
            classesToDelete.include(path.concat("$*.class"));
            sourceToCompile.include(path.concat(".java"));
            sourceToCompile.include(path.concat("$*.java"));
        }
    }
}

