/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;

public class JarSnapshotDataSerializer
extends AbstractSerializer<JarSnapshotData> {
    private final MapSerializer<String, HashCode> mapSerializer;
    private final Serializer<ClassSetAnalysisData> analysisSerializer;
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();

    public JarSnapshotDataSerializer() {
        this.mapSerializer = new MapSerializer<String, HashCode>(BaseSerializerFactory.STRING_SERIALIZER, this.hashCodeSerializer);
        this.analysisSerializer = new ClassSetAnalysisData.Serializer();
    }

    @Override
    public JarSnapshotData read(Decoder decoder) throws Exception {
        HashCode hash = this.hashCodeSerializer.read(decoder);
        Object hashes = this.mapSerializer.read(decoder);
        ClassSetAnalysisData data = this.analysisSerializer.read(decoder);
        return new JarSnapshotData(hash, (Map<String, HashCode>)hashes, data);
    }

    @Override
    public void write(Encoder encoder, JarSnapshotData value) throws Exception {
        this.hashCodeSerializer.write(encoder, value.hash);
        this.mapSerializer.write(encoder, value.hashes);
        this.analysisSerializer.write(encoder, value.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        JarSnapshotDataSerializer rhs = (JarSnapshotDataSerializer)obj;
        return Objects.equal(this.mapSerializer, rhs.mapSerializer) && Objects.equal(this.analysisSerializer, rhs.analysisSerializer) && Objects.equal((Object)this.hashCodeSerializer, (Object)rhs.hashCodeSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.mapSerializer, this.analysisSerializer, this.hashCodeSerializer});
    }
}

