/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Method;
import java.util.Set;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.api.internal.tasks.options.OptionValueNotationParserFactory;
import org.gradle.internal.exceptions.ValueCollectingDiagnosticsVisitor;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.typeconversion.NotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractOptionElement
implements OptionElement {
    private final String optionName;
    private final String description;
    private final int order;
    private final Class<?> optionType;
    private final NotationParser<CharSequence, ?> notationParser;

    public AbstractOptionElement(String optionName, Option option, Class<?> optionType, Class<?> declaringClass, NotationParser<CharSequence, ?> notationParser) {
        this.description = this.readDescription(option, optionName, declaringClass);
        this.order = option.order();
        this.optionName = optionName;
        this.optionType = optionType;
        this.notationParser = notationParser;
    }

    @Override
    public Set<String> getAvailableValues() {
        ValueCollectingDiagnosticsVisitor visitor = new ValueCollectingDiagnosticsVisitor();
        this.notationParser.describe(visitor);
        return visitor.getValues();
    }

    @Override
    public Class<?> getOptionType() {
        return this.optionType;
    }

    private String readDescription(Option option, String optionName, Class<?> declaringClass) {
        try {
            return option.description();
        }
        catch (IncompleteAnnotationException ex) {
            throw new OptionValidationException(String.format("No description set on option '%s' at for class '%s'.", optionName, declaringClass.getName()));
        }
    }

    protected Object invokeMethod(Object object, Method method, Object ... parameterValues) {
        JavaMethod<Object, Object> javaMethod = JavaReflectionUtil.method(Object.class, method);
        return javaMethod.invoke(object, parameterValues);
    }

    @Override
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    protected NotationParser<CharSequence, ?> getNotationParser() {
        return this.notationParser;
    }

    protected static <T> NotationParser<CharSequence, T> createNotationParserOrFail(OptionValueNotationParserFactory optionValueNotationParserFactory, String optionName, Class<T> optionType, Class<?> declaringClass) {
        try {
            return optionValueNotationParserFactory.toComposite(optionType);
        }
        catch (OptionValidationException ex) {
            throw new OptionValidationException(String.format("Option '%s' cannot be casted to type '%s' in class '%s'.", optionName, optionType.getName(), declaringClass.getName()));
        }
    }

    protected static Class<?> calculateOptionType(Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return Void.TYPE;
        }
        return type;
    }
}

