/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.artifact.DefaultIvyArtifactSet;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependencySet;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultIvyPublication
implements IvyPublicationInternal {
    private static final Comparator<? super UsageContext> USAGE_ORDERING = new Comparator<UsageContext>(){

        @Override
        public int compare(UsageContext left, UsageContext right) {
            if (left.getUsage().getName().equals("java-api")) {
                return -1;
            }
            if (right.getUsage().getName().equals("java-api")) {
                return 1;
            }
            return left.getUsage().getName().compareTo(right.getUsage().getName());
        }
    };
    private final String name;
    private final IvyModuleDescriptorSpecInternal descriptor;
    private final IvyPublicationIdentity publicationIdentity;
    private final IvyConfigurationContainer configurations;
    private final DefaultIvyArtifactSet ivyArtifacts;
    private final DefaultIvyDependencySet ivyDependencies;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private FileCollection descriptorFile;
    private SoftwareComponentInternal component;
    private boolean alias;

    public DefaultIvyPublication(String name, Instantiator instantiator, IvyPublicationIdentity publicationIdentity, NotationParser<Object, IvyArtifact> ivyArtifactNotationParser, ProjectDependencyPublicationResolver projectDependencyResolver, FileCollectionFactory fileCollectionFactory) {
        this.name = name;
        this.publicationIdentity = publicationIdentity;
        this.projectDependencyResolver = projectDependencyResolver;
        this.configurations = instantiator.newInstance(DefaultIvyConfigurationContainer.class, instantiator);
        this.ivyArtifacts = instantiator.newInstance(DefaultIvyArtifactSet.class, name, ivyArtifactNotationParser, fileCollectionFactory);
        this.ivyDependencies = instantiator.newInstance(DefaultIvyDependencySet.class, new Object[0]);
        this.descriptor = instantiator.newInstance(DefaultIvyModuleDescriptorSpec.class, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public SoftwareComponentInternal getComponent() {
        return this.component;
    }

    @Override
    public IvyModuleDescriptorSpecInternal getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setDescriptorFile(FileCollection descriptorFile) {
        this.descriptorFile = descriptorFile;
    }

    @Override
    public void descriptor(Action<? super IvyModuleDescriptorSpec> configure) {
        configure.execute(this.descriptor);
    }

    @Override
    public boolean isAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.component != null) {
            throw new InvalidUserDataException(String.format("Ivy publication '%s' cannot include multiple components", this.name));
        }
        this.component = (SoftwareComponentInternal)component;
        this.configurations.maybeCreate("default");
        HashSet seenArtifacts = Sets.newHashSet();
        HashSet seenDependencies = Sets.newHashSet();
        for (UsageContext usageContext : this.getSortedUsageContexts()) {
            Usage usage = usageContext.getUsage();
            String conf = this.mapUsage(usage);
            this.configurations.maybeCreate(conf);
            ((IvyConfiguration)this.configurations.getByName("default")).extend(conf);
            for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                if (seenArtifacts.contains(publishArtifact)) continue;
                seenArtifacts.add(publishArtifact);
                this.artifact(publishArtifact).setConf(conf);
            }
            for (ModuleDependency moduleDependency : usageContext.getDependencies()) {
                if (!seenDependencies.add(moduleDependency)) continue;
                String confMapping = String.format("%s->%s", conf, moduleDependency.getTargetConfiguration() == null ? "default" : moduleDependency.getTargetConfiguration());
                if (moduleDependency instanceof ProjectDependency) {
                    this.addProjectDependency((ProjectDependency)moduleDependency, confMapping);
                    continue;
                }
                this.addModuleDependency(moduleDependency, confMapping);
            }
        }
    }

    private List<UsageContext> getSortedUsageContexts() {
        ArrayList usageContexts = Lists.newArrayList(this.component.getUsages());
        Collections.sort(usageContexts, USAGE_ORDERING);
        return usageContexts;
    }

    private String mapUsage(Usage usage) {
        if ("java-api".equals(usage.getName())) {
            return "compile";
        }
        if ("java-runtime".equals(usage.getName())) {
            return "runtime";
        }
        return usage.getName();
    }

    private void addProjectDependency(ProjectDependency dependency, String confMapping) {
        ModuleVersionIdentifier identifier = this.projectDependencyResolver.resolve(dependency);
        this.ivyDependencies.add(new DefaultIvyDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), confMapping, dependency.isTransitive(), Collections.emptyList(), dependency.getExcludeRules()));
    }

    private void addModuleDependency(ModuleDependency dependency, String confMapping) {
        this.ivyDependencies.add(new DefaultIvyDependency(dependency, confMapping));
    }

    @Override
    public void configurations(Action<? super IvyConfigurationContainer> config) {
        config.execute(this.configurations);
    }

    @Override
    public IvyConfigurationContainer getConfigurations() {
        return this.configurations;
    }

    @Override
    public IvyArtifact artifact(Object source) {
        return this.ivyArtifacts.artifact(source);
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        return this.ivyArtifacts.artifact(source, config);
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.ivyArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public DefaultIvyArtifactSet getArtifacts() {
        return this.ivyArtifacts;
    }

    @Override
    public String getOrganisation() {
        return this.publicationIdentity.getOrganisation();
    }

    @Override
    public void setOrganisation(String organisation) {
        this.publicationIdentity.setOrganisation(organisation);
    }

    @Override
    public String getModule() {
        return this.publicationIdentity.getModule();
    }

    @Override
    public void setModule(String module) {
        this.publicationIdentity.setModule(module);
    }

    @Override
    public String getRevision() {
        return this.publicationIdentity.getRevision();
    }

    @Override
    public void setRevision(String revision) {
        this.publicationIdentity.setRevision(revision);
    }

    @Override
    public FileCollection getPublishableFiles() {
        return new UnionFileCollection(this.ivyArtifacts.getFiles(), this.descriptorFile);
    }

    @Override
    public IvyPublicationIdentity getIdentity() {
        return this.publicationIdentity;
    }

    @Override
    public Set<IvyDependencyInternal> getDependencies() {
        return this.ivyDependencies;
    }

    @Override
    public IvyNormalizedPublication asNormalisedPublication() {
        return new IvyNormalizedPublication(this.name, this.getIdentity(), this.getDescriptorFile(), this.ivyArtifacts);
    }

    private File getDescriptorFile() {
        if (this.descriptorFile == null) {
            throw new IllegalStateException("descriptorFile not set for publication");
        }
        return this.descriptorFile.getSingleFile();
    }

    @Override
    public ModuleVersionIdentifier getCoordinates() {
        return new DefaultModuleVersionIdentifier(this.getOrganisation(), this.getModule(), this.getRevision());
    }

    @Override
    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        throw new UnsupportedOperationException("Will be required for publishing module metadata");
    }
}

