/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.tasks;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.publication.maven.internal.VersionRangeMapper;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.impldep.org.apache.maven.model.Dependency;
import org.gradle.internal.impldep.org.apache.maven.model.Exclusion;
import org.gradle.internal.impldep.org.apache.maven.model.Model;
import org.gradle.internal.impldep.org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.GUtil;

public class MavenPomFileGenerator {
    private static final String POM_FILE_ENCODING = "UTF-8";
    private static final String POM_VERSION = "4.0.0";
    private Model model = new Model();
    private XmlTransformer xmlTransformer = new XmlTransformer();
    private final VersionRangeMapper versionRangeMapper;

    public MavenPomFileGenerator(MavenProjectIdentity identity, VersionRangeMapper versionRangeMapper) {
        this.versionRangeMapper = versionRangeMapper;
        this.model.setModelVersion(POM_VERSION);
        Model model = this.getModel();
        model.setGroupId(identity.getGroupId());
        model.setArtifactId(identity.getArtifactId());
        model.setVersion(identity.getVersion());
    }

    public MavenPomFileGenerator setPackaging(String packaging) {
        this.getModel().setPackaging(packaging);
        return this;
    }

    private Model getModel() {
        return this.model;
    }

    public void addRuntimeDependency(MavenDependencyInternal dependency) {
        this.addDependency(dependency, "runtime");
    }

    public void addApiDependency(MavenDependencyInternal apiDependency) {
        this.addDependency(apiDependency, "compile");
    }

    private void addDependency(MavenDependencyInternal mavenDependency, String scope) {
        if (mavenDependency.getArtifacts().size() == 0) {
            this.addDependency(mavenDependency, mavenDependency.getArtifactId(), scope, null, null);
        } else {
            for (DependencyArtifact artifact : mavenDependency.getArtifacts()) {
                this.addDependency(mavenDependency, artifact.getName(), scope, artifact.getType(), artifact.getClassifier());
            }
        }
    }

    private void addDependency(MavenDependencyInternal dependency, String artifactId, String scope, String type, String classifier) {
        Dependency mavenDependency = new Dependency();
        mavenDependency.setGroupId(dependency.getGroupId());
        mavenDependency.setArtifactId(artifactId);
        mavenDependency.setVersion(this.mapToMavenSyntax(dependency.getVersion()));
        mavenDependency.setType(type);
        mavenDependency.setScope(scope);
        mavenDependency.setClassifier(classifier);
        for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
            Exclusion exclusion = new Exclusion();
            exclusion.setGroupId(GUtil.elvis(excludeRule.getGroup(), "*"));
            exclusion.setArtifactId(GUtil.elvis(excludeRule.getModule(), "*"));
            mavenDependency.addExclusion(exclusion);
        }
        this.getModel().addDependency(mavenDependency);
    }

    private String mapToMavenSyntax(String version) {
        return this.versionRangeMapper.map(version);
    }

    public MavenPomFileGenerator withXml(Action<XmlProvider> action) {
        this.xmlTransformer.addAction(action);
        return this;
    }

    public MavenPomFileGenerator writeTo(File file) {
        this.xmlTransformer.transform(file, POM_FILE_ENCODING, (Action<? super Writer>)new Action<Writer>(){

            @Override
            public void execute(Writer writer) {
                try {
                    new MavenXpp3Writer().write(writer, MavenPomFileGenerator.this.model);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        return this;
    }
}

