/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.insight;

import java.util.Collection;
import java.util.Comparator;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionInfo;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.util.CollectionUtils;

public class DependencyResultSorter {
    public static Collection<DependencyEdge> sort(Collection<DependencyEdge> input, VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator) {
        return CollectionUtils.sort(input, new DependencyComparator(versionSelectorScheme, versionComparator));
    }

    private static class DependencyComparator
    implements Comparator<DependencyEdge> {
        private final VersionSelectorScheme versionSelectorScheme;
        private final VersionComparator versionComparator;

        private DependencyComparator(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator) {
            this.versionSelectorScheme = versionSelectorScheme;
            this.versionComparator = versionComparator;
        }

        @Override
        public int compare(DependencyEdge left, DependencyEdge right) {
            this.checkRequestedComponentSelectorType(left);
            this.checkRequestedComponentSelectorType(right);
            if (this.isLeftProjectButRightIsModuleComponentSelector(left, right)) {
                return -1;
            }
            if (this.isLeftModuleButRightIsProjectComponentSelector(left, right)) {
                return 1;
            }
            if (this.isLeftAndRightProjectComponentSelector(left, right)) {
                return this.compareRequestedProjectComponentSelectors(left, right);
            }
            if (this.isLeftAndRightModuleComponentSelector(left, right)) {
                return this.compareModuleComponentSelectors(left, right);
            }
            return 0;
        }

        private void checkRequestedComponentSelectorType(DependencyEdge dependencyEdge) {
            if (dependencyEdge == null || dependencyEdge.getRequested() == null) {
                throw new IllegalArgumentException("Dependency edge or the requested component selector may not be null");
            }
            ComponentSelector requested = dependencyEdge.getRequested();
            if (!this.isExpectedComponentSelector(requested)) {
                throw new IllegalArgumentException("Unexpected component selector type for dependency edge: " + requested.getClass());
            }
        }

        private boolean isExpectedComponentSelector(ComponentSelector componentSelector) {
            return componentSelector instanceof ProjectComponentSelector || componentSelector instanceof ModuleComponentSelector;
        }

        private boolean isLeftProjectButRightIsModuleComponentSelector(DependencyEdge left, DependencyEdge right) {
            return left.getRequested() instanceof ProjectComponentSelector && right.getRequested() instanceof ModuleComponentSelector;
        }

        private boolean isLeftModuleButRightIsProjectComponentSelector(DependencyEdge left, DependencyEdge right) {
            return left.getRequested() instanceof ModuleComponentSelector && right.getRequested() instanceof ProjectComponentSelector;
        }

        private boolean isLeftAndRightProjectComponentSelector(DependencyEdge left, DependencyEdge right) {
            return left.getRequested() instanceof ProjectComponentSelector && right.getRequested() instanceof ProjectComponentSelector;
        }

        private boolean isLeftAndRightModuleComponentSelector(DependencyEdge left, DependencyEdge right) {
            return left.getRequested() instanceof ModuleComponentSelector && right.getRequested() instanceof ModuleComponentSelector;
        }

        private int compareModuleComponentSelectors(DependencyEdge left, DependencyEdge right) {
            ModuleComponentSelector leftRequested = (ModuleComponentSelector)left.getRequested();
            ModuleComponentSelector rightRequested = (ModuleComponentSelector)right.getRequested();
            int byGroup = leftRequested.getGroup().compareTo(rightRequested.getGroup());
            if (byGroup != 0) {
                return byGroup;
            }
            int byModule = leftRequested.getModule().compareTo(rightRequested.getModule());
            if (byModule != 0) {
                return byModule;
            }
            boolean leftMatches = leftRequested.matchesStrictly(left.getActual());
            boolean rightMatches = rightRequested.matchesStrictly(right.getActual());
            if (leftMatches && !rightMatches) {
                return -1;
            }
            if (!leftMatches && rightMatches) {
                return 1;
            }
            boolean leftDynamic = this.versionSelectorScheme.parseSelector(leftRequested.getVersionConstraint().getPreferredVersion()).isDynamic();
            boolean rightDynamic = this.versionSelectorScheme.parseSelector(rightRequested.getVersionConstraint().getPreferredVersion()).isDynamic();
            if (leftDynamic && !rightDynamic) {
                return 1;
            }
            if (!leftDynamic && rightDynamic) {
                return -1;
            }
            int byVersion = leftDynamic && rightDynamic ? leftRequested.getVersionConstraint().getPreferredVersion().compareTo(rightRequested.getVersionConstraint().getPreferredVersion()) : this.compareVersions(leftRequested.getVersionConstraint().getPreferredVersion(), rightRequested.getVersionConstraint().getPreferredVersion());
            if (byVersion != 0) {
                return byVersion;
            }
            return this.compareFromComponentIdentifiers(left.getFrom(), right.getFrom());
        }

        private int compareRequestedProjectComponentSelectors(DependencyEdge left, DependencyEdge right) {
            ProjectComponentSelector leftRequested = (ProjectComponentSelector)left.getRequested();
            ProjectComponentSelector rightRequested = (ProjectComponentSelector)right.getRequested();
            return leftRequested.getProjectPath().compareTo(rightRequested.getProjectPath());
        }

        public int compareFromComponentIdentifiers(ComponentIdentifier left, ComponentIdentifier right) {
            if (this.isLeftAndRightFromProjectComponentIdentifier(left, right)) {
                return this.compareFromProjectComponentIdentifiers(left, right);
            }
            if (this.isLeftAndRightFromModuleComponentIdentifier(left, right)) {
                return this.compareFromModuleComponentIdentifiers(left, right);
            }
            return this.isLeftFromProjectButRightIsModuleComponentIdentifier(left, right) ? -1 : 1;
        }

        private int compareFromProjectComponentIdentifiers(ComponentIdentifier left, ComponentIdentifier right) {
            ProjectComponentIdentifier leftFrom = (ProjectComponentIdentifier)left;
            ProjectComponentIdentifier rightFrom = (ProjectComponentIdentifier)right;
            return leftFrom.getProjectPath().compareTo(rightFrom.getProjectPath());
        }

        private int compareFromModuleComponentIdentifiers(ComponentIdentifier left, ComponentIdentifier right) {
            ModuleComponentIdentifier leftFrom = (ModuleComponentIdentifier)left;
            ModuleComponentIdentifier rightFrom = (ModuleComponentIdentifier)right;
            int byGroup = leftFrom.getGroup().compareTo(rightFrom.getGroup());
            if (byGroup != 0) {
                return byGroup;
            }
            int byModule = leftFrom.getModule().compareTo(rightFrom.getModule());
            if (byModule != 0) {
                return byModule;
            }
            return this.compareVersions(leftFrom.getVersion(), rightFrom.getVersion());
        }

        private int compareVersions(String left, String right) {
            return this.versionComparator.compare(new VersionInfo(left), new VersionInfo(right));
        }

        private boolean isLeftAndRightFromProjectComponentIdentifier(ComponentIdentifier left, ComponentIdentifier right) {
            return left instanceof ProjectComponentIdentifier && right instanceof ProjectComponentIdentifier;
        }

        private boolean isLeftAndRightFromModuleComponentIdentifier(ComponentIdentifier left, ComponentIdentifier right) {
            return left instanceof ModuleComponentIdentifier && right instanceof ModuleComponentIdentifier;
        }

        private boolean isLeftFromProjectButRightIsModuleComponentIdentifier(ComponentIdentifier left, ComponentIdentifier right) {
            return left instanceof ProjectComponentIdentifier && right instanceof ModuleComponentIdentifier;
        }
    }
}

