/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import java.util.Collection;
import java.util.Iterator;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;

public class ModuleVersionNotFoundException
extends ModuleVersionResolveException {
    public ModuleVersionNotFoundException(ComponentSelector selector, String message) {
        super(selector, message);
    }

    public ModuleVersionNotFoundException(ModuleVersionSelector selector, String message) {
        super(selector, message);
    }

    public ModuleVersionNotFoundException(ModuleComponentSelector selector, Collection<String> attemptedLocations, Collection<String> unmatchedVersions, Collection<String> rejectedVersions) {
        super((ComponentSelector)selector, ModuleVersionNotFoundException.format(selector, attemptedLocations, unmatchedVersions, rejectedVersions));
    }

    public ModuleVersionNotFoundException(ModuleVersionIdentifier id, Collection<String> attemptedLocations) {
        super(id, ModuleVersionNotFoundException.format(id, attemptedLocations));
    }

    private static String format(ModuleComponentSelector selector, Collection<String> locations, Collection<String> unmatchedVersions, Collection<String> rejectedVersions) {
        StringBuilder builder = new StringBuilder();
        if (unmatchedVersions.isEmpty() && rejectedVersions.isEmpty()) {
            builder.append(String.format("Could not find any matches for %s as no versions of %s:%s are available.", selector, selector.getGroup(), selector.getModule()));
        } else {
            builder.append(String.format("Could not find any version that matches %s.", selector));
            if (!unmatchedVersions.isEmpty()) {
                builder.append(String.format("%nVersions that do not match:", new Object[0]));
                ModuleVersionNotFoundException.appendSizeLimited(builder, unmatchedVersions);
            }
            if (!rejectedVersions.isEmpty()) {
                builder.append(String.format("%nVersions rejected by component selection rules:", new Object[0]));
                ModuleVersionNotFoundException.appendSizeLimited(builder, rejectedVersions);
            }
        }
        ModuleVersionNotFoundException.addLocations(builder, locations);
        return builder.toString();
    }

    private static String format(ModuleVersionIdentifier id, Collection<String> locations) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Could not find %s.", id));
        ModuleVersionNotFoundException.addLocations(builder, locations);
        return builder.toString();
    }

    private static void appendSizeLimited(StringBuilder builder, Collection<String> values) {
        Iterator<String> iterator = values.iterator();
        int count = Math.min(5, values.size());
        for (int i = 0; i < count; ++i) {
            builder.append(String.format("%n    %s", iterator.next()));
        }
        if (count < values.size()) {
            builder.append(String.format("%n    + %d more", values.size() - count));
        }
    }

    private static void addLocations(StringBuilder builder, Collection<String> locations) {
        if (locations.isEmpty()) {
            return;
        }
        builder.append(String.format("%nSearched in the following locations:", new Object[0]));
        for (String location : locations) {
            builder.append(String.format("%n    %s", location));
        }
    }
}

