/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.Collection;
import org.gradle.cache.PersistentStateCache;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.IncementalCompileSourceProcessor;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompileFilesFactory;

public class IncrementalCompileProcessor {
    private final PersistentStateCache<CompilationState> previousCompileStateCache;
    private final IncrementalCompileFilesFactory incrementalCompileFilesFactory;

    public IncrementalCompileProcessor(PersistentStateCache<CompilationState> previousCompileStateCache, IncrementalCompileFilesFactory incrementalCompileFilesFactory) {
        this.previousCompileStateCache = previousCompileStateCache;
        this.incrementalCompileFilesFactory = incrementalCompileFilesFactory;
    }

    public IncrementalCompilation processSourceFiles(Collection<File> sourceFiles) {
        CompilationState previousCompileState = this.previousCompileStateCache.get();
        IncementalCompileSourceProcessor processor = this.incrementalCompileFilesFactory.filesFor(previousCompileState);
        for (File sourceFile : sourceFiles) {
            processor.processSource(sourceFile);
        }
        return processor.getResult();
    }
}

