/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.tasks;

import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.ExecSpec;
import org.gradle.util.CollectionUtils;

@Incubating
public class UnexportMainSymbol
extends SourceTask {
    private File mainObjectFile;
    private final DirectoryProperty outputFile = this.newOutputDirectory();

    public UnexportMainSymbol() {
        this.outputFile.set(this.getTemporaryDir());
    }

    @OutputFiles
    public FileCollection getOutputFiles() {
        return this.outputFile.getAsFileTree();
    }

    @InputFile
    @Optional
    public File getMainObject() {
        if (this.mainObjectFile == null) {
            this.mainObjectFile = this.findMainObject();
        }
        return this.mainObjectFile;
    }

    @TaskAction
    public void unexport() {
        final File mainObjectFile = this.getMainObject();
        if (mainObjectFile != null) {
            final File relocatedMainObject = this.outputFile.file(mainObjectFile.getName()).get().getAsFile();
            this.getProject().exec((Action<? super ExecSpec>)new Action<ExecSpec>(){

                @Override
                public void execute(ExecSpec execSpec) {
                    if (OperatingSystem.current().isMacOsX()) {
                        execSpec.executable("ld");
                        execSpec.args(mainObjectFile);
                        execSpec.args("-o", relocatedMainObject);
                        execSpec.args("-r");
                        execSpec.args("-unexported_symbol", "_main");
                    } else if (OperatingSystem.current().isLinux()) {
                        execSpec.executable("objcopy");
                        execSpec.args("-L", "main");
                        execSpec.args(mainObjectFile);
                        execSpec.args(relocatedMainObject);
                    } else {
                        throw new IllegalStateException("Do not know how to hide a main symbol on " + OperatingSystem.current());
                    }
                }
            });
            this.setDidWork(true);
        } else {
            this.setDidWork(this.getProject().delete(((Directory)this.outputFile.get()).getAsFile()));
        }
    }

    private File findMainObject() {
        Set<File> objectFiles = this.getSource().getFiles();
        if (objectFiles.isEmpty()) {
            return null;
        }
        if (objectFiles.size() == 1) {
            return objectFiles.iterator().next();
        }
        return CollectionUtils.findFirst(objectFiles, new Spec<File>(){

            @Override
            public boolean isSatisfiedBy(File objectFile) {
                return objectFile.getName().equalsIgnoreCase("main.o");
            }
        });
    }
}

