/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingModelProjection
implements ModelProjection {
    private final Iterable<? extends ModelProjection> projections;

    public ChainingModelProjection(Iterable<? extends ModelProjection> projections) {
        this.projections = projections;
    }

    @Override
    public <T> boolean canBeViewedAs(ModelType<T> type) {
        for (ModelProjection modelProjection : this.projections) {
            if (!modelProjection.canBeViewedAs(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<String> getTypeDescriptions(final MutableModelNode node) {
        return Iterables.concat((Iterable)Iterables.transform(this.projections, (Function)new Function<ModelProjection, Iterable<String>>(){

            public Iterable<String> apply(ModelProjection projection) {
                return projection.getTypeDescriptions(node);
            }
        }));
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asImmutable(ModelType<T> type, MutableModelNode node, ModelRuleDescriptor ruleDescriptor) {
        for (ModelProjection modelProjection : this.projections) {
            ModelView<T> view = modelProjection.asImmutable(type, node, ruleDescriptor);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> ModelView<? extends T> asMutable(ModelType<T> type, MutableModelNode node, ModelRuleDescriptor ruleDescriptor) {
        for (ModelProjection modelProjection : this.projections) {
            ModelView<T> view = modelProjection.asMutable(type, node, ruleDescriptor);
            if (view == null) continue;
            return view;
        }
        return null;
    }

    @Override
    public Optional<String> getValueDescription(MutableModelNode modelNodeInternal) {
        for (ModelProjection modelProjection : this.projections) {
            Optional<String> projectionValueDescription = modelProjection.getValueDescription(modelNodeInternal);
            if (!projectionValueDescription.isPresent()) continue;
            return projectionValueDescription;
        }
        return Optional.absent();
    }

    public String toString() {
        return "ChainingModelProjection{projections=" + this.projections + '}';
    }
}

