/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import java.lang.reflect.Array;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericArrayTypeWrapper
implements TypeWrapper {
    private final TypeWrapper componentType;
    private final int hashCode;

    public GenericArrayTypeWrapper(TypeWrapper componentType, int hashCode) {
        this.componentType = componentType;
        this.hashCode = hashCode;
    }

    public TypeWrapper getComponentType() {
        return this.componentType;
    }

    @Override
    public Class<?> getRawClass() {
        return Array.newInstance(this.componentType.getRawClass(), 0).getClass();
    }

    @Override
    public boolean isAssignableFrom(TypeWrapper wrapper) {
        if (wrapper instanceof GenericArrayTypeWrapper) {
            GenericArrayTypeWrapper arrayType = (GenericArrayTypeWrapper)wrapper;
            return this.componentType.isAssignableFrom(arrayType.componentType);
        }
        return false;
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        this.componentType.collectClasses(builder);
    }

    public boolean equals(Object o) {
        if (o instanceof GenericArrayTypeWrapper) {
            GenericArrayTypeWrapper that = (GenericArrayTypeWrapper)o;
            return this == that || this.componentType.equals(that.componentType);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    @Override
    public String getRepresentation(boolean full) {
        return this.componentType.getRepresentation(full) + "[]";
    }
}

