/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.toolchain.Gcc;
import org.gradle.platform.base.ToolChain;
import org.gradle.util.GFileUtils;

@Incubating
public class InstallExecutable
extends DefaultTask {
    private ToolChain toolChain;
    private NativePlatform platform;
    private final DirectoryProperty destinationDir;
    private final RegularFileProperty executable;
    private final ConfigurableFileCollection libs;
    private final WorkerLeaseService workerLeaseService;

    @Inject
    public InstallExecutable(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
        this.libs = this.getProject().files(new Object[0]);
        this.destinationDir = this.newOutputDirectory();
        this.executable = this.newInputFile();
    }

    @Internal
    public ToolChain getToolChain() {
        return this.toolChain;
    }

    public void setToolChain(ToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @Nested
    public NativePlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(NativePlatform platform) {
        this.platform = platform;
    }

    @OutputDirectory
    public DirectoryProperty getInstallDirectory() {
        return this.destinationDir;
    }

    @Deprecated
    @Internal
    public File getDestinationDir() {
        return this.destinationDir.getAsFile().getOrNull();
    }

    @Deprecated
    public void setDestinationDir(File destinationDir) {
        this.destinationDir.set(destinationDir);
    }

    @Internal(value="Covered by inputFileIfExists")
    public RegularFileProperty getSourceFile() {
        return this.executable;
    }

    @Deprecated
    @Internal(value="Covered by inputFileIfExists")
    public File getExecutable() {
        return this.executable.getAsFile().getOrNull();
    }

    @Deprecated
    public void setExecutable(File executable) {
        this.executable.set(executable);
    }

    @SkipWhenEmpty
    @Optional
    @InputFile
    protected File getInputFileIfExists() {
        RegularFileProperty sourceFile = this.getSourceFile();
        if (sourceFile.isPresent() && ((RegularFile)sourceFile.get()).getAsFile().exists()) {
            return ((RegularFile)sourceFile.get()).getAsFile();
        }
        return null;
    }

    @InputFiles
    public FileCollection getLibs() {
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs.setFrom(libs);
    }

    public void lib(Object libs) {
        this.libs.from(libs);
    }

    @Internal(value="covered by getInstallDirectory")
    public File getRunScript() {
        return this.getRunScriptFile().get().getAsFile();
    }

    @Internal(value="covered by getInstallDirectory")
    public Provider<RegularFile> getRunScriptFile() {
        return this.destinationDir.file(this.executable.map(new Transformer<CharSequence, RegularFile>(){

            @Override
            public CharSequence transform(RegularFile regularFile) {
                OperatingSystem operatingSystem = OperatingSystem.forName(InstallExecutable.this.platform.getOperatingSystem().getName());
                return operatingSystem.getScriptName(regularFile.getAsFile().getName());
            }
        }));
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void install() {
        this.workerLeaseService.withoutProjectLock(new Runnable(){

            @Override
            public void run() {
                if (InstallExecutable.this.platform.getOperatingSystem().isWindows()) {
                    InstallExecutable.this.installWindows();
                } else {
                    InstallExecutable.this.installUnix();
                }
            }
        });
    }

    private void installWindows() {
        File destination = ((Directory)this.getInstallDirectory().get()).getAsFile();
        File executable = ((RegularFile)this.getSourceFile().get()).getAsFile();
        this.installToDir(new File(destination, "lib"));
        StringBuilder toolChainPath = new StringBuilder();
        if (this.toolChain instanceof Gcc) {
            toolChainPath.append("SET PATH=");
            for (File pathEntry : ((Gcc)this.toolChain).getPath()) {
                toolChainPath.append(pathEntry.getAbsolutePath()).append(";");
            }
            toolChainPath.append("%PATH%");
        }
        String runScriptText = "\n@echo off\nSETLOCAL\n" + toolChainPath + "\nCALL \"%~dp0lib\\" + executable.getName() + "\" %*" + "\nEXIT /B %ERRORLEVEL%" + "\nENDLOCAL" + "\n";
        GFileUtils.writeFile(runScriptText, this.getRunScript());
    }

    private void installUnix() {
        File destination = ((Directory)this.getInstallDirectory().get()).getAsFile();
        File executable = ((RegularFile)this.getSourceFile().get()).getAsFile();
        this.installToDir(new File(destination, "lib"));
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nDYLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport DYLD_LIBRARY_PATH\nLD_LIBRARY_PATH=\"$APP_BASE_NAME/lib\"\nexport LD_LIBRARY_PATH\nexec \"$APP_BASE_NAME/lib/" + executable.getName() + "\" \"$@\"" + "\n";
        GFileUtils.writeFile(runScriptText, this.getRunScript());
        this.getFileSystem().chmod(this.getRunScript(), 493);
    }

    private void installToDir(final File binaryDir) {
        this.getFileOperations().sync((Action<? super CopySpec>)new Action<CopySpec>(){

            @Override
            public void execute(CopySpec copySpec) {
                copySpec.into(binaryDir);
                copySpec.from(InstallExecutable.this.getSourceFile());
                copySpec.from(InstallExecutable.this.getLibs());
            }
        });
    }
}

