/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.plugins;

import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.TypeBuilder;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.plugins.ComponentBasePlugin;

@Incubating
public class BinaryBasePlugin
implements Plugin<Project> {
    @Override
    public void apply(Project target) {
        target.getPluginManager().apply(ComponentBasePlugin.class);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        void binaries(BinaryContainer binaries) {
        }

        @ComponentType
        void registerBaseBinarySpec(TypeBuilder<BinarySpec> builder) {
            builder.defaultImplementation(BaseBinarySpec.class);
            builder.internalView(BinarySpecInternal.class);
        }

        @Mutate
        void copyBinaryTasksToTaskContainer(TaskContainer tasks, BinaryContainer binaries) {
            for (BinarySpec binary : binaries) {
                tasks.addAll(binary.getTasks());
                Task buildTask = binary.getBuildTask();
                if (buildTask == null) continue;
                tasks.add(buildTask);
            }
        }

        @Finalize
        public void defineBuildLifecycleTask(@Each BinarySpecInternal binary, ITaskFactory taskFactory) {
            if (binary.isLegacyBinary()) {
                return;
            }
            TaskInternal binaryLifecycleTask = taskFactory.create(binary.getProjectScopedName(), DefaultTask.class);
            binaryLifecycleTask.setGroup("build");
            binaryLifecycleTask.setDescription(String.format("Assembles %s.", binary));
            binary.setBuildTask(binaryLifecycleTask);
        }

        @Finalize
        void addSourceSetsOwnedByBinariesToTheirInputs(@Each BinarySpecInternal binary) {
            if (binary.isLegacyBinary()) {
                return;
            }
            binary.getInputs().addAll(binary.getSources().values());
        }
    }
}

