/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.management.internal.autoapply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequestInternal;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginRegistry;

public class DefaultAutoAppliedPluginHandler
implements AutoAppliedPluginHandler {
    private final AutoAppliedPluginRegistry registry;

    public DefaultAutoAppliedPluginHandler(AutoAppliedPluginRegistry registry) {
        this.registry = registry;
    }

    @Override
    public PluginRequests mergeWithAutoAppliedPlugins(PluginRequests initialRequests, Object pluginTarget) {
        if (!(pluginTarget instanceof Project)) {
            return initialRequests;
        }
        Project project = (Project)pluginTarget;
        PluginRequests autoAppliedPlugins = this.registry.getAutoAppliedPlugins(project);
        if (autoAppliedPlugins.isEmpty()) {
            return initialRequests;
        }
        List<PluginRequestInternal> filteredAutoAppliedPlugins = this.filterAlreadyAppliedOrRequested(autoAppliedPlugins, initialRequests, project);
        ArrayList<PluginRequestInternal> merged = new ArrayList<PluginRequestInternal>(initialRequests.size() + autoAppliedPlugins.size());
        merged.addAll(filteredAutoAppliedPlugins);
        merged.addAll((Collection<PluginRequestInternal>)ImmutableList.copyOf((Iterable)initialRequests));
        return new DefaultPluginRequests(merged);
    }

    private List<PluginRequestInternal> filterAlreadyAppliedOrRequested(PluginRequests autoAppliedPlugins, final PluginRequests initialRequests, final Project project) {
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)autoAppliedPlugins, (Predicate)new Predicate<PluginRequestInternal>(){

            public boolean apply(PluginRequestInternal autoAppliedPlugin) {
                return !DefaultAutoAppliedPluginHandler.isAlreadyAppliedOrRequested(autoAppliedPlugin, initialRequests, project);
            }
        }));
    }

    private static boolean isAlreadyAppliedOrRequested(PluginRequestInternal autoAppliedPlugin, PluginRequests requests, Project project) {
        return DefaultAutoAppliedPluginHandler.isAlreadyApplied(autoAppliedPlugin, project) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInPluginsBlock(autoAppliedPlugin, requests) || DefaultAutoAppliedPluginHandler.isAlreadyRequestedInBuildScriptBlock(autoAppliedPlugin, project);
    }

    private static boolean isAlreadyApplied(PluginRequestInternal autoAppliedPlugin, Project project) {
        return project.getPlugins().hasPlugin(autoAppliedPlugin.getId().getId());
    }

    private static boolean isAlreadyRequestedInPluginsBlock(PluginRequestInternal autoAppliedPlugin, PluginRequests requests) {
        for (PluginRequestInternal request : requests) {
            if (!autoAppliedPlugin.getId().equals(request.getId())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyRequestedInBuildScriptBlock(PluginRequestInternal autoAppliedPlugin, Project project) {
        ModuleVersionSelector module = autoAppliedPlugin.getModule();
        if (module == null) {
            return false;
        }
        Configuration classpathConfiguration = project.getBuildscript().getConfigurations().getByName("classpath");
        for (Dependency dependency : classpathConfiguration.getDependencies()) {
            if (!module.getGroup().equals(dependency.getGroup()) || !module.getName().equals(dependency.getName())) continue;
            return true;
        }
        return false;
    }
}

