/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.util.ConfigureUtil;

public class EclipseJdt {
    private JavaVersion sourceCompatibility = JavaVersion.current();
    private JavaVersion targetCompatibility = JavaVersion.current();
    private String javaRuntimeName;
    private final PropertiesFileContentMerger file;

    public EclipseJdt(PropertiesFileContentMerger file) {
        this.file = file;
    }

    public JavaVersion getSourceCompatibility() {
        return this.sourceCompatibility;
    }

    public void setSourceCompatibility(JavaVersion sourceCompatibility) {
        this.setSourceCompatibility((Object)sourceCompatibility);
    }

    public void setSourceCompatibility(Object sourceCompatibility) {
        JavaVersion version = JavaVersion.toVersion(sourceCompatibility);
        if (version != null) {
            this.sourceCompatibility = version;
        }
    }

    public JavaVersion getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(JavaVersion targetCompatibility) {
        this.setTargetCompatibility((Object)targetCompatibility);
    }

    public void setTargetCompatibility(Object targetCompatibility) {
        JavaVersion version = JavaVersion.toVersion(targetCompatibility);
        if (version != null) {
            this.targetCompatibility = version;
        }
    }

    @Incubating
    public String getJavaRuntimeName() {
        return this.javaRuntimeName;
    }

    @Incubating
    public void setJavaRuntimeName(String javaRuntimeName) {
        this.javaRuntimeName = javaRuntimeName;
    }

    public PropertiesFileContentMerger getFile() {
        return this.file;
    }

    public void file(Closure closure) {
        ConfigureUtil.configure(closure, this.file);
    }

    public void file(Action<? super PropertiesFileContentMerger> action) {
        action.execute(this.file);
    }
}

