/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class KeyboardNavigationDetector
extends LayoutDetector {
    public static final String MESSAGE = "'clickable' attribute found, please also add 'focusable'";
    public static final Issue ISSUE = Issue.create("KeyboardInaccessibleWidget", "Keyboard inaccessible widget", "A widget that is declared to be clickable but not declared to be focusable is not accessible via the keyboard. Please add the `focusable` attribute as well.", Category.A11Y, 3, Severity.WARNING, new Implementation(KeyboardNavigationDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("clickable");
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        if ("true".equals(attribute.getOwnerElement().getAttributeNS("http://schemas.android.com/apk/res/android", "focusable"))) {
            return;
        }
        if ("true".equals(attribute.getValue()) && context.getMainProject().getMinSdkVersion().getApiLevel() < 26) {
            LintFix fix = KeyboardNavigationDetector.fix().set("http://schemas.android.com/apk/res/android", "focusable", "true").build();
            context.report(ISSUE, (Node)attribute, context.getLocation(attribute), MESSAGE, fix);
        }
    }
}

