/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public class ServiceCastDetector
extends Detector
implements Detector.UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(ServiceCastDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ServiceCast", "Wrong system service casts", "When you call `Context#getSystemService()`, the result is typically cast to a specific interface. This lint check ensures that the cast is compatible with the expected type of the return value.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue WIFI_MANAGER = Issue.create("WifiManagerLeak", "WifiManager Leak", "On versions prior to Android N (24), initializing the `WifiManager` via `Context#getSystemService` can cause a memory leak if the context is not the application context. Change `context.getSystemService(...)` to `context.getApplicationContext().getSystemService(...)`.", Category.CORRECTNESS, 6, Severity.FATAL, IMPLEMENTATION);
    public static final Issue WIFI_MANAGER_UNCERTAIN = Issue.create("WifiManagerPotentialLeak", "WifiManager Potential Leak", "On versions prior to Android N (24), initializing the `WifiManager` via `Context#getSystemService` can cause a memory leak if the context is not the application context.\n\nIn many cases, it's not obvious from the code where the `Context` is coming from (e.g. it might be a parameter to a method, or a field initialized from various method calls.)  It's possible that the context being passed in is the application context, but to be on the safe side, you should consider changing `context.getSystemService(...)` to `context.getApplicationContext().getSystemService(...)`.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    private static final String GET_APPLICATION_CONTEXT = "getApplicationContext";
    private static final String WIFI_SERVICE = "WIFI_SERVICE";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("getSystemService");
    }

    @Override
    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        List args = call.getValueArguments();
        if (args.size() == 1 && args.get(0) instanceof UReferenceExpression) {
            UElement parent;
            PsiElement resolvedServiceConst = ((UReferenceExpression)args.get(0)).resolve();
            if (!(resolvedServiceConst instanceof PsiField)) {
                return;
            }
            String name = ((PsiField)resolvedServiceConst).getName();
            if (WIFI_SERVICE.equals(name)) {
                ServiceCastDetector.checkWifiService(context, call);
            }
            if (UastExpressionUtils.isTypeCast((UElement)(parent = LintUtils.skipParentheses(UastUtils.getQualifiedParentOrThis((UExpression)call).getUastParent())))) {
                UBinaryExpressionWithType cast = (UBinaryExpressionWithType)parent;
                String expectedClass = ServiceCastDetector.getExpectedType(name);
                if (expectedClass != null && cast != null) {
                    String castType = cast.getType().getCanonicalText();
                    if (castType.indexOf(46) == -1) {
                        expectedClass = ServiceCastDetector.stripPackage(expectedClass);
                    }
                    if (!castType.equals(expectedClass)) {
                        if (ServiceCastDetector.isClipboard(castType) && ServiceCastDetector.isClipboard(expectedClass)) {
                            return;
                        }
                        String message = String.format("Suspicious cast to `%1$s` for a `%2$s`: expected `%3$s`", ServiceCastDetector.stripPackage(castType), name, ServiceCastDetector.stripPackage(expectedClass));
                        context.report(ISSUE, (UElement)call, context.getLocation((UElement)cast), message);
                    }
                }
            }
        }
    }

    private static void checkWifiService(JavaContext context, UCallExpression call) {
        JavaEvaluator evaluator = context.getEvaluator();
        UExpression qualifier = call.getReceiver();
        PsiMethod resolvedMethod = call.resolve();
        if (resolvedMethod != null && (evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.app.Activity", false) || evaluator.isMemberInSubClassOf((PsiMember)resolvedMethod, "android.view.View", false))) {
            ServiceCastDetector.reportWifiServiceLeak(WIFI_MANAGER, context, call);
            return;
        }
        if (qualifier == null) {
            UMethod currentMethod = (UMethod)UastUtils.getParentOfType((UElement)call, UMethod.class, (boolean)true);
            if (currentMethod != null && !evaluator.isMemberInSubClassOf((PsiMember)currentMethod, "android.app.Application", true)) {
                ServiceCastDetector.reportWifiServiceLeak(WIFI_MANAGER, context, call);
            }
        } else {
            ServiceCastDetector.checkContextReference(context, (UElement)qualifier, call);
        }
    }

    private static boolean checkContextReference(JavaContext context, UElement element, UCallExpression call) {
        if (element == null) {
            return false;
        }
        if (element instanceof UCallExpression) {
            PsiMethod resolvedMethod = ((UCallExpression)element).resolve();
            if (resolvedMethod != null && !GET_APPLICATION_CONTEXT.equals(resolvedMethod.getName())) {
                ServiceCastDetector.reportWifiServiceLeak(WIFI_MANAGER, context, call);
                return true;
            }
        } else if (element instanceof UQualifiedReferenceExpression) {
            UQualifiedReferenceExpression refExp = (UQualifiedReferenceExpression)element;
            PsiElement resolved = refExp.resolve();
            if (resolved instanceof PsiMethod && !GET_APPLICATION_CONTEXT.equals(refExp.getResolvedName())) {
                ServiceCastDetector.reportWifiServiceLeak(WIFI_MANAGER, context, call);
                return true;
            }
        } else if (element instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)element).resolve();
            if (resolved instanceof PsiField) {
                PsiType type = ((PsiField)resolved).getType();
                return ServiceCastDetector.checkWifiContextType(context, call, type, true);
            }
            if (resolved instanceof PsiParameter) {
                PsiType type = ((PsiParameter)resolved).getType();
                return ServiceCastDetector.checkWifiContextType(context, call, type, true);
            }
            if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)resolved;
                PsiType type = variable.getType();
                if (ServiceCastDetector.checkWifiContextType(context, call, type, false)) {
                    return true;
                }
                UExpression lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)variable, (UElement)call);
                if (lastAssignment != null) {
                    return ServiceCastDetector.checkContextReference(context, (UElement)lastAssignment, call);
                }
            }
        }
        return false;
    }

    private static boolean checkWifiContextType(JavaContext context, UCallExpression call, PsiType type, boolean flagPlainContext) {
        PsiClass psiClass;
        JavaEvaluator evaluator = context.getEvaluator();
        if (type instanceof PsiClassType && evaluator.extendsClass(psiClass = ((PsiClassType)type).resolve(), "android.app.Application", false)) {
            return false;
        }
        if (evaluator.typeMatches(type, "android.content.Context")) {
            if (flagPlainContext) {
                ServiceCastDetector.reportWifiServiceLeak(WIFI_MANAGER_UNCERTAIN, context, call);
                return true;
            }
            return false;
        }
        ServiceCastDetector.reportWifiServiceLeak(WIFI_MANAGER, context, call);
        return true;
    }

    private static void reportWifiServiceLeak(Issue issue, JavaContext context, UCallExpression call) {
        LintFix fix;
        if (context.getMainProject().getMinSdk() >= 24) {
            return;
        }
        String message = "The WIFI_SERVICE must be looked up on the Application context or memory will leak on devices < Android N. ";
        if (call.getReceiver() != null) {
            String qualifier = call.getReceiver().asSourceString();
            message = message + String.format("Try changing `%1$s` to `%1$s.getApplicationContext()`", qualifier);
            fix = ServiceCastDetector.fix().name("Add getApplicationContext()").replace().text(qualifier).with(qualifier + ".getApplicationContext()").build();
        } else {
            String qualifier = call.getMethodName();
            message = message + String.format("Try changing `%1$s` to `getApplicationContext().%1$s`", qualifier);
            fix = ServiceCastDetector.fix().name("Add getApplicationContext()").replace().text(qualifier).with("getApplicationContext()." + qualifier).build();
        }
        context.report(issue, (UElement)call, context.getLocation((UElement)call), message, fix);
    }

    private static boolean isClipboard(String cls) {
        return cls.equals("android.content.ClipboardManager") || cls.equals("android.text.ClipboardManager");
    }

    private static String stripPackage(String fqcn) {
        int index = fqcn.lastIndexOf(46);
        if (index != -1) {
            fqcn = fqcn.substring(index + 1);
        }
        return fqcn;
    }

    private static String getExpectedType(String value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case "ACCESSIBILITY_SERVICE": {
                return "android.view.accessibility.AccessibilityManager";
            }
            case "ACCOUNT_SERVICE": {
                return "android.accounts.AccountManager";
            }
            case "ACTIVITY_SERVICE": {
                return "android.app.ActivityManager";
            }
            case "ALARM_SERVICE": {
                return "android.app.AlarmManager";
            }
            case "APPWIDGET_SERVICE": {
                return "android.appwidget.AppWidgetManager";
            }
            case "APP_OPS_SERVICE": {
                return "android.app.AppOpsManager";
            }
            case "AUDIO_SERVICE": {
                return "android.media.AudioManager";
            }
            case "BATTERY_SERVICE": {
                return "android.os.BatteryManager";
            }
            case "BLUETOOTH_SERVICE": {
                return "android.bluetooth.BluetoothManager";
            }
            case "CAMERA_SERVICE": {
                return "android.hardware.camera2.CameraManager";
            }
            case "CAPTIONING_SERVICE": {
                return "android.view.accessibility.CaptioningManager";
            }
            case "CARRIER_CONFIG_SERVICE": {
                return "android.telephony.CarrierConfigManager";
            }
            case "CLIPBOARD_SERVICE": {
                return "android.text.ClipboardManager";
            }
            case "COMPANION_DEVICE_SERVICE": {
                return "android.companion.CompanionDeviceManager";
            }
            case "CONNECTIVITY_SERVICE": {
                return "android.net.ConnectivityManager";
            }
            case "CONSUMER_IR_SERVICE": {
                return "android.hardware.ConsumerIrManager";
            }
            case "DEVICE_POLICY_SERVICE": {
                return "android.app.admin.DevicePolicyManager";
            }
            case "DISPLAY_SERVICE": {
                return "android.hardware.display.DisplayManager";
            }
            case "DOWNLOAD_SERVICE": {
                return "android.app.DownloadManager";
            }
            case "DROPBOX_SERVICE": {
                return "android.os.DropBoxManager";
            }
            case "FINGERPRINT_SERVICE": {
                return "android.hardware.fingerprint.FingerprintManager";
            }
            case "HARDWARE_PROPERTIES_SERVICE": {
                return "android.os.HardwarePropertiesManager";
            }
            case "INPUT_METHOD_SERVICE": {
                return "android.view.inputmethod.InputMethodManager";
            }
            case "INPUT_SERVICE": {
                return "android.hardware.input.InputManager";
            }
            case "IPSEC_SERVICE": {
                return "android.net.IpSecManager";
            }
            case "JOB_SCHEDULER_SERVICE": {
                return "android.app.job.JobScheduler";
            }
            case "KEYGUARD_SERVICE": {
                return "android.app.KeyguardManager";
            }
            case "LAUNCHER_APPS_SERVICE": {
                return "android.content.pm.LauncherApps";
            }
            case "LAYOUT_INFLATER_SERVICE": {
                return "android.view.LayoutInflater";
            }
            case "LOCATION_SERVICE": {
                return "android.location.LocationManager";
            }
            case "MEDIA_PROJECTION_SERVICE": {
                return "android.media.projection.MediaProjectionManager";
            }
            case "MEDIA_ROUTER_SERVICE": {
                return "android.media.MediaRouter";
            }
            case "MEDIA_SESSION_SERVICE": {
                return "android.media.session.MediaSessionManager";
            }
            case "MIDI_SERVICE": {
                return "android.media.midi.MidiManager";
            }
            case "NETWORK_STATS_SERVICE": {
                return "android.app.usage.NetworkStatsManager";
            }
            case "NFC_SERVICE": {
                return "android.nfc.NfcManager";
            }
            case "NOTIFICATION_SERVICE": {
                return "android.app.NotificationManager";
            }
            case "NSD_SERVICE": {
                return "android.net.nsd.NsdManager";
            }
            case "POWER_SERVICE": {
                return "android.os.PowerManager";
            }
            case "PRINT_SERVICE": {
                return "android.print.PrintManager";
            }
            case "RESTRICTIONS_SERVICE": {
                return "android.content.RestrictionsManager";
            }
            case "SEARCH_SERVICE": {
                return "android.app.SearchManager";
            }
            case "SENSOR_SERVICE": {
                return "android.hardware.SensorManager";
            }
            case "SHORTCUT_SERVICE": {
                return "android.content.pm.ShortcutManager";
            }
            case "STORAGE_SERVICE": {
                return "android.os.storage.StorageManager";
            }
            case "STORAGE_STATS_SERVICE": {
                return "android.app.usage.StorageStatsManager";
            }
            case "SYSTEM_HEALTH_SERVICE": {
                return "android.os.health.SystemHealthManager";
            }
            case "TELECOM_SERVICE": {
                return "android.telecom.TelecomManager";
            }
            case "TELEPHONY_SERVICE": {
                return "android.telephony.TelephonyManager";
            }
            case "TELEPHONY_SUBSCRIPTION_SERVICE": {
                return "android.telephony.SubscriptionManager";
            }
            case "TEXT_CLASSIFICATION_SERVICE": {
                return "android.view.textclassifier.TextClassificationManager";
            }
            case "TEXT_SERVICES_MANAGER_SERVICE": {
                return "android.view.textservice.TextServicesManager";
            }
            case "TV_INPUT_SERVICE": {
                return "android.media.tv.TvInputManager";
            }
            case "UI_MODE_SERVICE": {
                return "android.app.UiModeManager";
            }
            case "USAGE_STATS_SERVICE": {
                return "android.app.usage.UsageStatsManager";
            }
            case "USB_SERVICE": {
                return "android.hardware.usb.UsbManager";
            }
            case "USER_SERVICE": {
                return "android.os.UserManager";
            }
            case "VIBRATOR_SERVICE": {
                return "android.os.Vibrator";
            }
            case "WALLPAPER_SERVICE": {
                return "android.app.WallpaperManager";
            }
            case "WIFI_AWARE_SERVICE": {
                return "android.net.wifi.aware.WifiAwareManager";
            }
            case "WIFI_P2P_SERVICE": {
                return "android.net.wifi.p2p.WifiP2pManager";
            }
            case "WIFI_SERVICE": {
                return "android.net.wifi.WifiManager";
            }
            case "WINDOW_SERVICE": {
                return "android.view.WindowManager";
            }
        }
        return null;
    }
}

