/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.ActionTarget;
import com.android.tools.idea.common.scene.target.DragBaseTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.naveditor.scene.targets.ActionHandleTarget;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.MultiComponentTarget;
import com.android.tools.idea.uibuilder.handlers.coordinator.CoordinatorSnapTarget;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scene
implements SelectionListener,
Disposable {
    private static final int DRAG_THRESHOLD = JBUI.scale((int)10);
    private final DesignSurface myDesignSurface;
    private final SceneManager mySceneManager;
    private static final boolean DEBUG = false;
    private final HashMap<NlComponent, SceneComponent> mySceneComponents;
    private SceneComponent myRoot;
    private boolean myIsAnimated;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private long myDisplayListVersion;
    private Target myOverTarget;
    private Target mySnapTarget;
    private SceneComponent myCurrentComponent;
    private int mNeedsLayout;
    protected int myPressedMouseX;
    protected int myPressedMouseY;
    private int myLastMouseX;
    private int myLastMouseY;
    private HitListener myHoverListener;
    private HitListener myHitListener;
    private HitListener myFindListener;
    private HitListener mySnapListener;
    private Target myHitTarget;
    private Cursor myMouseCursor;
    private SceneComponent myHitComponent;
    ArrayList<SceneComponent> myNewSelectedComponents;
    private boolean myIsControlDown;
    private boolean myIsShiftDown;
    private boolean myIsAltDown;
    private boolean myShowAllConstraints;
    private FilterType myFilterTarget;

    public Scene(@NotNull Disposable parentDisposable, @NotNull DesignSurface surface) {
        if (parentDisposable == null) {
            Scene.$$$reportNull$$$0(0);
        }
        if (surface == null) {
            Scene.$$$reportNull$$$0(1);
        }
        this.mySceneComponents = new HashMap();
        this.myIsAnimated = true;
        this.myDisplayListVersion = 1L;
        this.mNeedsLayout = 0;
        this.myHoverListener = new HitListener();
        this.myHitListener = new HitListener();
        this.myFindListener = new HitListener();
        this.mySnapListener = new HitListener();
        this.myHitTarget = null;
        this.myNewSelectedComponents = new ArrayList();
        this.myShowAllConstraints = false;
        this.myFilterTarget = FilterType.NONE;
        this.myDesignSurface = surface;
        this.mySceneManager = this.myDesignSurface.getSceneManager();
        this.myDesignSurface.getSelectionModel().addListener(this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    public void dispose() {
        this.myDesignSurface.getSelectionModel().removeListener(this);
    }

    @NotNull
    public SceneManager getSceneManager() {
        SceneManager sceneManager = this.mySceneManager;
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(2);
        }
        return sceneManager;
    }

    public boolean supportsRTL() {
        return true;
    }

    public boolean isInRTL() {
        Configuration configuration = this.myDesignSurface.getConfiguration();
        if (configuration == null) {
            return false;
        }
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public boolean isAnimated() {
        return this.myIsAnimated;
    }

    public void setAnimated(boolean animated) {
        this.myIsAnimated = animated;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component2) {
        if (component2 == null) {
            return null;
        }
        return this.mySceneComponents.get(component2);
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            Scene.$$$reportNull$$$0(3);
        }
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myDesignSurface.getSelectionModel().getSelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public Cursor getMouseCursor() {
        return this.myMouseCursor;
    }

    public boolean isAutoconnectOn() {
        return PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceAutoConnect", false);
    }

    public boolean isShowAllConstraints() {
        return this.myShowAllConstraints || PropertiesComponent.getInstance().getBoolean("ConstraintLayoutPreferenceShowAllConstraints");
    }

    public void setShowAllConstraints(boolean showAllConstraints) {
        this.myShowAllConstraints = showAllConstraints;
    }

    public void updateModifiers(int modifiers) {
        this.myIsControlDown = (modifiers & 0x80) != 0 || (modifiers & 2) != 0;
        this.myIsShiftDown = (modifiers & 0x40) != 0 || (modifiers & 1) != 0;
        this.myIsAltDown = (modifiers & 0x200) != 0 || (modifiers & 8) != 0;
    }

    public boolean isControlDown() {
        return this.myIsControlDown;
    }

    public boolean isShiftDown() {
        return this.myIsShiftDown;
    }

    public boolean isAltDown() {
        return this.myIsAltDown;
    }

    public void clearAttributes() {
        if (this.myRoot != null) {
            this.myRoot.clearAttributes();
        }
        this.select(Collections.emptyList());
    }

    public void addComponent(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(4);
        }
        this.mySceneComponents.put(component2.getNlComponent(), component2);
        this.needsRebuildList();
    }

    public void removeComponent(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(5);
        }
        component2.removeFromParent();
        this.mySceneComponents.remove(component2.getNlComponent(), component2);
        this.needsRebuildList();
    }

    void removeAllComponents() {
        Iterator<Map.Entry<NlComponent, SceneComponent>> it = this.mySceneComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NlComponent, SceneComponent> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model, @NotNull List<NlComponent> selection) {
        if (model == null) {
            Scene.$$$reportNull$$$0(6);
        }
        if (selection == null) {
            Scene.$$$reportNull$$$0(7);
        }
        if (this.myRoot != null) {
            this.myRoot.markSelection(selection);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneView sceneView) {
        void sceneView2;
        if (displayList == null) {
            Scene.$$$reportNull$$$0(8);
        }
        this.buildDisplayList(displayList, time2, SceneContext.get((SceneView)sceneView2));
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time2) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(9);
        }
        this.layout(time2, SceneContext.get());
        this.buildDisplayList(displayList, time2, SceneContext.get());
    }

    public void repaint() {
        this.myDesignSurface.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneContext sceneContext) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(10);
        }
        if (this.myRoot != null) {
            void sceneContext2;
            this.myRoot.buildDisplayList(time2, displayList, (SceneContext)sceneContext2);
        }
    }

    public boolean layout(long time2, SceneContext sceneContext) {
        boolean needsToRebuildDisplayList = false;
        if (this.myRoot != null && (needsToRebuildDisplayList = this.myRoot.layout(sceneContext, time2))) {
            this.needsRebuildList();
        }
        return needsToRebuildDisplayList;
    }

    public void select(List<SceneComponent> components) {
        if (this.myDesignSurface != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.myIsShiftDown) {
                ImmutableList<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
                nlComponents.addAll((Collection<NlComponent>)selection);
            }
            for (SceneComponent sceneComponent : components) {
                NlComponent nlComponent = sceneComponent.getNlComponent();
                if (this.myIsShiftDown && nlComponents.contains(nlComponent)) {
                    nlComponents.remove(nlComponent);
                    continue;
                }
                nlComponents.add(nlComponent);
            }
            this.myDesignSurface.getSelectionModel().setSelection(nlComponents);
        }
    }

    public boolean allowsTarget(Target target) {
        SceneComponent component2 = target.getComponent();
        if (component2.isSelected()) {
            boolean hasBaselineConnection;
            boolean bl = hasBaselineConnection = component2.getAuthoritativeNlComponent().getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
            if (target instanceof AnchorTarget) {
                AnchorTarget anchor = (AnchorTarget)target;
                if (anchor.getType() == AnchorTarget.Type.BASELINE) {
                    return component2.canShowBaseline() || hasBaselineConnection;
                }
                return !hasBaselineConnection && !component2.canShowBaseline() || hasBaselineConnection && anchor.isHorizontalAnchor();
            }
            if (component2.canShowBaseline()) {
                return target instanceof ActionTarget || target instanceof ConstraintDragTarget || target instanceof DragBaseTarget || target instanceof ResizeBaseTarget;
            }
            return !component2.isDragging();
        }
        if (target instanceof CoordinatorSnapTarget) {
            return true;
        }
        if (target instanceof AnchorTarget) {
            AnchorTarget anchor = (AnchorTarget)target;
            if (this.myFilterTarget == FilterType.BASELINE_ANCHOR) {
                return anchor.getType() == AnchorTarget.Type.BASELINE;
            }
            if (this.myFilterTarget == FilterType.VERTICAL_ANCHOR && anchor.isVerticalAnchor()) {
                return true;
            }
            if (this.myFilterTarget == FilterType.HORIZONTAL_ANCHOR && anchor.isHorizontalAnchor()) {
                return true;
            }
            if (this.myFilterTarget == FilterType.ANCHOR) {
                return true;
            }
        }
        if (this.myFilterTarget == FilterType.RESIZE && target instanceof ResizeBaseTarget) {
            return true;
        }
        if (target instanceof MultiComponentTarget) {
            return true;
        }
        if (target instanceof DragBaseTarget) {
            return true;
        }
        if (target instanceof LassoTarget) {
            return true;
        }
        if (target instanceof GuidelineCycleTarget) {
            return true;
        }
        if (target instanceof ActionTarget) {
            return false;
        }
        return this.myFilterTarget == FilterType.ALL;
    }

    public void mouseHover(@NotNull SceneContext transform, int x, int y) {
        SceneComponent closestComponent;
        Target snapTarget;
        if (transform == null) {
            Scene.$$$reportNull$$$0(11);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myRoot != null) {
            this.myHoverListener.find(transform, this.myRoot, x, y);
            this.mySnapListener.find(transform, this.myRoot, x, y);
        }
        this.repaint();
        Target closestTarget = this.myHoverListener.getClosestTarget();
        if (this.myOverTarget != closestTarget) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setOver(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setOver(true);
                transform.setToolTip(closestTarget.getToolTipText());
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (closestTarget != null && (snapTarget = this.myHoverListener.getFilteredTarget(closestTarget)) != this.mySnapTarget) {
            if (this.mySnapTarget != null) {
                this.mySnapTarget.setOver(false);
                this.mySnapTarget = null;
                this.needsRebuildList();
            }
            if (snapTarget != null) {
                snapTarget.setOver(true);
                transform.setToolTip(closestTarget.getToolTipText());
                this.mySnapTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (this.myCurrentComponent != (closestComponent = this.myHoverListener.getClosestComponent())) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
        }
        this.setCursor(transform, x, y);
    }

    private void setCursor(@NotNull SceneContext transform, int x, int y) {
        int max;
        SelectionHandle handle;
        if (transform == null) {
            Scene.$$$reportNull$$$0(12);
        }
        this.myMouseCursor = Cursor.getDefaultCursor();
        if (this.myCurrentComponent != null && this.myCurrentComponent.isDragging()) {
            this.myMouseCursor = Cursor.getPredefinedCursor(13);
            return;
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor();
            return;
        }
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        if (!selectionModel.isEmpty() && (handle = selectionModel.findHandle(x, y, max = Coordinates.getAndroidDimensionDip(this.myDesignSurface, 10))) != null) {
            this.myMouseCursor = handle.getCursor();
            return;
        }
        SceneComponent component2 = this.findComponent(transform, x, y);
        if (component2 != null && component2.getParent() != null) {
            this.myMouseCursor = Cursor.getPredefinedCursor(12);
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    ArrayList<Target> list = new ArrayList<Target>();
                    list.add(closestTarget);
                    target.mouseDrag(x, y, list);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            int count = selection.size();
            for (int i = 0; i < count; ++i) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseRelease(x, y, Collections.singletonList(closestTarget));
                }
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform, int x, int y) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(13);
        }
        this.myPressedMouseX = x;
        this.myPressedMouseY = y;
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterTarget = FilterType.NONE;
        if (this.myRoot == null) {
            return;
        }
        this.myHitListener.find(transform, this.myRoot, x, y);
        this.myHitTarget = this.myHitListener.getClosestTarget();
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            if (this.myHitTarget instanceof AnchorTarget) {
                AnchorTarget anchor = (AnchorTarget)this.myHitTarget;
                this.myFilterTarget = anchor.isHorizontalAnchor() ? FilterType.HORIZONTAL_ANCHOR : FilterType.VERTICAL_ANCHOR;
                if (anchor.getType() == AnchorTarget.Type.BASELINE) {
                    this.myFilterTarget = FilterType.BASELINE_ANCHOR;
                }
            }
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        }
    }

    public void mouseDrag(@NotNull SceneContext transform, int x, int y) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(14);
        }
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            if (!this.myHitTarget.getComponent().isDragging() && !this.myDesignSurface.getSelectionModel().isSelected(this.myHitTarget.getComponent().getNlComponent()) && Scene.isWithinThreshold(this.myPressedMouseX, x, transform) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform)) {
                return;
            }
            this.myHitListener.skipTarget(this.myHitTarget);
            this.myHitListener.find(transform, this.myRoot, x, y);
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.myHitTargets);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
            this.myHitListener.skipTarget(null);
        }
        this.mouseHover(transform, x, y);
        this.checkRequestLayoutStatus();
    }

    private static boolean isWithinThreshold(int pos1, int pos2, SceneContext transform) {
        int pos4;
        int pos3 = transform.getSwingDimension(pos1);
        return Math.abs(pos3 - (pos4 = transform.getSwingDimension(pos2))) < DRAG_THRESHOLD;
    }

    public void checkRequestLayoutStatus() {
        if (this.mNeedsLayout != 0) {
            SceneManager manager = this.myDesignSurface.getSceneManager();
            if (StudioFlags.NELE_LIVE_RENDER.get().booleanValue() && manager instanceof LayoutlibSceneManager) {
                ((LayoutlibSceneManager)manager).requestLayoutAndRender(this.mNeedsLayout == 2);
            } else if (manager != null) {
                manager.layout(this.mNeedsLayout == 2);
            }
        }
    }

    public void mouseRelease(@NotNull SceneContext transform, int x, int y) {
        SceneComponent closestComponent;
        DragBaseTarget dragTarget;
        if (transform == null) {
            Scene.$$$reportNull$$$0(15);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            this.myHitListener.find(transform, this.myRoot, x, y);
            Target closest = this.myHitListener.getFilteredTarget(this.myHitTarget);
            this.myHitTarget.mouseRelease(x, y, closest != null ? Collections.singletonList(closest) : Collections.emptyList());
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(), this.myHitTarget.getComponent());
            }
        }
        this.myFilterTarget = FilterType.NONE;
        this.myNewSelectedComponents.clear();
        if (this.myHitComponent != null && this.myHitListener.getClosestComponent() == this.myHitComponent) {
            this.myNewSelectedComponents.add(this.myHitComponent);
        }
        if (this.myHitTarget instanceof ActionTarget || this.myHitTarget instanceof GuidelineTarget || this.myHitTarget instanceof BarrierTarget) {
            this.myNewSelectedComponents.clear();
            this.myNewSelectedComponents.add(this.myHitTarget.getComponent());
        }
        if (this.myHitTarget instanceof DragBaseTarget && (dragTarget = (DragBaseTarget)this.myHitTarget).hasChangedComponent()) {
            this.myNewSelectedComponents.clear();
            this.myNewSelectedComponents.add(dragTarget.getComponent());
        }
        if (this.myHitTarget instanceof LassoTarget) {
            LassoTarget lassoTarget = (LassoTarget)this.myHitTarget;
            lassoTarget.fillSelectedComponents(this.myNewSelectedComponents);
        }
        if (this.myHitTarget instanceof ActionHandleTarget && (closestComponent = this.myHitListener.getClosestComponent()) != null) {
            ActionHandleTarget actionHandleTarget = (ActionHandleTarget)this.myHitTarget;
            actionHandleTarget.createAction(closestComponent);
        }
        boolean canChangeSelection = true;
        if (this.myHitTarget != null) {
            canChangeSelection = this.myHitTarget.canChangeSelection();
        }
        if (canChangeSelection && !this.sameSelection()) {
            this.select(this.myNewSelectedComponents);
        }
        this.checkRequestLayoutStatus();
    }

    private boolean sameSelection() {
        ImmutableList<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        if (this.myNewSelectedComponents.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i = 0; i < count; ++i) {
                NlComponent component2 = (NlComponent)currentSelection.get(i);
                SceneComponent sceneComponent = this.getSceneComponent(component2);
                if (this.myNewSelectedComponents.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void needsLayout(int type) {
        if (this.mNeedsLayout < type) {
            this.mNeedsLayout = type;
        }
    }

    public long getDisplayListVersion() {
        return this.myDisplayListVersion;
    }

    public void needsRebuildList() {
        ++this.myDisplayListVersion;
    }

    public List<SceneComponent> findWithin(int x, int y, int width, int height) {
        ArrayList within = Lists.newArrayList();
        Scene.addWithin(within, this.getRoot(), x, y, width, height);
        return within;
    }

    private static boolean addWithin(@NotNull List<SceneComponent> result, @NotNull SceneComponent component2, int x, int y, int width, int height) {
        if (result == null) {
            Scene.$$$reportNull$$$0(16);
        }
        if (component2 == null) {
            Scene.$$$reportNull$$$0(17);
        }
        if (component2.getDrawX() + component2.getDrawWidth() <= x || x + width <= component2.getDrawX() || component2.getDrawY() + component2.getDrawHeight() <= y || y + height <= component2.getDrawY()) {
            return false;
        }
        boolean found = false;
        for (SceneComponent child : component2.getChildren()) {
            found |= Scene.addWithin(result, child, x, y, width, height);
        }
        if (!found) {
            result.add(component2);
        }
        return true;
    }

    @Nullable
    public SceneComponent findComponent(@NotNull SceneContext transform, int x, int y) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(18);
        }
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform, this.myRoot, x, y);
        return this.myFindListener.getClosestComponent();
    }

    public Collection<SceneComponent> getSceneComponents() {
        return this.mySceneComponents.values();
    }

    public void setRoot(SceneComponent root) {
        this.myRoot = root;
    }

    @Nullable
    public Dimension measureWrapSize(@NotNull SceneComponent component2) {
        if (component2 == null) {
            Scene.$$$reportNull$$$0(19);
        }
        return this.measure(component2, (n, namespace, localName) -> {
            if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            return null;
        });
    }

    @Nullable
    private Dimension measure(@NotNull SceneComponent component2, @Nullable RenderTask.AttributeFilter filter) {
        NlComponent neleComponent;
        XmlTag tag;
        if (component2 == null) {
            Scene.$$$reportNull$$$0(20);
        }
        if (!(tag = (neleComponent = component2.getNlComponent()).getTag()).isValid()) {
            return null;
        }
        NlModel model = neleComponent.getModel();
        XmlFile xmlFile = model.getFile();
        AndroidFacet facet = model.getFacet();
        RenderService renderService = RenderService.getInstance(facet);
        RenderLogger logger = renderService.createLogger();
        RenderTask task = renderService.createTask((PsiFile)xmlFile, model.getConfiguration(), logger, null);
        if (task == null) {
            return null;
        }
        ViewInfo viewInfo = task.measureChild(tag, filter);
        if (viewInfo == null) {
            return null;
        }
        viewInfo = RenderService.getSafeBounds(viewInfo);
        return new Dimension(Coordinates.pxToDp(this.myDesignSurface.getModel(), viewInfo.getRight() - viewInfo.getLeft()), Coordinates.pxToDp(this.myDesignSurface.getModel(), viewInfo.getBottom() - viewInfo.getTop()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 4: 
            case 5: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayList";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSceneComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mouseHover";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mouseDown";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mouseDrag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addWithin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "measureWrapSize";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class HitListener
    implements ScenePicker.HitElementListener {
        private ScenePicker myPicker = new ScenePicker();
        double myClosestComponentDistance = Double.MAX_VALUE;
        double myClosestTargetDistance = Double.MAX_VALUE;
        ArrayList<SceneComponent> myHitComponents = new ArrayList();
        ArrayList<Target> myHitTargets = new ArrayList();
        Target mySkipTarget = null;

        public HitListener() {
            this.myPicker.setSelectListener(this);
        }

        public void skipTarget(Target target) {
            this.mySkipTarget = target;
        }

        public void find(@NotNull SceneContext transform, @NotNull SceneComponent root, int x, int y) {
            if (transform == null) {
                HitListener.$$$reportNull$$$0(0);
            }
            if (root == null) {
                HitListener.$$$reportNull$$$0(1);
            }
            this.myHitComponents.clear();
            this.myHitTargets.clear();
            this.myClosestComponentDistance = Double.MAX_VALUE;
            this.myClosestTargetDistance = Double.MAX_VALUE;
            this.myPicker.reset();
            root.addHit(transform, this.myPicker);
            this.myPicker.find(transform.getSwingX(x), transform.getSwingY(y));
        }

        @Override
        public void over(Object over, double dist) {
            if (over instanceof Target) {
                if (this.mySkipTarget == over) {
                    return;
                }
                Target target = (Target)over;
                if (dist < this.myClosestTargetDistance) {
                    this.myHitTargets.clear();
                    this.myHitTargets.add(target);
                    this.myClosestTargetDistance = dist;
                } else if (dist == this.myClosestTargetDistance) {
                    this.myHitTargets.add(target);
                }
            } else if (over instanceof SceneComponent) {
                SceneComponent component2 = (SceneComponent)over;
                if (dist < this.myClosestComponentDistance) {
                    this.myHitComponents.clear();
                    this.myHitComponents.add(component2);
                    this.myClosestComponentDistance = dist;
                } else if (dist == this.myClosestComponentDistance) {
                    this.myHitComponents.add(component2);
                }
            }
        }

        public Target getClosestTarget() {
            int count = this.myHitTargets.size();
            if (count == 0) {
                return null;
            }
            if (count == 1) {
                return this.myHitTargets.get(0);
            }
            ImmutableList<NlComponent> selection = Scene.this.myDesignSurface.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                Target candidate = this.myHitTargets.get(count - 1);
                for (int i = count - 2; i >= 0; --i) {
                    Target target = this.myHitTargets.get(i);
                    if (target.getPreferenceLevel() <= candidate.getPreferenceLevel()) continue;
                    candidate = target;
                }
                return candidate;
            }
            Target candidate = this.myHitTargets.get(count - 1);
            boolean inSelection = selection.contains(candidate.getComponent().getNlComponent());
            for (int i = count - 2; i >= 0; --i) {
                Target target = this.myHitTargets.get(i);
                if (!selection.contains(target.getComponent().getNlComponent()) || inSelection && target.getPreferenceLevel() <= candidate.getPreferenceLevel()) continue;
                candidate = target;
                inSelection = true;
            }
            return candidate;
        }

        public Target getFilteredTarget(Target filteredTarget) {
            Target hit = null;
            boolean found = false;
            for (Target target : this.myHitTargets) {
                if (target == filteredTarget) {
                    found = true;
                    continue;
                }
                if (!filteredTarget.getClass().isAssignableFrom(target.getClass())) continue;
                hit = target;
            }
            if (hit == null && found) {
                hit = filteredTarget;
            }
            return hit;
        }

        public SceneComponent getClosestComponent() {
            SceneComponent target;
            int i;
            int count = this.myHitComponents.size();
            if (count == 0) {
                return null;
            }
            if (count == 1) {
                return this.myHitComponents.get(0);
            }
            ImmutableList<NlComponent> selection = Scene.this.myDesignSurface.getSelectionModel().getSelection();
            if (selection.isEmpty()) {
                return this.myHitComponents.get(count - 1);
            }
            SceneComponent candidate = this.myHitComponents.get(count - 1);
            boolean inSelection = selection.contains(candidate.getNlComponent());
            if (inSelection) {
                return candidate;
            }
            for (i = count - 2; i >= 0; --i) {
                target = this.myHitComponents.get(i);
                if (!selection.contains(target.getNlComponent())) continue;
                candidate = target;
                break;
            }
            for (i = count - 1; i >= 0; --i) {
                target = this.myHitComponents.get(i);
                if (!target.hasAncestor(candidate)) continue;
                candidate = target;
                break;
            }
            return candidate;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "transform";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/common/scene/Scene$HitListener";
            objectArray[2] = "find";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

