/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.android.tools.sherpa.drawing.ColorSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DrawComponentFrame
extends DrawRegion {
    public static final int SUBDUED = 0;
    public static final int NORMAL = 1;
    public static final int OVER = 2;
    public static final int SELECTED = 3;
    private static final Stroke myNormalStroke = new BasicStroke(1.0f);
    private static final Stroke myDragReceiverStroke = new BasicStroke(3.0f);
    private final int myMode;
    private final boolean myRounded;

    public DrawComponentFrame(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.myMode = Integer.parseInt(sp[c]);
        this.myRounded = Boolean.parseBoolean(sp[c]);
    }

    @Override
    public int getLevel() {
        return 20;
    }

    public DrawComponentFrame(int x, int y, int width, int height, int mode, boolean rounded) {
        super(x, y, width, height);
        this.myMode = mode;
        this.myRounded = rounded;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        Color[] colorFrame = new Color[]{colorSet.getSubduedFrames(), colorSet.getFrames(), colorSet.getHighlightedFrames(), colorSet.getSelectedFrames(), colorSet.getDragReceiverFrames()};
        Stroke previousStroke = g.getStroke();
        Color previousColor = g.getColor();
        g.setStroke(myNormalStroke);
        g.setColor(colorFrame[this.myMode]);
        if (this.myRounded) {
            g.drawRoundRect(this.x, this.y, this.width, this.height, 20, 20);
        } else {
            g.drawRect(this.x, this.y, this.width, this.height);
        }
        g.setStroke(previousStroke);
        g.setColor(previousColor);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.myMode + "," + this.myRounded;
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode) {
        DrawComponentFrame.add(list, sceneContext, rect, mode, false);
    }

    public static void add(DisplayList list, SceneContext sceneContext, Rectangle rect, int mode, boolean rounded) {
        int l = sceneContext.getSwingX(rect.x);
        int t = sceneContext.getSwingY(rect.y);
        int w = sceneContext.getSwingDimension(rect.width);
        int h = sceneContext.getSwingDimension(rect.height);
        list.add(new DrawComponentFrame(l, t, w, h, mode, rounded));
    }
}

