/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceResolverCache {
    private static final Logger LOG = Logger.getInstance(ResourceResolverCache.class);
    private final ConfigurationManager myManager;
    @VisibleForTesting
    final Map<String, ResourceResolver> myResolverMap;
    @VisibleForTesting
    final Map<String, Map<ResourceType, ResourceValueMap>> myAppResourceMap;
    @VisibleForTesting
    final Map<String, Map<ResourceType, ResourceValueMap>> myFrameworkResourceMap;
    private long myCachedGeneration;
    private SparseArray<AndroidTargetData> myFrameworkResources = new SparseArray();
    private String myCustomConfigurationKey;
    private String myCustomResolverKey;

    public ResourceResolverCache(ConfigurationManager manager) {
        this.myManager = manager;
        this.myResolverMap = Maps.newHashMap();
        this.myAppResourceMap = Maps.newHashMap();
        this.myFrameworkResourceMap = Maps.newHashMap();
    }

    @NotNull
    public ResourceResolver getResourceResolver(@Nullable IAndroidTarget target, @NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration) {
        AppResourceRepository resources;
        if (themeStyle == null) {
            ResourceResolverCache.$$$reportNull$$$0(0);
        }
        if (fullConfiguration == null) {
            ResourceResolverCache.$$$reportNull$$$0(1);
        }
        if ((resources = AppResourceRepository.getOrCreateInstance(this.myManager.getModule())) == null) {
            ResourceResolver resourceResolver = ResourceResolver.create(Collections.emptyMap(), Collections.emptyMap(), null, (boolean)false);
            if (resourceResolver == null) {
                ResourceResolverCache.$$$reportNull$$$0(2);
            }
            return resourceResolver;
        }
        if (this.myCachedGeneration != ((LocalResourceRepository)resources).getModificationCount()) {
            this.myResolverMap.clear();
            this.myAppResourceMap.clear();
        }
        this.myCachedGeneration = ((LocalResourceRepository)resources).getModificationCount();
        String configurationKey = fullConfiguration.getUniqueKey();
        String resolverKey = themeStyle + configurationKey;
        ResourceResolver resolver = this.myResolverMap.get(resolverKey);
        if (resolver == null) {
            Map<ResourceType, ResourceValueMap> frameworkResources;
            if (target == null) {
                target = this.myManager.getTarget();
            }
            if (target == null) {
                frameworkResources = Collections.emptyMap();
            } else {
                ResourceRepository frameworkRes = this.getFrameworkResources(fullConfiguration, target);
                if (frameworkRes == null) {
                    frameworkResources = Collections.emptyMap();
                } else {
                    frameworkResources = this.myFrameworkResourceMap.get(configurationKey);
                    if (frameworkResources == null) {
                        IAndroidTarget realTarget;
                        frameworkResources = frameworkRes.getConfiguredResources(fullConfiguration);
                        if (target instanceof CompatibilityRenderTarget && target.getVersion().getApiLevel() == 8 && (realTarget = ((CompatibilityRenderTarget)target).getRealTarget()) != null) {
                            ResourceResolverCache.replaceDrawableBitmaps(frameworkResources, target, realTarget);
                        }
                        this.myFrameworkResourceMap.put(configurationKey, frameworkResources);
                    }
                }
            }
            Map configuredAppRes = this.myAppResourceMap.get(configurationKey);
            if (configuredAppRes == null) {
                configuredAppRes = (Map)ReadAction.compute(() -> {
                    if (fullConfiguration == null) {
                        ResourceResolverCache.$$$reportNull$$$0(11);
                    }
                    return resources.getConfiguredResources(fullConfiguration);
                });
                this.myAppResourceMap.put(configurationKey, configuredAppRes);
            }
            assert (themeStyle.startsWith("@")) : themeStyle;
            boolean isProjectTheme = ResourceHelper.isProjectStyle(themeStyle);
            String themeName = ResourceHelper.styleToTheme(themeStyle);
            resolver = ResourceResolver.create((Map)configuredAppRes, (Map)frameworkResources, (String)themeName, (boolean)isProjectTheme);
            if (target instanceof CompatibilityRenderTarget) {
                int apiLevel = target.getVersion().getFeatureLevel();
                if (apiLevel >= 21) {
                    resolver.setDeviceDefaults("Material");
                } else if (apiLevel >= 14) {
                    resolver.setDeviceDefaults("Holo");
                } else {
                    resolver.setDeviceDefaults("");
                }
            }
            this.myResolverMap.put(resolverKey, resolver);
        }
        ResourceResolver resourceResolver = resolver;
        if (resourceResolver == null) {
            ResourceResolverCache.$$$reportNull$$$0(3);
        }
        return resourceResolver;
    }

    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull FolderConfiguration configuration, @NotNull IAndroidTarget target) {
        if (configuration == null) {
            ResourceResolverCache.$$$reportNull$$$0(4);
        }
        if (target == null) {
            ResourceResolverCache.$$$reportNull$$$0(5);
        }
        int apiLevel = target.getVersion().getFeatureLevel();
        LocaleQualifier locale = configuration.getLocaleQualifier();
        boolean needLocales = locale != null && !locale.hasFakeValue() || this.myManager.getLocale() != Locale.ANY;
        AndroidTargetData targetData = (AndroidTargetData)this.myFrameworkResources.get(apiLevel);
        if (targetData == null) {
            AndroidPlatform platform = AndroidPlatform.getInstance(this.myManager.getModule());
            if (platform == null) {
                return null;
            }
            targetData = platform.getSdkData().getTargetData(target);
            this.myFrameworkResources.put(apiLevel, (Object)targetData);
        }
        try {
            return targetData.getFrameworkResources(needLocales);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static void replaceDrawableBitmaps(@NotNull Map<ResourceType, ResourceValueMap> frameworkResources, @NotNull IAndroidTarget from, @NotNull IAndroidTarget realTarget) {
        if (frameworkResources == null) {
            ResourceResolverCache.$$$reportNull$$$0(6);
        }
        if (from == null) {
            ResourceResolverCache.$$$reportNull$$$0(7);
        }
        if (realTarget == null) {
            ResourceResolverCache.$$$reportNull$$$0(8);
        }
        ResourceValueMap map = frameworkResources.get(ResourceType.DRAWABLE);
        String oldPrefix = from.getPath(11);
        String newPrefix = realTarget.getPath(11);
        if (map == null || map.isEmpty() || oldPrefix == null || newPrefix == null || oldPrefix.equals(newPrefix)) {
            return;
        }
        Collection values = map.values();
        HashMap densityDirMap = Maps.newHashMap();
        boolean ONLY_REPLACE_BITMAPS = true;
        Density[] densities = Density.values();
        for (ResourceValue value : values) {
            File newFile;
            String v = value.getValue();
            if (v == null || !v.endsWith(".png") || !v.startsWith(oldPrefix)) continue;
            String relative = v.substring(oldPrefix.length());
            if (v.endsWith(".png")) {
                DensityQualifier densityQualifier;
                FolderConfiguration configuration;
                int index = relative.indexOf(File.separatorChar);
                if (index == -1) {
                    index = relative.indexOf(47);
                }
                if (index == -1) continue;
                String parent = relative.substring(0, index);
                String replace = (String)densityDirMap.get(parent);
                if (replace == null && (configuration = FolderConfiguration.getConfigForFolder((String)parent)) != null && (densityQualifier = configuration.getDensityQualifier()) != null) {
                    Density density = densityQualifier.getValue();
                    if (!new File(newPrefix, parent).exists()) {
                        String oldQualifier = "-" + density.getResourceValue();
                        String matched = null;
                        for (Density d : densities) {
                            String newQualifier;
                            String newName;
                            File dir;
                            if (d.ordinal() <= density.ordinal() || !(dir = new File(newPrefix, newName = parent.replace(oldQualifier, newQualifier = "-" + d.getResourceValue()))).exists()) continue;
                            matched = newName;
                            break;
                        }
                        if (matched == null) continue;
                        replace = matched;
                        densityDirMap.put(parent, replace);
                    }
                }
                relative = replace + relative.substring(index);
            }
            if (!(newFile = new File(newPrefix, relative)).exists()) continue;
            value.setValue(newFile.getPath());
        }
    }

    public void reset() {
        this.myCachedGeneration = 0L;
        this.myAppResourceMap.clear();
        this.myResolverMap.clear();
    }

    public void replaceCustomConfig(@NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration) {
        if (themeStyle == null) {
            ResourceResolverCache.$$$reportNull$$$0(9);
        }
        if (fullConfiguration == null) {
            ResourceResolverCache.$$$reportNull$$$0(10);
        }
        String newCustomConfigurationKey = fullConfiguration.getUniqueKey();
        String newCustomResolverKey = themeStyle + newCustomConfigurationKey;
        if (newCustomResolverKey.equals(this.myCustomResolverKey)) {
            return;
        }
        if (this.myCustomConfigurationKey != null) {
            this.myFrameworkResourceMap.remove(this.myCustomConfigurationKey);
            this.myAppResourceMap.remove(this.myCustomConfigurationKey);
        }
        if (this.myCustomResolverKey != null) {
            this.myResolverMap.remove(this.myCustomResolverKey);
        }
        this.myCustomConfigurationKey = newCustomConfigurationKey;
        this.myCustomResolverKey = newCustomResolverKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeStyle";
                break;
            }
            case 1: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ResourceResolverCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkResources";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ResourceResolverCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceResolver";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkResources";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceDrawableBitmaps";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceCustomConfig";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getResourceResolver$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

