/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.RtlAction$WhenMappings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import icons.AndroidIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/configurations/RtlAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "holder", "Lcom/android/tools/idea/configurations/ConfigurationHolder;", "(Lcom/android/tools/idea/configurations/ConfigurationHolder;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "displayTextInToolbar", "", "getOppositeDirection", "Lcom/android/resources/LayoutDirection;", "direction", "Lcom/android/ide/common/resources/configuration/LayoutDirectionQualifier;", "update", "updatePresentation", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "android"})
public final class RtlAction
extends AnAction {
    private final ConfigurationHolder holder;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        this.updatePresentation(presentation);
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private final void updatePresentation(Presentation presentation) {
        Configuration configuration = this.holder.getConfiguration();
        presentation.setEnabledAndVisible(configuration != null);
        if (!presentation.isEnabledAndVisible()) {
            return;
        }
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            Intrinsics.throwNpe();
        }
        LayoutDirectionQualifier qualifier = configuration2.getFullConfig().getLayoutDirectionQualifier();
        String brief = "Preview as " + this.getOppositeDirection(qualifier).getLongDisplayValue();
        presentation.setText(brief, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final LayoutDirection getOppositeDirection(LayoutDirectionQualifier direction) {
        LayoutDirection layoutDirection;
        LayoutDirectionQualifier layoutDirectionQualifier = direction;
        Object object = layoutDirectionQualifier != null ? layoutDirectionQualifier.getValue() : null;
        if (object != null) {
            switch (RtlAction$WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
                case 1: {
                    layoutDirection = LayoutDirection.RTL;
                    return layoutDirection;
                }
            }
        }
        layoutDirection = LayoutDirection.LTR;
        return layoutDirection;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Configuration configuration = this.holder.getConfiguration();
        if (configuration == null) {
            return;
        }
        Configuration configuration2 = configuration;
        configuration2.getEditedConfig().setLayoutDirectionQualifier(new LayoutDirectionQualifier(this.getOppositeDirection(configuration2.getFullConfig().getLayoutDirectionQualifier())));
        configuration2.updated(16);
    }

    public RtlAction(@NotNull ConfigurationHolder holder) {
        Presentation presentation;
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        this.holder = holder;
        Presentation $receiver = presentation = this.getTemplatePresentation();
        $receiver.setDescription("Text direction setting in the editor");
        $receiver.setIcon(AndroidIcons.Configs.LayoutDirection);
        Presentation presentation2 = presentation;
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"presentation");
        this.updatePresentation(presentation2);
    }
}

