/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.actions.EditMultipleSourcesAction;
import com.android.tools.idea.actions.PsiClassNavigation;
import com.android.tools.idea.editors.hprof.descriptors.ContainerDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.ExpansionDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.HprofFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.InstanceFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.descriptors.PrimitiveFieldDescriptorImpl;
import com.android.tools.idea.editors.hprof.views.GoToInstanceAction;
import com.android.tools.idea.editors.hprof.views.GoToInstanceListener;
import com.android.tools.idea.editors.hprof.views.InstanceReferenceTreeView;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.idea.editors.hprof.views.ViewBitmapAction;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Field;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.Type;
import com.android.tools.perflib.heap.memoryanalyzer.HprofBitmapProvider;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstancesTreeView
implements DataProvider,
Disposable {
    public static final String TREE_NAME = "HprofInstancesTree";
    public static final DataKey<ClassInstance> SELECTED_CLASS_INSTANCE = DataKey.create((String)"HprofInstanceTreeView.SelectedClassInstance");
    private static final int NODES_PER_EXPANSION = 100;
    @NotNull
    private Project myProject;
    @NotNull
    private DebuggerTree myDebuggerTree;
    @NotNull
    private JComponent myColumnTree;
    @NotNull
    private SelectionModel mySelectionModel;
    @NotNull
    private DebugProcessImpl myDebugProcess;
    @NotNull
    private volatile SuspendContextImpl myDummySuspendContext;
    @NotNull
    private Heap myHeap;
    @Nullable
    private ClassObj myClassObj;
    @Nullable
    private Comparator<DebuggerTreeNodeImpl> myComparator;
    @NotNull
    private SortOrder mySortOrder;
    @NotNull
    private GoToInstanceAction myGoToInstanceAction;

    public InstancesTreeView(@NotNull Project project, @NotNull SelectionModel selectionModel) {
        if (project == null) {
            InstancesTreeView.$$$reportNull$$$0(0);
        }
        if (selectionModel == null) {
            InstancesTreeView.$$$reportNull$$$0(1);
        }
        this.mySortOrder = SortOrder.UNSORTED;
        this.myProject = project;
        this.mySelectionModel = selectionModel;
        this.myDebuggerTree = new DebuggerTree(project){

            protected void build(DebuggerContextImpl context) {
                DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)this.getModel().getRoot();
                Instance instance = ((InstanceFieldDescriptorImpl)root.getDescriptor()).getInstance();
                InstancesTreeView.this.addChildren(root, null, instance);
            }

            public Object getData(@NonNls String dataId) {
                return InstancesTreeView.this.getData(dataId);
            }
        };
        this.myDebuggerTree.getComponent().setName(TREE_NAME);
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myDebuggerTree);
        this.myHeap = this.mySelectionModel.getHeap();
        this.myDebugProcess = new DebugProcessEvents(project);
        final SuspendManagerImpl suspendManager = new SuspendManagerImpl(this.myDebugProcess);
        this.myDebugProcess.getManagerThread().invokeAndWait(new DebuggerCommandImpl(){

            protected void action() throws Exception {
                InstancesTreeView.this.myDummySuspendContext = suspendManager.pushSuspendContext(0, 1);
            }
        });
        TreeBuilder model = new TreeBuilder(this.myDebuggerTree){

            public void buildChildren(TreeBuilderNode node) {
                DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
                NodeDescriptorImpl descriptor = debuggerTreeNode.getDescriptor();
                if (descriptor instanceof DefaultNodeDescriptor) {
                    return;
                }
                if (descriptor instanceof ContainerDescriptorImpl) {
                    InstancesTreeView.this.addContainerChildren(debuggerTreeNode, 0, true);
                } else {
                    InstanceFieldDescriptorImpl instanceDescriptor = (InstanceFieldDescriptorImpl)descriptor;
                    InstancesTreeView.this.addChildren(debuggerTreeNode, instanceDescriptor.getHprofField(), instanceDescriptor.getInstance());
                }
                InstancesTreeView.this.sortTree(debuggerTreeNode);
                InstancesTreeView.this.myDebuggerTree.treeDidChange();
            }

            public boolean isExpandable(TreeBuilderNode builderNode) {
                return ((DebuggerTreeNodeImpl)builderNode).getDescriptor().isExpandable();
            }
        };
        model.setRoot((TreeBuilderNode)this.myDebuggerTree.getNodeFactory().getDefaultNode());
        model.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent event) {
                InstancesTreeView.this.myDebuggerTree.hideTooltip();
            }
        });
        this.myDebuggerTree.setModel((TreeModel)model);
        this.myDebuggerTree.setRootVisible(false);
        this.myDebuggerTree.putClientProperty((Object)"DataProvider", (Object)this);
        JBList contextActionList = new JBList(new Object[]{new EditMultipleSourcesAction()});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)contextActionList);
        this.myGoToInstanceAction = new GoToInstanceAction((JComponent)this.myDebuggerTree);
        this.myDebuggerTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup popupGroup = new DefaultActionGroup(new AnAction[]{new EditMultipleSourcesAction()});
                Instance selectedInstance = InstancesTreeView.this.mySelectionModel.getInstance();
                if (selectedInstance instanceof ClassInstance && HprofBitmapProvider.canGetBitmapFromInstance((Instance)selectedInstance)) {
                    popupGroup.add((AnAction)new ViewBitmapAction());
                }
                popupGroup.add((AnAction)InstancesTreeView.this.myGoToInstanceAction);
                ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)popupGroup).getComponent().show(comp, x, y);
            }
        });
        this.mySelectionModel.addListener(new SelectionModel.SelectionListener(){

            @Override
            public void onHeapChanged(@NotNull Heap heap) {
                if (heap == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (heap != InstancesTreeView.this.myHeap) {
                    InstancesTreeView.this.myHeap = heap;
                    if (InstancesTreeView.this.myDebuggerTree.getMutableModel().getRoot() != null) {
                        this.onSelectionChanged();
                    }
                }
            }

            @Override
            public void onClassObjChanged(@Nullable ClassObj classObj) {
                if (classObj != InstancesTreeView.this.myClassObj) {
                    InstancesTreeView.this.myClassObj = classObj;
                    this.onSelectionChanged();
                }
            }

            @Override
            public void onInstanceChanged(@Nullable Instance instance) {
                DebuggerTreeNodeImpl treeNode;
                if (instance == null) {
                    return;
                }
                TreePath path = InstancesTreeView.this.myDebuggerTree.getSelectionPath();
                if (path != null && (treeNode = (DebuggerTreeNodeImpl)path.getPathComponent(1)).getDescriptor() instanceof InstanceFieldDescriptorImpl && ((InstanceFieldDescriptorImpl)treeNode.getDescriptor()).getInstance() == instance) {
                    return;
                }
                DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)InstancesTreeView.this.myDebuggerTree.getMutableModel().getRoot();
                DebuggerTreeNodeImpl targetNode = InstancesTreeView.this.expandMoreNodesUntilFound(root, instance);
                if (targetNode != null) {
                    TreePath targetPath = new TreePath(targetNode.getPath());
                    InstancesTreeView.this.myDebuggerTree.treeChanged();
                    InstancesTreeView.this.myDebuggerTree.setSelectionPath(targetPath);
                    ApplicationManager.getApplication().invokeLater(() -> InstancesTreeView.this.myDebuggerTree.scrollPathToVisible(targetPath));
                }
            }

            private void onSelectionChanged() {
                DebuggerTreeNodeImpl newRoot;
                Instance singleChild = null;
                if (InstancesTreeView.this.myClassObj != null) {
                    ContainerDescriptorImpl containerDescriptor = new ContainerDescriptorImpl(InstancesTreeView.this.myClassObj, InstancesTreeView.this.myHeap.getId());
                    newRoot = DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)InstancesTreeView.this.myDebuggerTree, (NodeDescriptor)containerDescriptor);
                    if (containerDescriptor.getInstances().size() == 1) {
                        singleChild = containerDescriptor.getInstances().get(0);
                    }
                } else {
                    newRoot = InstancesTreeView.this.myDebuggerTree.getNodeFactory().getDefaultNode();
                }
                InstancesTreeView.this.myDebuggerTree.getMutableModel().setRoot((TreeBuilderNode)newRoot);
                InstancesTreeView.this.myDebuggerTree.treeChanged();
                if (InstancesTreeView.this.myDebuggerTree.getRowCount() > 0) {
                    InstancesTreeView.this.myDebuggerTree.scrollRowToVisible(0);
                }
                if (singleChild != null) {
                    InstancesTreeView.this.myDebuggerTree.setSelectionInterval(0, 0);
                    InstancesTreeView.this.mySelectionModel.setInstance(singleChild);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heap", "com/android/tools/idea/editors/hprof/views/InstancesTreeView$6", "onHeapChanged"));
            }
        });
        this.myDebuggerTree.addTreeSelectionListener(e -> {
            DebuggerTreeNodeImpl lastPathNode;
            InstanceFieldDescriptorImpl descriptor;
            TreePath path = e.getPath();
            if (path == null || path.getPathCount() < 2 || !e.isAddedPath()) {
                this.mySelectionModel.setInstance(null);
                return;
            }
            DebuggerTreeNodeImpl instanceNode = (DebuggerTreeNodeImpl)path.getPathComponent(1);
            if (instanceNode.getDescriptor() instanceof InstanceFieldDescriptorImpl && (descriptor = (InstanceFieldDescriptorImpl)instanceNode.getDescriptor()).getInstance() != this.mySelectionModel.getInstance()) {
                this.mySelectionModel.setInstance(descriptor.getInstance());
            }
            if ((lastPathNode = (DebuggerTreeNodeImpl)path.getLastPathComponent()).getDescriptor() instanceof ExpansionDescriptorImpl) {
                ExpansionDescriptorImpl expansionDescriptor = (ExpansionDescriptorImpl)lastPathNode.getDescriptor();
                DebuggerTreeNodeImpl parentNode = lastPathNode.getParent();
                this.myDebuggerTree.getMutableModel().removeNodeFromParent((TreeBuilderNode)lastPathNode);
                if (parentNode.getDescriptor() instanceof ContainerDescriptorImpl) {
                    this.addContainerChildren(parentNode, expansionDescriptor.getStartIndex(), true);
                } else if (parentNode.getDescriptor() instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl instanceFieldDescriptor = (InstanceFieldDescriptorImpl)parentNode.getDescriptor();
                    this.addChildren(parentNode, instanceFieldDescriptor.getHprofField(), instanceFieldDescriptor.getInstance(), expansionDescriptor.getStartIndex());
                }
                this.sortTree(parentNode);
                this.myDebuggerTree.getMutableModel().nodeStructureChanged((TreeNode)parentNode);
                if (this.myComparator != null) {
                    this.myDebuggerTree.scrollPathToVisible(new TreePath(((DebuggerTreeNodeImpl)parentNode.getLastChild()).getPath()));
                }
            }
        });
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myDebuggerTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Instance").setPreferredWidth(600).setHeaderAlignment(2).setComparator((Comparator)new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
                if (a == null) {
                    13.$$$reportNull$$$0(0);
                }
                if (b == null) {
                    13.$$$reportNull$$$0(1);
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "a";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "b";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/editors/hprof/views/InstancesTreeView$13";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setRenderer((ColoredTreeCellRenderer)((DebuggerTreeRenderer)this.myDebuggerTree.getCellRenderer()))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Depth").setPreferredWidth(60).setHeaderAlignment(4).setComparator((Comparator)new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(DebuggerTreeNodeImpl a, DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                int depthA = 0;
                int depthB = 0;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null) {
                    depthA = instanceA.getDistanceToGcRoot();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null) {
                    depthB = instanceB.getDistanceToGcRoot();
                }
                if (depthA != depthB) {
                    return depthA - depthB;
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NodeDescriptorImpl nodeDescriptor;
                if (tree == null) {
                    11.$$$reportNull$$$0(0);
                }
                if ((nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject()) instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getDistanceToGcRoot()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/InstancesTreeView$11", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Shallow Size").setPreferredWidth(80).setHeaderAlignment(4).setComparator((Comparator)new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                if (a == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (b == null) {
                    10.$$$reportNull$$$0(1);
                }
                int sizeA = 0;
                int sizeB = 0;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null) {
                    sizeA = instanceA.getSize();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null) {
                    sizeB = instanceB.getSize();
                }
                if (sizeA != sizeB) {
                    return sizeA - sizeB;
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "a";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "b";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/editors/hprof/views/InstancesTreeView$10";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NodeDescriptorImpl nodeDescriptor;
                if (tree == null) {
                    9.$$$reportNull$$$0(0);
                }
                if ((nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject()) instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null) {
                        this.append(String.valueOf(instance.getSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/InstancesTreeView$9", "customizeCellRenderer"));
            }
        })).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Dominating Size").setPreferredWidth(80).setHeaderAlignment(4).setComparator((Comparator)new Comparator<DebuggerTreeNodeImpl>(){

            @Override
            public int compare(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
                Instance instanceB;
                Instance instanceA;
                if (a == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (b == null) {
                    8.$$$reportNull$$$0(1);
                }
                long sizeA = 0L;
                long sizeB = 0L;
                if (a.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceA = (Instance)((InstanceFieldDescriptorImpl)a.getDescriptor()).getValueData()) != null && instanceA.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                    sizeA = instanceA.getTotalRetainedSize();
                }
                if (b.getDescriptor() instanceof InstanceFieldDescriptorImpl && (instanceB = (Instance)((InstanceFieldDescriptorImpl)b.getDescriptor()).getValueData()) != null && instanceB.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                    sizeB = instanceB.getTotalRetainedSize();
                }
                if (sizeA != sizeB) {
                    return (int)(sizeA - sizeB);
                }
                return InstancesTreeView.this.getDefaultOrdering(a, b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "a";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "b";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/editors/hprof/views/InstancesTreeView$8";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setRenderer(new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                NodeDescriptorImpl nodeDescriptor;
                if (tree == null) {
                    7.$$$reportNull$$$0(0);
                }
                if ((nodeDescriptor = (NodeDescriptorImpl)((TreeBuilderNode)value).getUserObject()) instanceof InstanceFieldDescriptorImpl) {
                    InstanceFieldDescriptorImpl descriptor = (InstanceFieldDescriptorImpl)nodeDescriptor;
                    assert (!descriptor.isPrimitive());
                    Instance instance = (Instance)descriptor.getValueData();
                    if (instance != null && instance.getDistanceToGcRoot() != Integer.MAX_VALUE) {
                        this.append(String.valueOf(instance.getTotalRetainedSize()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
                this.setTextAlign(4);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/hprof/views/InstancesTreeView$7", "customizeCellRenderer"));
            }
        }));
        builder.setTreeSorter((ColumnTreeBuilder.TreeSorter)new ColumnTreeBuilder.TreeSorter<DebuggerTreeNodeImpl>(){

            public void sort(@NotNull Comparator<DebuggerTreeNodeImpl> comparator, @NotNull SortOrder sortOrder) {
                if (comparator == null) {
                    14.$$$reportNull$$$0(0);
                }
                if (sortOrder == null) {
                    14.$$$reportNull$$$0(1);
                }
                if (InstancesTreeView.this.myComparator != comparator && InstancesTreeView.this.mySortOrder != sortOrder) {
                    InstancesTreeView.this.myComparator = comparator;
                    InstancesTreeView.this.mySortOrder = sortOrder;
                    TreeBuilder mutableModel = InstancesTreeView.this.myDebuggerTree.getMutableModel();
                    DebuggerTreeNodeImpl root = (DebuggerTreeNodeImpl)mutableModel.getRoot();
                    InstancesTreeView.this.sortTree(root);
                    InstancesTreeView.this.mySelectionModel.setSelectionLocked(true);
                    TreePath selectionPath = InstancesTreeView.this.myDebuggerTree.getSelectionPath();
                    mutableModel.nodeStructureChanged((TreeNode)root);
                    InstancesTreeView.this.myDebuggerTree.setSelectionPath(selectionPath);
                    InstancesTreeView.this.myDebuggerTree.scrollPathToVisible(selectionPath);
                    InstancesTreeView.this.mySelectionModel.setSelectionLocked(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "comparator";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sortOrder";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/editors/hprof/views/InstancesTreeView$14";
                objectArray[2] = "sort";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myColumnTree = builder.build();
    }

    public void addGoToInstanceListener(@NotNull GoToInstanceListener listener) {
        if (listener == null) {
            InstancesTreeView.$$$reportNull$$$0(2);
        }
        this.myGoToInstanceAction.addListener(listener);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myColumnTree;
        if (jComponent == null) {
            InstancesTreeView.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myDebuggerTree, true));
    }

    private void sortTree(@NotNull DebuggerTreeNodeImpl node) {
        if (node == null) {
            InstancesTreeView.$$$reportNull$$$0(4);
        }
        if (this.myComparator == null) {
            return;
        }
        Enumeration e = node.rawChildren();
        if (e.hasMoreElements()) {
            ArrayList<DebuggerTreeNodeImpl> builtChildren = Collections.list(e);
            DebuggerTreeNodeImpl expansionNode = builtChildren.get(builtChildren.size() - 1);
            if (expansionNode.getDescriptor() instanceof ExpansionDescriptorImpl) {
                builtChildren.remove(builtChildren.size() - 1);
            } else {
                expansionNode = null;
            }
            Collections.sort(builtChildren, this.myComparator);
            node.removeAllChildren();
            for (DebuggerTreeNodeImpl childNode : builtChildren) {
                node.add((MutableTreeNode)childNode);
                this.sortTree(childNode);
            }
            if (expansionNode != null) {
                node.add((MutableTreeNode)expansionNode);
            }
        }
    }

    private int getDefaultOrdering(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
        Instance parentInstance;
        NodeDescriptorImpl parentDescriptor;
        if (a == null) {
            InstancesTreeView.$$$reportNull$$$0(5);
        }
        if (b == null) {
            InstancesTreeView.$$$reportNull$$$0(6);
        }
        if ((parentDescriptor = a.getParent().getDescriptor()) instanceof InstanceFieldDescriptorImpl ? (parentInstance = ((InstanceFieldDescriptorImpl)parentDescriptor).getInstance()) instanceof ArrayInstance : parentDescriptor instanceof ContainerDescriptorImpl) {
            return this.getMemoryOrderingSortResult(a, b);
        }
        return a.getDescriptor().getLabel().compareTo(b.getDescriptor().getLabel());
    }

    private int getMemoryOrderingSortResult(@NotNull DebuggerTreeNodeImpl a, @NotNull DebuggerTreeNodeImpl b) {
        if (a == null) {
            InstancesTreeView.$$$reportNull$$$0(7);
        }
        if (b == null) {
            InstancesTreeView.$$$reportNull$$$0(8);
        }
        return ((HprofFieldDescriptorImpl)a.getDescriptor()).getMemoryOrdering() - ((HprofFieldDescriptorImpl)b.getDescriptor()).getMemoryOrdering() ^ (this.mySortOrder == SortOrder.ASCENDING ? 1 : -1);
    }

    @Nullable
    private DebuggerTreeNodeImpl expandMoreNodesUntilFound(@NotNull DebuggerTreeNodeImpl node, @NotNull Instance targetInstance) {
        if (node == null) {
            InstancesTreeView.$$$reportNull$$$0(9);
        }
        if (targetInstance == null) {
            InstancesTreeView.$$$reportNull$$$0(10);
        }
        if (node.getDescriptor() instanceof ContainerDescriptorImpl) {
            int startIndex = 0;
            if (node.getChildCount() > 0) {
                DebuggerTreeNodeImpl lastNode = (DebuggerTreeNodeImpl)node.getChildAt(node.getChildCount() - 1);
                if (lastNode.getDescriptor() instanceof ExpansionDescriptorImpl) {
                    lastNode.removeFromParent();
                    startIndex = node.getChildCount() - 1;
                } else {
                    for (int scanIndex = 0; scanIndex < node.getChildCount(); ++scanIndex) {
                        DebuggerTreeNodeImpl scanNode = (DebuggerTreeNodeImpl)node.getChildAt(scanIndex);
                        NodeDescriptorImpl nodeDescriptor = scanNode.getDescriptor();
                        if (!(nodeDescriptor instanceof InstanceFieldDescriptorImpl) || ((InstanceFieldDescriptorImpl)nodeDescriptor).getInstance() != targetInstance) continue;
                        return scanNode;
                    }
                    return null;
                }
            }
            int maxSize = ((ContainerDescriptorImpl)node.getDescriptor()).getInstances().size();
            while (startIndex < maxSize) {
                this.addContainerChildren(node, startIndex, false);
                for (int scanIndex = startIndex; scanIndex < node.getChildCount(); ++scanIndex) {
                    DebuggerTreeNodeImpl scanNode = (DebuggerTreeNodeImpl)node.getChildAt(scanIndex);
                    NodeDescriptorImpl nodeDescriptor = scanNode.getDescriptor();
                    if (!(nodeDescriptor instanceof InstanceFieldDescriptorImpl) || ((InstanceFieldDescriptorImpl)nodeDescriptor).getInstance() != targetInstance) continue;
                    this.addExpansionNode(node, node.getChildCount(), maxSize);
                    return scanNode;
                }
                startIndex = node.getChildCount();
            }
        }
        return null;
    }

    private void addContainerChildren(@NotNull DebuggerTreeNodeImpl node, int startIndex, boolean addExpansionNode) {
        if (node == null) {
            InstancesTreeView.$$$reportNull$$$0(11);
        }
        ContainerDescriptorImpl containerDescriptor = (ContainerDescriptorImpl)node.getDescriptor();
        List<Instance> instances = containerDescriptor.getInstances();
        ArrayList<HprofFieldDescriptorImpl> descriptors = new ArrayList<HprofFieldDescriptorImpl>(100);
        int currentIndex = startIndex;
        int limit = currentIndex + 100;
        for (int loopCounter = currentIndex; loopCounter < instances.size() && currentIndex < limit; ++loopCounter) {
            Instance instance = instances.get(loopCounter);
            if (this.myHeap.getInstance(instance.getId()) == null) continue;
            descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(Type.OBJECT, Integer.toString(currentIndex)), instance, currentIndex));
            ++currentIndex;
        }
        HprofFieldDescriptorImpl.batchUpdateRepresentation(descriptors, this.myDebugProcess.getManagerThread(), this.myDummySuspendContext);
        for (HprofFieldDescriptorImpl descriptor : descriptors) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)descriptor));
        }
        if (currentIndex == limit && addExpansionNode) {
            this.addExpansionNode(node, limit, instances.size());
        }
    }

    private void addExpansionNode(@NotNull DebuggerTreeNodeImpl node, int currentIndex, int maxSize) {
        if (node == null) {
            InstancesTreeView.$$$reportNull$$$0(12);
        }
        node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)new ExpansionDescriptorImpl("instances", currentIndex, maxSize)));
    }

    private void addChildren(@NotNull DebuggerTreeNodeImpl node, @Nullable Field field, @Nullable Instance instance) {
        if (node == null) {
            InstancesTreeView.$$$reportNull$$$0(13);
        }
        this.addChildren(node, field, instance, 0);
    }

    private void addChildren(@NotNull DebuggerTreeNodeImpl node, @Nullable Field field, @Nullable Instance instance, int arrayStartIndex) {
        ArrayList<HprofFieldDescriptorImpl> descriptors;
        int currentArrayIndex;
        if (node == null) {
            InstancesTreeView.$$$reportNull$$$0(14);
        }
        if (instance == null) {
            return;
        }
        int limit = currentArrayIndex + 100;
        int arrayLength = 0;
        if (instance instanceof ClassInstance) {
            ClassInstance classInstance = (ClassInstance)instance;
            descriptors = new ArrayList<HprofFieldDescriptorImpl>(classInstance.getValues().size());
            int i = 0;
            for (ClassInstance.FieldValue entry : classInstance.getValues()) {
                if (entry.getField().getType() == Type.OBJECT) {
                    descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), entry.getField(), (Instance)entry.getValue(), i));
                } else {
                    descriptors.add(new PrimitiveFieldDescriptorImpl(this.myDebuggerTree.getProject(), entry.getField(), entry.getValue(), i));
                }
                ++i;
            }
        } else if (instance instanceof ArrayInstance) {
            assert (field != null);
            ArrayInstance arrayInstance = (ArrayInstance)instance;
            Object[] values = arrayInstance.getValues();
            descriptors = new ArrayList(values.length);
            arrayLength = values.length;
            if (arrayInstance.getArrayType() == Type.OBJECT) {
                for (currentArrayIndex = arrayStartIndex; currentArrayIndex < arrayLength && currentArrayIndex < limit; ++currentArrayIndex) {
                    descriptors.add(new InstanceFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(arrayInstance.getArrayType(), String.valueOf(currentArrayIndex)), (Instance)values[currentArrayIndex], currentArrayIndex));
                }
            } else {
                while (currentArrayIndex < arrayLength && currentArrayIndex < limit) {
                    descriptors.add(new PrimitiveFieldDescriptorImpl(this.myDebuggerTree.getProject(), new Field(arrayInstance.getArrayType(), String.valueOf(currentArrayIndex)), values[currentArrayIndex], currentArrayIndex));
                    ++currentArrayIndex;
                }
            }
        } else {
            throw new RuntimeException("Unimplemented Instance type in addChildren.");
        }
        HprofFieldDescriptorImpl.batchUpdateRepresentation(descriptors, this.myDebugProcess.getManagerThread(), this.myDummySuspendContext);
        for (HprofFieldDescriptorImpl descriptor : descriptors) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)descriptor));
        }
        if (currentArrayIndex == limit) {
            node.add((MutableTreeNode)DebuggerTreeNodeImpl.createNodeNoUpdate((DebuggerTree)this.myDebuggerTree, (NodeDescriptor)new ExpansionDescriptorImpl("array elements", limit, arrayLength)));
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.getTargetFiles();
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (SELECTED_CLASS_INSTANCE.is(dataId)) {
            Instance instance = this.mySelectionModel.getInstance();
            return instance instanceof ClassInstance ? (ClassInstance)instance : null;
        }
        if (InstanceReferenceTreeView.NAVIGATABLE_INSTANCE.is(dataId)) {
            Object node = this.myDebuggerTree.getSelectionPath().getLastPathComponent();
            NodeDescriptorImpl nodeDescriptor = node instanceof DebuggerTreeNodeImpl ? ((DebuggerTreeNodeImpl)node).getDescriptor() : null;
            return nodeDescriptor instanceof InstanceFieldDescriptorImpl ? ((InstanceFieldDescriptorImpl)nodeDescriptor).getInstance() : null;
        }
        return null;
    }

    @Nullable
    private PsiClassNavigation[] getTargetFiles() {
        Instance instance;
        NodeDescriptorImpl nodeDescriptor;
        Object node = this.myDebuggerTree.getSelectionPath().getLastPathComponent();
        String className = null;
        if (node instanceof DebuggerTreeNodeImpl && (nodeDescriptor = ((DebuggerTreeNodeImpl)node).getDescriptor()) instanceof InstanceFieldDescriptorImpl && (instance = ((InstanceFieldDescriptorImpl)nodeDescriptor).getInstance()) != null) {
            if (instance instanceof ClassObj) {
                className = ((ClassObj)instance).getClassName();
            } else {
                className = instance.getClassObj().getClassName();
                if (instance instanceof ArrayInstance) {
                    className = className.replace("[]", "");
                }
            }
        }
        return PsiClassNavigation.getNavigationForClass(this.myProject, className);
    }

    public void dispose() {
        this.myDebugProcess.stop(true);
        this.myDebugProcess.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/views/InstancesTreeView";
                break;
            }
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/views/InstancesTreeView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addGoToInstanceListener";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sortTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultOrdering";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMemoryOrderingSortResult";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandMoreNodesUntilFound";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addContainerChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addExpansionNode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

