/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.editors.strings.FontUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewNodeTreeRenderer
extends ColoredTreeCellRenderer {
    private static final Icon DEFAULT_VIEW_ICON = AndroidDomElementDescriptorProvider.getIconForViewTag("View");
    private static final String ID_KEY = "mID";
    private static final String EMPTY_ID = "NO_ID";
    private static final int ID_START_INDEX = 3;
    private String myHighlight;

    public void customizeCellRenderer(JTree tree, Object nodeValue, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(nodeValue instanceof ViewNode)) {
            return;
        }
        StringBuilder cellTextBuilder = new StringBuilder();
        ViewNode node = (ViewNode)nodeValue;
        SimpleTextAttributes attr = node.isDrawn() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        boolean hasID = false;
        ViewProperty id = node.getProperty(ID_KEY, new String[0]);
        if (id != null && !id.getValue().equals(EMPTY_ID)) {
            hasID = true;
            cellTextBuilder.append(id.getValue().substring(3) + " ");
        }
        String[] name = node.name.split("\\.");
        String elementName = name[name.length - 1];
        cellTextBuilder.append(hasID ? "(" + elementName + ") " : elementName + " ");
        this.setIcon(ViewNodeTreeRenderer.findIconForNode(elementName));
        this.displayText(attr, cellTextBuilder.toString());
        if (node.displayInfo.contentDesc != null) {
            Font currentFont = this.getFont();
            Font f = FontUtil.getFontAbleToDisplay(node.displayInfo.contentDesc, currentFont);
            if (f != null && f != currentFont) {
                this.setFont(f);
            }
            this.displayText(node.isDrawn() ? new SimpleTextAttributes(0, Color.GRAY) : attr, "- \"" + node.displayInfo.contentDesc + "\"");
        }
    }

    private void displayText(SimpleTextAttributes attr, String cellText) {
        if (this.myHighlight == null || this.myHighlight.isEmpty()) {
            this.append(cellText, attr);
        } else {
            List<String> outputs = AndroidTextUtils.splitKeepDelimiter(cellText, this.myHighlight);
            SimpleTextAttributes highlightAttr = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
            for (String s : outputs) {
                if (s.equals(this.myHighlight)) {
                    this.append(s, highlightAttr);
                    continue;
                }
                this.append(s, attr);
            }
        }
    }

    @Nullable
    private static Icon findIconForNode(@NotNull String elementName) {
        if (elementName == null) {
            ViewNodeTreeRenderer.$$$reportNull$$$0(0);
        }
        Icon icon = null;
        String[] words = elementName.split("(?=\\p{Upper})");
        for (int index = 0; icon == null && index < words.length; ++index) {
            StringBuilder builder = new StringBuilder();
            for (int i = index; i < words.length; ++i) {
                builder.append(words[i]);
            }
            icon = AndroidDomElementDescriptorProvider.getIconForViewTag(builder.toString());
        }
        return icon != null ? icon : DEFAULT_VIEW_ICON;
    }

    public void setHighlight(@Nullable String highlight) {
        this.myHighlight = highlight;
    }

    @Nullable
    public String getHighlight() {
        return this.myHighlight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "com/android/tools/idea/editors/layoutInspector/ui/ViewNodeTreeRenderer", "findIconForNode"));
    }
}

