/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class SelectedEditorFeature
implements FileEditorManagerListener {
    private final Project myProject;
    private final FileEditor myEditor;
    private boolean myOpen;
    private boolean mySelected;
    private boolean myFeatureStarted;

    public SelectedEditorFeature(@NotNull FileEditor editor, @NotNull Project project) {
        if (editor == null) {
            SelectedEditorFeature.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SelectedEditorFeature.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myEditor = editor;
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)editor);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
    }

    public void selectNotify() {
        if (!this.myOpen) {
            this.myOpen = true;
            this.mySelected = Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()).contains(this.myEditor);
            this.startFeature();
        }
    }

    public void deselectNotify() {
        if (this.myOpen) {
            this.myOpen = false;
            this.mySelected = false;
            this.stopFeature();
        }
    }

    private void startFeature() {
        if (this.myOpen && this.mySelected && !this.myFeatureStarted) {
            if (this.isReady()) {
                this.open();
                this.myFeatureStarted = true;
            } else {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> ApplicationManager.getApplication().invokeLater(this::startFeature), 100L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private void stopFeature() {
        if (this.myFeatureStarted) {
            this.myFeatureStarted = false;
            this.close();
        }
    }

    public abstract boolean isReady();

    public abstract void open();

    public abstract void close();

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            SelectedEditorFeature.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SelectedEditorFeature.$$$reportNull$$$0(3);
        }
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            SelectedEditorFeature.$$$reportNull$$$0(4);
        }
        if (file == null) {
            SelectedEditorFeature.$$$reportNull$$$0(5);
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            SelectedEditorFeature.$$$reportNull$$$0(6);
        }
        if (event.getNewEditor() == this.myEditor) {
            this.myOpen = true;
            this.mySelected = true;
            this.startFeature();
        } else if (event.getOldEditor() == this.myEditor) {
            this.mySelected = false;
            this.stopFeature();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/SelectedEditorFeature";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

