/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.editor.SpecificActivityConfigurable;
import com.android.tools.idea.run.editor.SpecificActivityLaunch;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

public class ActivityChooser
extends DialogWrapper {
    private static final int DROPDOWN_LIMIT = 10;
    private final Module myModule;
    private final ComboBox<Element> myActivitySelector;
    private final JComponent myChooserComponent;
    private final SpecificActivityConfigurable myChooser;
    private final JPanel myPanel;

    protected ActivityChooser(@NotNull Module module) {
        if (module == null) {
            ActivityChooser.$$$reportNull$$$0(0);
        }
        super(module.getProject());
        this.myModule = module;
        this.myChooser = new SpecificActivityConfigurable(module.getProject(), () -> {
            if (module == null) {
                ActivityChooser.$$$reportNull$$$0(4);
            }
            return module;
        });
        this.setTitle("Select Activity");
        List<Element> activities = MergedManifest.get(module).getActivities();
        Element[] first10 = (Element[])activities.stream().limit(10L).toArray(Element[]::new);
        this.myActivitySelector = new ComboBox<Element>(new DefaultComboBoxModel<Element>(first10)){

            protected void selectedItemChanged() {
                super.selectedItemChanged();
                if (this.dataModel.getSelectedItem() == null) {
                    this.fireItemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 701, null, 1));
                }
            }
        };
        if (activities.size() > 10) {
            ((DefaultComboBoxModel)this.myActivitySelector.getModel()).addElement(null);
        }
        this.myActivitySelector.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Element>(){

            protected void customizeCellRenderer(@NotNull JList<? extends Element> list, Element value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    this.append("Specify activity name...");
                } else {
                    this.append(value.getAttributeNS("http://schemas.android.com/apk/res/android", "name"));
                    String label = value.getAttributeNS("http://schemas.android.com/apk/res/android", "label");
                    if (!StringUtil.isEmpty((String)label)) {
                        this.append(" (" + label + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/editors/theme/ActivityChooser$2", "customizeCellRenderer"));
            }
        });
        this.myChooserComponent = this.myChooser.createComponent();
        assert (this.myChooserComponent != null);
        this.myChooserComponent.setVisible(false);
        this.myActivitySelector.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Element item = (Element)e.getItem();
                this.myChooserComponent.setVisible(item == null);
            }
        });
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.myActivitySelector, "North");
        this.myPanel.add(this.myChooserComponent);
        this.init();
    }

    @NotNull
    public String getActivity() {
        if (this.myChooserComponent.isVisible()) {
            SpecificActivityLaunch.State state = new SpecificActivityLaunch.State();
            this.myChooser.applyTo(state);
            String string = state.ACTIVITY_CLASS;
            if (string == null) {
                ActivityChooser.$$$reportNull$$$0(1);
            }
            return string;
        }
        Element item = (Element)this.myActivitySelector.getSelectedItem();
        String string = item.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (string == null) {
            ActivityChooser.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            ActivityChooser.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String activity = this.getActivity();
        Project project = this.myModule.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            return new ValidationInfo(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass c = JavaExecutionUtil.findMainClass((Project)project, (String)activity, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        if (c == null || !c.isInheritor(activityClass, true)) {
            return new ValidationInfo(AndroidBundle.message("not.activity.subclass.error", activity));
        }
        Element element = MergedManifest.get(this.myModule).findActivity(ActivityLocatorUtils.getQualifiedActivityName(c));
        if (element == null) {
            return new ValidationInfo(AndroidBundle.message("activity.not.declared.in.manifest", c.getName()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ActivityChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ActivityChooser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

