/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HotswapAction
extends AndroidStudioGradleAction
implements AnAction.TransparentUpdate {
    public HotswapAction() {
        super("Apply Changes", "Apply Changes", AndroidIcons.RunIcons.HotReload, true);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            HotswapAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            HotswapAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (!InstantRunSettings.isInstantRunEnabled()) {
            presentation.setText("Apply Changes: Instant Run has been disabled");
            return;
        }
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
        if (settings == null) {
            presentation.setText("Apply Changes: No run configuration selected");
            return;
        }
        AndroidSessionInfo session = HotswapAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            presentation.setText(String.format("Apply Changes: No active '%1$s' launch", settings.getName()));
            return;
        }
        ProcessHandler processHandler = HotswapAction.getActiveProcessHandler(project, settings);
        if (processHandler == null) {
            presentation.setText(String.format("Apply Changes: No active '%1$s' launch", settings.getName()));
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (!(configuration instanceof ModuleBasedConfiguration)) {
            presentation.setText(String.format("Apply Changes: '%1$s' is not a module based configuration", settings.getName()));
            return;
        }
        Module module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        if (module == null) {
            presentation.setText(String.format("Apply Changes: No module specified in '%1$s'", settings.getName()));
            return;
        }
        if (!(configuration instanceof AndroidRunConfigurationBase)) {
            presentation.setText(String.format("Apply Changes: '%1$s' is not an Android launch configuration", settings.getName()));
            return;
        }
        if (!((AndroidRunConfigurationBase)configuration).supportsInstantRun()) {
            presentation.setText(String.format("Apply Changes: Configuration '%1$s' does not support instant run", settings.getName()));
            return;
        }
        AndroidVersion androidVersion = InstantRunManager.getMinDeviceApiLevel(processHandler);
        if (androidVersion == null) {
            presentation.setText(String.format("Apply Changes: Cannot locate device from '%1$s'", settings.getName()));
            return;
        }
        if (!InstantRunManager.isInstantRunCapableDeviceVersion(androidVersion)) {
            presentation.setText(String.format("Apply Changes: Target device API level (%1$s) too low for Instant Run", androidVersion));
            return;
        }
        InstantRunGradleSupport status = InstantRunGradleUtils.getIrSupportStatus(InstantRunGradleUtils.getAppModel(module), androidVersion);
        if (status != InstantRunGradleSupport.SUPPORTED) {
            String notification = status.getUserNotification();
            if (notification == null) {
                notification = status.toString();
            }
            presentation.setText("Apply Changes: " + notification);
            return;
        }
        if (!InstantRunGradleUtils.appHasCode(AndroidFacet.getInstance(module))) {
            return;
        }
        presentation.setText("Apply Changes" + HotswapAction.getShortcutText());
        presentation.setEnabled(true);
    }

    @Nullable
    private static String getShortcutText() {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = activeKeymap.getShortcuts("Android.HotswapChanges");
        return shortcuts.length > 0 ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ") " : "";
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        RunnerAndConfigurationSettings settings;
        if (e == null) {
            HotswapAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            HotswapAction.$$$reportNull$$$0(3);
        }
        if ((settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration()) == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not locate current run config settings");
            return;
        }
        AndroidSessionInfo session = HotswapAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not locate an existing session for selected run config.");
            return;
        }
        Executor executor = HotswapAction.getExecutor(session.getExecutorId());
        if (executor == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not identify executor");
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            InstantRunManager.LOG.warn("Hotswap Action could not construct an env");
            return;
        }
        ExecutionEnvironment env = builder.activeTarget().dataContext(e.getDataContext()).build();
        InstantRunUtils.setInvokedViaHotswapAction(env, true);
        InstantRunManager.LOG.info("Invoking hotswap launch");
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Nullable
    private static ProcessHandler getActiveProcessHandler(@Nullable Project project, @Nullable RunnerAndConfigurationSettings settings) {
        if (project == null || settings == null) {
            return null;
        }
        AndroidSessionInfo session = HotswapAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            return null;
        }
        ProcessHandler processHandler = session.getProcessHandler();
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            return null;
        }
        return processHandler;
    }

    @Nullable
    private static AndroidSessionInfo getAndroidSessionInfo(Project project, RunnerAndConfigurationSettings settings) {
        RunConfiguration configuration = settings.getConfiguration();
        if (configuration == null) {
            return null;
        }
        AndroidSessionInfo session = AndroidSessionInfo.findOldSession(project, null, configuration.getUniqueID());
        if (session == null) {
            return null;
        }
        return session;
    }

    @Nullable
    private static Executor getExecutor(@NotNull String executorId) {
        if (executorId == null) {
            HotswapAction.$$$reportNull$$$0(4);
        }
        for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/fd/actions/HotswapAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doPerform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

