/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SystemFonts {
    private static final int CONDENSED_WIDTH = 75;
    private final Map<String, FontFamily> myFonts;

    public SystemFonts(@NotNull DownloadableFontCacheServiceImpl service) {
        if (service == null) {
            SystemFonts.$$$reportNull$$$0(0);
        }
        this.myFonts = SystemFonts.createFonts(service);
    }

    @NotNull
    public Collection<FontFamily> getFontFamilies() {
        Collection<FontFamily> collection = this.myFonts.values();
        if (collection == null) {
            SystemFonts.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public FontFamily getFont(String name) {
        return this.myFonts.get(name);
    }

    private static Map<String, FontFamily> createFonts(@NotNull DownloadableFontCacheServiceImpl service) {
        if (service == null) {
            SystemFonts.$$$reportNull$$$0(2);
        }
        TreeMap<String, FontFamily> fonts = new TreeMap<String, FontFamily>();
        for (String fontName : AndroidDomUtil.AVAILABLE_FAMILIES) {
            FontFamily family = SystemFonts.createFont(service, fontName);
            if (family == null) continue;
            fonts.put(fontName, family);
        }
        return fonts;
    }

    @Nullable
    private static FontFamily createFont(@NotNull DownloadableFontCacheServiceImpl service, @NotNull String systemFontName) {
        if (service == null) {
            SystemFonts.$$$reportNull$$$0(3);
        }
        if (systemFontName == null) {
            SystemFonts.$$$reportNull$$$0(4);
        }
        switch (systemFontName) {
            case "sans-serif": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 100, 100, 300, 400, 500, 700, 900);
            }
            case "sans-serif-condensed": {
                return SystemFonts.findFont(service, systemFontName, "Roboto", 75, 300, 400, 700);
            }
            case "serif": {
                return SystemFonts.findFont(service, systemFontName, "Noto Serif", 100, 400, 700);
            }
            case "monospace": {
                return SystemFonts.findFont(service, systemFontName, "Droid Sans Mono", 100, 400);
            }
            case "serif-monospace": {
                return SystemFonts.findFont(service, systemFontName, "Cutive Mono", 100, 400);
            }
            case "casual": {
                return SystemFonts.findFont(service, systemFontName, "Coming Soon", 100, 400);
            }
            case "cursive": {
                return SystemFonts.findFont(service, systemFontName, "Dancing Script", 100, 400, 700);
            }
            case "sans-serif-smallcaps": {
                return SystemFonts.findFont(service, systemFontName, "Carrois Gothic SC", 100, 400);
            }
        }
        return null;
    }

    @Nullable
    private static FontFamily findFont(@NotNull DownloadableFontCacheServiceImpl service, @NotNull String systemFontName, @NotNull String name, int width, int ... weights) {
        FontFamily family;
        if (service == null) {
            SystemFonts.$$$reportNull$$$0(5);
        }
        if (systemFontName == null) {
            SystemFonts.$$$reportNull$$$0(6);
        }
        if (name == null) {
            SystemFonts.$$$reportNull$$$0(7);
        }
        if ((family = service.findFont(FontProvider.GOOGLE_PROVIDER, name)) == null) {
            return null;
        }
        List filtered = family.getFonts().stream().filter(font -> font.getWidth() == width && Ints.contains((int[])weights, (int)font.getWeight())).map(FontDetail::toMutableFontDetail).collect(Collectors.toList());
        MutableFontDetail wanted = new MutableFontDetail(400, width, false);
        FontDetail best = wanted.findBestMatch((Collection)family.getFonts());
        if (best == null) {
            return null;
        }
        return new FontFamily(FontProvider.GOOGLE_PROVIDER, FontSource.SYSTEM, systemFontName, best.getFontUrl(), "", filtered);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/SystemFonts";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemFontName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/SystemFonts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontFamilies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFonts";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFont";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFont";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

