/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.parser;

import com.android.tools.idea.gradle.editor.parser.GradleEditorModelUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleEditorModelParseContext {
    public static final String NO_ARGS_METHOD_ASSIGNMENT_VALUE = "()";
    private final Multimap<Variable, Assignment> myAssignmentsByVariable;
    private final Multimap<List<String>, Assignment> myAssignmentsByCodeStructure;
    private final List<String> myCodeStructure;
    private final List<String> myCachedVariableQualifier;
    private final Multimap<Variable, Location> myCachedVariables;
    private final List<Value> myCachedValues;
    @NotNull
    private final VirtualFile myTargetFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private VirtualFile myCurrentFile;

    public GradleEditorModelParseContext(@NotNull VirtualFile targetFile, @NotNull Project project) {
        if (targetFile == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(1);
        }
        this.myAssignmentsByVariable = HashMultimap.create();
        this.myAssignmentsByCodeStructure = HashMultimap.create();
        this.myCodeStructure = Lists.newArrayList();
        this.myCachedVariableQualifier = Lists.newArrayList();
        this.myCachedVariables = HashMultimap.create();
        this.myCachedValues = Lists.newArrayList();
        this.myTargetFile = targetFile;
        this.myCurrentFile = targetFile;
        this.myProject = project;
    }

    @NotNull
    public VirtualFile getTargetFile() {
        VirtualFile virtualFile = this.myTargetFile;
        if (virtualFile == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getCurrentFile() {
        VirtualFile virtualFile = this.myCurrentFile;
        if (virtualFile == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public List<Value> getCachedValues() {
        List<Value> list = this.myCachedValues;
        if (list == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void addCachedValue(@NotNull String value, @NotNull TextRange range) {
        if (value == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(6);
        }
        if (range == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(7);
        }
        this.addCachedValue(new Value(value, new Location(this.myCurrentFile, range)));
    }

    public void addCachedValue(@Nullable Value value) {
        this.myCachedValues.add(value);
    }

    public void setCachedValues(@NotNull List<Value> values) {
        if (values == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(8);
        }
        this.myCachedValues.clear();
        this.myCachedValues.addAll(values);
    }

    @NotNull
    public Multimap<Variable, Location> getCachedVariables() {
        Multimap<Variable, Location> multimap = this.myCachedVariables;
        if (multimap == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(9);
        }
        return multimap;
    }

    public void addCachedVariable(@NotNull String variableName, @NotNull TextRange range) {
        if (variableName == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(10);
        }
        if (range == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(11);
        }
        this.addCachedVariable(new Variable(variableName, this.myCachedVariableQualifier), range);
    }

    public void addCachedVariable(@Nullable Variable variable, @NotNull TextRange range) {
        if (range == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(12);
        }
        this.myCachedVariables.put((Object)variable, (Object)new Location(this.myCurrentFile, range));
    }

    @NotNull
    public Collection<Assignment> getAssignments(@NotNull Variable variable) {
        Collection result;
        if (variable == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(13);
        }
        Collection<Object> collection = (result = this.myAssignmentsByVariable.get((Object)variable)) == null ? Collections.emptyList() : result;
        if (collection == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public Collection<Assignment> getAssignments(@NotNull List<String> codeStructure) {
        Collection result;
        if (codeStructure == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(15);
        }
        Collection<Object> collection = (result = this.myAssignmentsByCodeStructure.get(codeStructure)) == null ? Collections.emptyList() : result;
        if (collection == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(16);
        }
        return collection;
    }

    public void onChangeFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(17);
        }
        this.myCurrentFile = file;
    }

    public void onMethodEnter(@NotNull String methodName) {
        if (methodName == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(18);
        }
        this.myCodeStructure.add(methodName);
    }

    public void onMethodExit() {
        if (!this.myCodeStructure.isEmpty()) {
            this.myCodeStructure.remove(this.myCodeStructure.size() - 1);
        }
    }

    public boolean registerAssignmentFromCachedData(String lValueVariableName, @NotNull TextRange range, @NotNull PsiElement valueElement) {
        if (range == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(19);
        }
        if (valueElement == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(20);
        }
        return this.registerAssignmentFromCachedData(new Variable(lValueVariableName, this.myCachedVariableQualifier), range, valueElement);
    }

    public boolean registerAssignmentFromCachedData(Variable lValue, @NotNull TextRange lValueRange, @NotNull PsiElement valueElement) {
        if (lValueRange == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(21);
        }
        if (valueElement == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(22);
        }
        return this.registerAssignmentFromCachedData(lValue, new Location(this.myCurrentFile, lValueRange), valueElement);
    }

    public boolean registerAssignmentFromCachedData(Variable lValue, @NotNull Location lValueLocation, @NotNull PsiElement valueElement) {
        Value valueToUse;
        if (lValueLocation == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(23);
        }
        if (valueElement == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(24);
        }
        if (this.myCachedValues.isEmpty() && this.myCachedVariables.isEmpty()) {
            return false;
        }
        String wholeElementText = GradleEditorModelUtil.unquote(valueElement.getText());
        TextRange wholeElementRange = GradleEditorModelUtil.interestedRange(valueElement);
        if (this.myCachedVariables.isEmpty()) {
            switch (this.myCachedValues.size()) {
                case 0: {
                    valueToUse = null;
                    break;
                }
                case 1: {
                    valueToUse = this.myCachedValues.get(0);
                    break;
                }
                default: {
                    valueToUse = new Value(wholeElementText, new Location(this.myCurrentFile, wholeElementRange));
                    break;
                }
            }
        } else {
            valueToUse = this.myCachedVariables.size() == 1 && GradleEditorModelUtil.isVariable(valueElement.getText(), ((Variable)this.myCachedVariables.keys().iterator().next()).name) ? null : new Value("", new Location(this.myCurrentFile, wholeElementRange));
        }
        TextRange assignmentRange = TextRange.create((int)lValueLocation.range.getStartOffset(), (int)valueElement.getTextRange().getEndOffset());
        this.onAssignment(assignmentRange, lValue, lValueLocation, new Location(this.myCurrentFile, wholeElementRange), valueToUse, wholeElementText, this.myCachedVariables);
        this.resetCaches();
        return true;
    }

    public void onAssignment(@NotNull TextRange assignmentRange, Variable lValue, @NotNull Location lValueLocation, @NotNull Location rValueLocation, @Nullable Value rValue, @Nullable String rValueString, @NotNull Multimap<Variable, Location> dependencies2) {
        if (assignmentRange == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(25);
        }
        if (lValueLocation == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(26);
        }
        if (rValueLocation == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(27);
        }
        if (dependencies2 == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(28);
        }
        this.onAssignment(new Assignment(assignmentRange, lValue, lValueLocation, rValueLocation, this.myCodeStructure, rValue, rValueString, dependencies2));
    }

    public void onAssignment(@NotNull Assignment assignment) {
        if (assignment == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(29);
        }
        this.myAssignmentsByVariable.put((Object)assignment.lValue, (Object)assignment);
        this.myAssignmentsByCodeStructure.put(assignment.codeStructure, (Object)assignment);
    }

    public void rememberVariableQualifier(@NotNull String qualifier) {
        if (qualifier == null) {
            GradleEditorModelParseContext.$$$reportNull$$$0(30);
        }
        if (!qualifier.isEmpty()) {
            this.myCachedVariableQualifier.add(qualifier);
        }
    }

    public void resetCaches() {
        this.myCachedVariableQualifier.clear();
        this.myCachedVariables.clear();
        this.myCachedValues.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStructure";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValueRange";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lValueLocation";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentRange";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rValueLocation";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValues";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedVariables";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCachedValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCachedValues";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCachedVariable";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAssignments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "onChangeFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "onMethodEnter";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerAssignmentFromCachedData";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onAssignment";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "rememberVariableQualifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Location {
        @NotNull
        public final VirtualFile file;
        @NotNull
        public final TextRange range;

        public Location(@NotNull VirtualFile file, @NotNull TextRange range) {
            if (file == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Location.$$$reportNull$$$0(1);
            }
            this.file = file;
            this.range = range;
        }

        public int hashCode() {
            int result = this.file.hashCode();
            result = 31 * result + this.range.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            return this.file.equals(location.file) && this.range.equals((Object)location.range);
        }

        public String toString() {
            return String.format("%s [%d;%d)", this.file.getName(), this.range.getStartOffset(), this.range.getEndOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext$Location";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Value {
        @NotNull
        public final String value;
        @NotNull
        public final Location location;

        public Value(@NotNull String value, @NotNull Location location) {
            if (value == null) {
                Value.$$$reportNull$$$0(0);
            }
            if (location == null) {
                Value.$$$reportNull$$$0(1);
            }
            this.value = value;
            this.location = location;
        }

        @NotNull
        public Value shrink(@NotNull TextRange range) {
            if (range == null) {
                Value.$$$reportNull$$$0(2);
            }
            if (range.equals((Object)this.location.range)) {
                Value value = this;
                if (value == null) {
                    Value.$$$reportNull$$$0(3);
                }
                return value;
            }
            if (range.getStartOffset() < this.location.range.getStartOffset() || range.getStartOffset() >= this.location.range.getEndOffset() || range.getEndOffset() > this.location.range.getEndOffset()) {
                throw new IllegalArgumentException(String.format("Can't shrink value '%s' to range %s. Reason - given range is not inside the current one (%s)", this, range, this.location.range));
            }
            int newValueStartOffset = range.getStartOffset() - this.location.range.getStartOffset();
            int newValueEndOffset = this.value.length() - (this.location.range.getEndOffset() - range.getEndOffset());
            Value value = new Value(this.value.substring(newValueStartOffset, newValueEndOffset), new Location(this.location.file, range));
            if (value == null) {
                Value.$$$reportNull$$$0(4);
            }
            return value;
        }

        public String toString() {
            return String.format("'%s' at %s", this.value, this.location);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "location";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext$Value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext$Value";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shrink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "shrink";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Assignment {
        @NotNull
        public final TextRange assignmentRange;
        @NotNull
        public final Variable lValue;
        @NotNull
        public final Location lValueLocation;
        @NotNull
        public final Location rValueLocation;
        @NotNull
        public final List<String> codeStructure;
        @Nullable
        public final Value value;
        @Nullable
        public final String rValueString;
        @NotNull
        public final Multimap<Variable, Location> dependencies;

        public Assignment(@NotNull TextRange assignmentRange, @NotNull Variable lValue, @NotNull Location lValueLocation, @NotNull Location rValueLocation, @NotNull List<String> codeStructure, @Nullable Value value, @Nullable String rValueString, @NotNull Multimap<Variable, Location> dependencies2) {
            if (assignmentRange == null) {
                Assignment.$$$reportNull$$$0(0);
            }
            if (lValue == null) {
                Assignment.$$$reportNull$$$0(1);
            }
            if (lValueLocation == null) {
                Assignment.$$$reportNull$$$0(2);
            }
            if (rValueLocation == null) {
                Assignment.$$$reportNull$$$0(3);
            }
            if (codeStructure == null) {
                Assignment.$$$reportNull$$$0(4);
            }
            if (dependencies2 == null) {
                Assignment.$$$reportNull$$$0(5);
            }
            this.assignmentRange = assignmentRange;
            this.lValue = lValue;
            this.lValueLocation = lValueLocation;
            this.rValueLocation = rValueLocation;
            this.codeStructure = codeStructure.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(codeStructure);
            this.value = value;
            this.rValueString = rValueString;
            this.dependencies = dependencies2.isEmpty() ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(dependencies2);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(StringUtil.join(this.codeStructure, (String)"->"));
            if (buffer.length() > 0) {
                buffer.append(": ");
            }
            buffer.append(this.lValue);
            if (this.rValueString != null) {
                buffer.append(" = ").append(this.rValueString);
            } else if (this.value != null) {
                buffer.append(" = ").append(this.value);
            }
            if (!this.dependencies.isEmpty()) {
                buffer.append(" depends on ").append(StringUtil.join((Iterable)this.dependencies.keySet(), (String)","));
            }
            return buffer.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "assignmentRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lValueLocation";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rValueLocation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "codeStructure";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependencies";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext$Assignment";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Variable {
        @NotNull
        public final String name;
        @NotNull
        public final List<String> qualifier;

        public Variable(@NotNull String name, @NotNull List<String> qualifier) {
            if (name == null) {
                Variable.$$$reportNull$$$0(0);
            }
            if (qualifier == null) {
                Variable.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.qualifier = ImmutableList.copyOf(qualifier);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            return 31 * result + this.qualifier.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return this.name.equals(variable.name) && this.qualifier.equals(variable.qualifier);
        }

        public String toString() {
            String q = this.qualifier.isEmpty() ? "" : StringUtil.join(this.qualifier, (String)".") + ".";
            return q + this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qualifier";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/parser/GradleEditorModelParseContext$Variable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

