/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleTaskFinder {
    @NotNull
    public static GradleTaskFinder getInstance() {
        GradleTaskFinder gradleTaskFinder = (GradleTaskFinder)ServiceManager.getService(GradleTaskFinder.class);
        if (gradleTaskFinder == null) {
            GradleTaskFinder.$$$reportNull$$$0(0);
        }
        return gradleTaskFinder;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecuteForTest(@NotNull Module[] testedModules, @NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        if (testedModules == null) {
            GradleTaskFinder.$$$reportNull$$$0(1);
        }
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(2);
        }
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(3);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(4);
        }
        ListMultimap<Path, String> allTasks = this.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        ListMultimap<Path, String> testedModulesTasks = this.findTasksToExecute(testedModules, buildMode, testCompileType);
        testedModulesTasks.forEach((path, task) -> {
            if (!allTasks.get(path).contains(task)) {
                allTasks.put(path, task);
            }
        });
        ListMultimap<Path, String> listMultimap = allTasks;
        if (listMultimap == null) {
            GradleTaskFinder.$$$reportNull$$$0(5);
        }
        return listMultimap;
    }

    @NotNull
    public ListMultimap<Path, String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        Project project;
        if (modules == null) {
            GradleTaskFinder.$$$reportNull$$$0(6);
        }
        if (buildMode == null) {
            GradleTaskFinder.$$$reportNull$$$0(7);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(8);
        }
        LinkedHashMultimap tasks = LinkedHashMultimap.create();
        if (BuildMode.ASSEMBLE == buildMode && GradleSyncState.getInstance(project = modules[0].getProject()).lastSyncFailed()) {
            ((StreamEx)StreamEx.of((Object[])modules).map(module -> {
                String projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (projectPath == null) {
                    projectPath = project.getBaseDir().getPath();
                }
                return projectPath;
            }).nonNull().distinct()).map(path -> Paths.get(path, new String[0])).forEach(path -> tasks.put(path, (Object)"assemble"));
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)tasks);
            if (arrayListMultimap == null) {
                GradleTaskFinder.$$$reportNull$$$0(9);
            }
            return arrayListMultimap;
        }
        for (Project module2 : modules) {
            String rootProjectPath;
            if ("buildSrc".equals(module2.getName()) || StringUtil.isEmpty((String)(rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module2)))) continue;
            ArrayList<String> moduleTasks = new ArrayList<String>();
            this.findAndAddGradleBuildTasks((Module)module2, buildMode, moduleTasks, testCompileType);
            if (!(buildMode != BuildMode.REBUILD || tasks.isEmpty() && moduleTasks.isEmpty())) {
                tasks.put((Object)Paths.get(rootProjectPath, new String[0]), (Object)"clean");
            }
            tasks.putAll((Object)Paths.get(rootProjectPath, new String[0]), moduleTasks);
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleTaskFinder.getLogger().info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create((Multimap)tasks);
        if (arrayListMultimap == null) {
            GradleTaskFinder.$$$reportNull$$$0(10);
        }
        return arrayListMultimap;
    }

    private void findAndAddGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull List<String> tasks, @NotNull TestCompileType testCompileType) {
        block21: {
            String gradlePath;
            block20: {
                GradleFacet gradleFacet;
                if (module == null) {
                    GradleTaskFinder.$$$reportNull$$$0(11);
                }
                if (buildMode == null) {
                    GradleTaskFinder.$$$reportNull$$$0(12);
                }
                if (tasks == null) {
                    GradleTaskFinder.$$$reportNull$$$0(13);
                }
                if (testCompileType == null) {
                    GradleTaskFinder.$$$reportNull$$$0(14);
                }
                if ((gradleFacet = GradleFacet.getInstance(module)) == null) {
                    return;
                }
                gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    GradleTaskFinder.getLogger().info(msg);
                    return;
                }
                if (GradleTaskFinder.isCompositeBuild(module)) {
                    String msg = String.format("Module '%1$s' comes from composite build, skip gradle tasks.", module.getName());
                    GradleTaskFinder.getLogger().info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block20;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        this.addAfterSyncTasks(tasks, gradlePath, properties);
                        if (androidModel != null) {
                            this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                            break;
                        }
                        break block21;
                    }
                    case ASSEMBLE: 
                    case REBUILD: {
                        this.addTaskIfSpecified(tasks, gradlePath, properties.ASSEMBLE_TASK_NAME);
                        if (testCompileType != TestCompileType.ALL && androidModel != null) {
                            for (BaseArtifact baseArtifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                                this.addTaskIfSpecified(tasks, gradlePath, baseArtifact.getAssembleTaskName());
                            }
                        }
                        this.addAssembleTasksForTargetVariants(tasks, module);
                        break;
                    }
                    default: {
                        this.addAfterSyncTasks(tasks, gradlePath, properties);
                        if (androidModel != null) {
                            this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                            for (BaseArtifact baseArtifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                                this.addTaskIfSpecified(tasks, gradlePath, baseArtifact.getCompileTaskName());
                            }
                        }
                        if (testCompileType != TestCompileType.UNIT_TESTS) {
                            this.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                            break;
                        }
                        break block21;
                    }
                }
                break block21;
            }
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(this.createBuildTask(gradlePath, gradleTaskName));
                }
                if (TestCompileType.UNIT_TESTS.equals(testCompileType)) {
                    tasks.add(this.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    static boolean isCompositeBuild(@NotNull Module module) {
        if (module == null) {
            GradleTaskFinder.$$$reportNull$$$0(15);
        }
        String projectPath = module.getProject().getBaseDir().getPath();
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)module.getProject()).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return false;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return false;
        }
        VirtualFile moduleFile = module.getModuleFile();
        if (moduleFile == null) {
            return false;
        }
        String modulePath = moduleFile.getParent().getPath();
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            if (!participant.getProjects().contains(modulePath)) continue;
            return true;
        }
        return false;
    }

    private void addAssembleTasksForTargetVariants(@NotNull List<String> tasks, @NotNull Module testOnlyModule) {
        AndroidModuleModel testAndroidModel;
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(16);
        }
        if (testOnlyModule == null) {
            GradleTaskFinder.$$$reportNull$$$0(17);
        }
        if ((testAndroidModel = AndroidModuleModel.get(testOnlyModule)) == null || !testAndroidModel.getFeatures().isTestedTargetVariantsSupported() || testAndroidModel.getAndroidProject().getProjectType() != 2) {
            return;
        }
        for (TestedTargetVariant testedTargetVariant : testAndroidModel.getSelectedVariant().getTestedTargetVariants()) {
            String targetVariantName;
            Variant targetVariant;
            AndroidModuleModel targetAndroidModel;
            String targetProjectGradlePath = testedTargetVariant.getTargetProjectPath();
            Module targetModule = GradleUtil.findModuleByGradlePath(testOnlyModule.getProject(), targetProjectGradlePath);
            if (targetModule == null || (targetAndroidModel = AndroidModuleModel.get(targetModule)) == null || (targetVariant = targetAndroidModel.findVariantByName(targetVariantName = testedTargetVariant.getTargetVariant())) == null) continue;
            this.addTaskIfSpecified(tasks, targetProjectGradlePath, targetVariant.getMainArtifact().getAssembleTaskName());
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(GradleTaskFinder.class);
        if (logger == null) {
            GradleTaskFinder.$$$reportNull$$$0(18);
        }
        return logger;
    }

    private void addAfterSyncTasksForTestArtifacts(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @NotNull AndroidModuleModel androidModel) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(19);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(20);
        }
        if (testCompileType == null) {
            GradleTaskFinder.$$$reportNull$$$0(21);
        }
        if (androidModel == null) {
            GradleTaskFinder.$$$reportNull$$$0(22);
        }
        IdeVariant variant = androidModel.getSelectedVariant();
        Collection<IdeBaseArtifact> testArtifacts = testCompileType.getArtifacts(variant);
        for (IdeBaseArtifact artifact : testArtifacts) {
            for (String taskName : artifact.getIdeSetupTaskNames()) {
                this.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    private void addAfterSyncTasks(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(23);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(24);
        }
        if (properties == null) {
            GradleTaskFinder.$$$reportNull$$$0(25);
        }
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            this.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private void addTaskIfSpecified(@NotNull List<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        String buildTask;
        if (tasks == null) {
            GradleTaskFinder.$$$reportNull$$$0(26);
        }
        if (gradlePath == null) {
            GradleTaskFinder.$$$reportNull$$$0(27);
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName) && !tasks.contains(buildTask = this.createBuildTask(gradlePath, gradleTaskName))) {
            tasks.add(buildTask);
        }
    }

    @NotNull
    public String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            GradleTaskFinder.$$$reportNull$$$0(28);
        }
        if (taskName == null) {
            GradleTaskFinder.$$$reportNull$$$0(29);
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                GradleTaskFinder.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            GradleTaskFinder.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/GradleTaskFinder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testedModules";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildMode";
                break;
            }
            case 4: 
            case 8: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCompileType";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testOnlyModule";
                break;
            }
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectPath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/GradleTaskFinder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecuteForTest";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasksToExecute";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildTask";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecuteForTest";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTasksToExecute";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAndAddGradleBuildTasks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeBuild";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addAssembleTasksForTargetVariants";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasksForTestArtifacts";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addAfterSyncTasks";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addTaskIfSpecified";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

