/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android.level2;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.model.ide.android.IdeLibraries;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.BuildFolderPaths;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeAndroidLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeJavaLibrary;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeModuleLibrary;
import com.android.utils.FileUtils;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IdeLibraryFactory {
    IdeLibraryFactory() {
    }

    @NotNull
    Library create(@NotNull Library library, @NotNull ModelCache modelCache) {
        if (library == null) {
            IdeLibraryFactory.$$$reportNull$$$0(0);
        }
        if (modelCache == null) {
            IdeLibraryFactory.$$$reportNull$$$0(1);
        }
        if (library.getType() == 1) {
            File folder = library.getFolder();
            IdeAndroidLibrary ideAndroidLibrary = new IdeAndroidLibrary(library, modelCache, library.getArtifactAddress(), library.getFolder(), IdeLibraryFactory.getFullPath(folder, library.getManifest()), IdeLibraryFactory.getFullPath(folder, library.getJarFile()), IdeLibraryFactory.getFullPath(folder, library.getResFolder()), IdeLibraryFactory.getFullPath(folder, library.getAssetsFolder()), (Collection<String>)IdeLibraryFactory.getLocalJars(library, folder), IdeLibraryFactory.getFullPath(folder, library.getJniFolder()), IdeLibraryFactory.getFullPath(folder, library.getAidlFolder()), IdeLibraryFactory.getFullPath(folder, library.getRenderscriptFolder()), IdeLibraryFactory.getFullPath(folder, library.getProguardRules()), IdeLibraryFactory.getFullPath(folder, library.getLintJar()), IdeLibraryFactory.getFullPath(folder, library.getExternalAnnotations()), IdeLibraryFactory.getFullPath(folder, library.getPublicResources()), library.getArtifact(), library.getSymbolFile());
            if (ideAndroidLibrary == null) {
                IdeLibraryFactory.$$$reportNull$$$0(2);
            }
            return ideAndroidLibrary;
        }
        if (library.getType() == 2) {
            IdeJavaLibrary ideJavaLibrary = new IdeJavaLibrary(library.getArtifactAddress(), library.getArtifact(), modelCache, library);
            if (ideJavaLibrary == null) {
                IdeLibraryFactory.$$$reportNull$$$0(3);
            }
            return ideJavaLibrary;
        }
        if (library.getType() == 3) {
            IdeModuleLibrary ideModuleLibrary = new IdeModuleLibrary(library, library.getArtifactAddress(), modelCache, library.getProjectPath(), library.getVariant());
            if (ideModuleLibrary == null) {
                IdeLibraryFactory.$$$reportNull$$$0(4);
            }
            return ideModuleLibrary;
        }
        throw new UnsupportedOperationException("Unknown library type " + library.getType());
    }

    @NotNull
    private static ImmutableList<String> getLocalJars(@NotNull Library library, @NotNull File libraryFolderPath) {
        if (library == null) {
            IdeLibraryFactory.$$$reportNull$$$0(5);
        }
        if (libraryFolderPath == null) {
            IdeLibraryFactory.$$$reportNull$$$0(6);
        }
        ImmutableList immutableList = (ImmutableList)library.getLocalJars().stream().map(jar -> {
            if (libraryFolderPath == null) {
                IdeLibraryFactory.$$$reportNull$$$0(25);
            }
            return IdeLibraryFactory.getFullPath(libraryFolderPath, jar);
        }).collect(ImmutableCollectors.toImmutableList());
        if (immutableList == null) {
            IdeLibraryFactory.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @NotNull
    Library create(@NotNull AndroidLibrary androidLibrary, @NotNull BuildFolderPaths moduleBuildDirs, @NotNull ModelCache modelCache) {
        if (androidLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(8);
        }
        if (moduleBuildDirs == null) {
            IdeLibraryFactory.$$$reportNull$$$0(9);
        }
        if (modelCache == null) {
            IdeLibraryFactory.$$$reportNull$$$0(10);
        }
        if (androidLibrary.getProject() != null && !IdeLibraries.isLocalAarModule(androidLibrary, moduleBuildDirs)) {
            IdeModuleLibrary ideModuleLibrary = new IdeModuleLibrary(androidLibrary, IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary), modelCache, androidLibrary.getProject(), androidLibrary.getProjectVariant());
            if (ideModuleLibrary == null) {
                IdeLibraryFactory.$$$reportNull$$$0(11);
            }
            return ideModuleLibrary;
        }
        IdeAndroidLibrary ideAndroidLibrary = new IdeAndroidLibrary(androidLibrary, modelCache, IdeLibraries.computeAddress((com.android.builder.model.Library)androidLibrary), androidLibrary.getFolder(), androidLibrary.getManifest().getPath(), androidLibrary.getJarFile().getPath(), androidLibrary.getResFolder().getPath(), androidLibrary.getAssetsFolder().getPath(), androidLibrary.getLocalJars().stream().map(File::getPath).collect(Collectors.toList()), androidLibrary.getJniFolder().getPath(), androidLibrary.getAidlFolder().getPath(), androidLibrary.getRenderscriptFolder().getPath(), androidLibrary.getProguardRules().getPath(), androidLibrary.getLintJar().getPath(), androidLibrary.getExternalAnnotations().getPath(), androidLibrary.getPublicResources().getPath(), androidLibrary.getBundle(), IdeLibraryFactory.getSymbolFilePath(androidLibrary));
        if (ideAndroidLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(12);
        }
        return ideAndroidLibrary;
    }

    @NotNull
    private static String getFullPath(@NotNull File libraryFolderPath, @NotNull String fileName) {
        if (libraryFolderPath == null) {
            IdeLibraryFactory.$$$reportNull$$$0(13);
        }
        if (fileName == null) {
            IdeLibraryFactory.$$$reportNull$$$0(14);
        }
        String string = FileUtils.join((File)libraryFolderPath, (String[])new String[]{fileName}).getPath();
        if (string == null) {
            IdeLibraryFactory.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static String getSymbolFilePath(@NotNull AndroidLibrary androidLibrary) {
        if (androidLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(16);
        }
        try {
            return androidLibrary.getSymbolFile().getPath();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @NotNull
    Library create(@NotNull JavaLibrary javaLibrary, @NotNull ModelCache modelCache) {
        String project;
        if (javaLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(17);
        }
        if (modelCache == null) {
            IdeLibraryFactory.$$$reportNull$$$0(18);
        }
        if ((project = IdeLibraryFactory.getProject(javaLibrary)) != null) {
            IdeModuleLibrary ideModuleLibrary = new IdeModuleLibrary(javaLibrary, IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary), modelCache, project, null);
            if (ideModuleLibrary == null) {
                IdeLibraryFactory.$$$reportNull$$$0(19);
            }
            return ideModuleLibrary;
        }
        IdeJavaLibrary ideJavaLibrary = new IdeJavaLibrary(IdeLibraries.computeAddress((com.android.builder.model.Library)javaLibrary), javaLibrary.getJarFile(), modelCache, javaLibrary);
        if (ideJavaLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(20);
        }
        return ideJavaLibrary;
    }

    @Nullable
    private static String getProject(@NotNull JavaLibrary javaLibrary) {
        if (javaLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(21);
        }
        try {
            return javaLibrary.getProject();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    @NotNull
    static Library create(@NotNull String projectPath, @NotNull ModelCache modelCache) {
        if (projectPath == null) {
            IdeLibraryFactory.$$$reportNull$$$0(22);
        }
        if (modelCache == null) {
            IdeLibraryFactory.$$$reportNull$$$0(23);
        }
        IdeModuleLibrary ideModuleLibrary = new IdeModuleLibrary(projectPath, projectPath, modelCache, projectPath, null);
        if (ideModuleLibrary == null) {
            IdeLibraryFactory.$$$reportNull$$$0(24);
        }
        return ideModuleLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 10: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/ide/android/level2/IdeLibraryFactory";
                break;
            }
            case 6: 
            case 13: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFolderPath";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidLibrary";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuildDirs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaLibrary";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/ide/android/level2/IdeLibraryFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalJars";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocalJars";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFullPath";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolFilePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocalJars$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

