/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkToolsVersionSetupStep
extends ProjectSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    private volatile boolean myNewSdkVersionToolsInfoAlreadyShown;

    public SdkToolsVersionSetupStep() {
        this(IdeSdks.getInstance());
    }

    @VisibleForTesting
    SdkToolsVersionSetupStep(@NotNull IdeSdks ideSdks) {
        if (ideSdks == null) {
            SdkToolsVersionSetupStep.$$$reportNull$$$0(0);
        }
        this.myIdeSdks = ideSdks;
    }

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (project == null) {
            SdkToolsVersionSetupStep.$$$reportNull$$$0(1);
        }
        if (this.myNewSdkVersionToolsInfoAlreadyShown) {
            return;
        }
        File androidHome = this.myIdeSdks.getAndroidSdkPath();
        if (androidHome != null && !VersionCheck.isCompatibleVersion(androidHome)) {
            InstallSdkToolsHyperlink hyperlink = new InstallSdkToolsHyperlink(VersionCheck.MIN_TOOLS_REV);
            String message = "Version " + VersionCheck.MIN_TOOLS_REV + " or later is required.";
            AndroidNotification.getInstance(project).showBalloon("Android SDK Tools", message, NotificationType.INFORMATION, hyperlink);
            this.myNewSdkVersionToolsInfoAlreadyShown = true;
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return true;
    }

    @VisibleForTesting
    boolean isNewSdkVersionToolsInfoAlreadyShown() {
        return this.myNewSdkVersionToolsInfoAlreadyShown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @VisibleForTesting
    static class InstallSdkToolsHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Revision myVersion;

        InstallSdkToolsHyperlink(@NotNull Revision version) {
            if (version == null) {
                InstallSdkToolsHyperlink.$$$reportNull$$$0(0);
            }
            super("install.sdk.tools", "Install latest SDK Tools");
            this.myVersion = version;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                InstallSdkToolsHyperlink.$$$reportNull$$$0(1);
            }
            ArrayList requested = Lists.newArrayList();
            if (this.myVersion.getMajor() == 23) {
                Revision minBuildToolsRev = new Revision(20, 0, 0);
                requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
            }
            requested.add("tools");
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog != null && dialog.showAndGet()) {
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
            }
        }

        @VisibleForTesting
        @NotNull
        Revision getVersion() {
            Revision revision = this.myVersion;
            if (revision == null) {
                InstallSdkToolsHyperlink.$$$reportNull$$$0(2);
            }
            return revision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep$InstallSdkToolsHyperlink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/SdkToolsVersionSetupStep$InstallSdkToolsHyperlink";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

