/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TimeBasedUpgradeReminder {
    private static final String SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY = "sync.plugin.last.upgrade.timestamp";

    TimeBasedUpgradeReminder() {
    }

    boolean shouldRecommendUpgrade(@NotNull Project project) {
        if (project == null) {
            TimeBasedUpgradeReminder.$$$reportNull$$$0(0);
        }
        return this.shouldRecommendUpgrade(project, System.currentTimeMillis());
    }

    @VisibleForTesting
    boolean shouldRecommendUpgrade(@NotNull Project project, long currentTimeInMs) {
        String lastTimestampValue;
        if (project == null) {
            TimeBasedUpgradeReminder.$$$reportNull$$$0(1);
        }
        if (StringUtil.isNotEmpty((String)(lastTimestampValue = this.getStoredTimestamp(project)))) {
            try {
                long lastTimestamp = Long.parseLong(lastTimestampValue);
                long elapsed = currentTimeInMs - lastTimestamp;
                long days = TimeUnit.MILLISECONDS.toDays(elapsed);
                return days >= 1L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    @VisibleForTesting
    @Nullable
    String getStoredTimestamp(@NotNull Project project) {
        if (project == null) {
            TimeBasedUpgradeReminder.$$$reportNull$$$0(2);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY);
    }

    void storeLastUpgradeRecommendation(@NotNull Project project) {
        if (project == null) {
            TimeBasedUpgradeReminder.$$$reportNull$$$0(3);
        }
        this.storeLastUpgradeRecommendation(project, System.currentTimeMillis());
    }

    @VisibleForTesting
    void storeLastUpgradeRecommendation(@NotNull Project project, long currentTimeInMs) {
        if (project == null) {
            TimeBasedUpgradeReminder.$$$reportNull$$$0(4);
        }
        PropertiesComponent.getInstance((Project)project).setValue(SYNC_PLUGIN_LAST_UPGRADE_TIMESTAMP_PROPERTY, String.valueOf(currentTimeInMs));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/upgrade/TimeBasedUpgradeReminder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRecommendUpgrade";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStoredTimestamp";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "storeLastUpgradeRecommendation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

