/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.DependencyNodeComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDependencyNode
extends AbstractDependencyNode<PsLibraryAndroidDependency> {
    @NotNull
    private final List<AbstractDependencyNode> myChildren;

    public LibraryDependencyNode(@NotNull AbstractPsNode parent, @NotNull PsLibraryAndroidDependency dependency) {
        if (parent == null) {
            LibraryDependencyNode.$$$reportNull$$$0(0);
        }
        if (dependency == null) {
            LibraryDependencyNode.$$$reportNull$$$0(1);
        }
        super(parent, dependency);
        this.myChildren = Lists.newArrayList();
        this.setUp(dependency);
    }

    public LibraryDependencyNode(@NotNull AbstractPsNode parent, @NotNull List<PsLibraryAndroidDependency> dependencies2) {
        if (parent == null) {
            LibraryDependencyNode.$$$reportNull$$$0(2);
        }
        if (dependencies2 == null) {
            LibraryDependencyNode.$$$reportNull$$$0(3);
        }
        super(parent, dependencies2);
        this.myChildren = Lists.newArrayList();
        assert (!dependencies2.isEmpty());
        this.setUp(dependencies2.get(0));
    }

    private void setUp(@NotNull PsLibraryAndroidDependency dependency) {
        if (dependency == null) {
            LibraryDependencyNode.$$$reportNull$$$0(4);
        }
        this.myName = this.getText(dependency);
        ImmutableCollection<PsDependency> transitiveDependencies = dependency.getTransitiveDependencies();
        transitiveDependencies.stream().filter(transitive -> transitive instanceof PsLibraryAndroidDependency).forEach(transitive -> {
            PsLibraryAndroidDependency transitiveLibrary = (PsLibraryAndroidDependency)transitive;
            LibraryDependencyNode child = new LibraryDependencyNode((AbstractPsNode)this, transitiveLibrary);
            this.myChildren.add(child);
        });
        Collections.sort(this.myChildren, DependencyNodeComparator.INSTANCE);
    }

    @NotNull
    private String getText(@NotNull PsLibraryAndroidDependency dependency) {
        if (dependency == null) {
            LibraryDependencyNode.$$$reportNull$$$0(5);
        }
        PsArtifactDependencySpec resolvedSpec = dependency.getResolvedSpec();
        if (dependency.hasPromotedVersion() && !(this.getParent() instanceof LibraryDependencyNode)) {
            PsArtifactDependencySpec declaredSpec = dependency.getDeclaredSpec();
            assert (declaredSpec != null);
            String version = declaredSpec.getVersion() + "\u2192" + resolvedSpec.getVersion();
            String string = LibraryDependencyNode.getTextForSpec(declaredSpec.getName(), version, declaredSpec.getGroup());
            if (string == null) {
                LibraryDependencyNode.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = resolvedSpec.getDisplayText();
        if (string == null) {
            LibraryDependencyNode.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static String getTextForSpec(@NotNull String name, @NotNull String version, @Nullable String group) {
        if (name == null) {
            LibraryDependencyNode.$$$reportNull$$$0(8);
        }
        if (version == null) {
            LibraryDependencyNode.$$$reportNull$$$0(9);
        }
        boolean showGroupId = PsUISettings.getInstance().DECLARED_DEPENDENCIES_SHOW_GROUP_ID;
        StringBuilder text = new StringBuilder();
        if (showGroupId && StringUtil.isNotEmpty((String)group)) {
            text.append(group).append(":");
        }
        text.append(name).append(":").append(version);
        String string = text.toString();
        if (string == null) {
            LibraryDependencyNode.$$$reportNull$$$0(10);
        }
        return string;
    }

    public SimpleNode[] getChildren() {
        return this.myChildren.toArray(new SimpleNode[this.myChildren.size()]);
    }

    @Override
    public boolean matches(@NotNull PsModel model) {
        if (model == null) {
            LibraryDependencyNode.$$$reportNull$$$0(11);
        }
        if (model instanceof PsLibraryAndroidDependency) {
            PsLibraryAndroidDependency other = (PsLibraryAndroidDependency)model;
            List models = this.getModels();
            for (PsLibraryAndroidDependency dependency : models) {
                if (!dependency.getResolvedSpec().equals(other.getResolvedSpec())) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/treeview/LibraryDependencyNode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setUp";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextForSpec";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

