/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.structure.editors.MavenDependencyLookupDialog;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesTableItem;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesTableModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.structure.EditorPanel;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.android.tools.idea.templates.SupportLibrary;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.SimpleTextCellAppearance;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ActionRunner;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependenciesPanel
extends EditorPanel {
    private static final Logger LOG = Logger.getInstance(ModuleDependenciesPanel.class);
    private static final int SCOPE_COLUMN_WIDTH = 120;
    private final JBTable myEntryTable;
    private final ModuleDependenciesTableModel myModel;
    private final String myModulePath;
    private final Project myProject;
    private final GradleBuildFile myGradleBuildFile;
    private final GradleSettingsFile myGradleSettingsFile;
    private AnActionButton myRemoveButton;

    public ModuleDependenciesPanel(@NotNull Project project, @NotNull String modulePath) {
        if (project == null) {
            ModuleDependenciesPanel.$$$reportNull$$$0(0);
        }
        if (modulePath == null) {
            ModuleDependenciesPanel.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myModulePath = modulePath;
        this.myProject = project;
        this.myModel = new ModuleDependenciesTableModel();
        this.myGradleSettingsFile = GradleSettingsFile.get(this.myProject);
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, modulePath);
        GradleBuildFile gradleBuildFile = this.myGradleBuildFile = module != null ? GradleBuildFile.get(module) : null;
        if (this.myGradleBuildFile != null) {
            List<BuildFileStatement> dependencies2 = this.myGradleBuildFile.getDependencies();
            for (BuildFileStatement dependency : dependencies2) {
                this.myModel.addItem(new ModuleDependenciesTableItem(dependency));
            }
        } else {
            LOG.warn("Unable to find Gradle build file for module " + this.myModulePath);
        }
        this.myModel.resetModified();
        this.myEntryTable = new JBTable((TableModel)this.myModel);
        TableRowSorter<ModuleDependenciesTableModel> sorter = new TableRowSorter<ModuleDependenciesTableModel>(this.myModel);
        sorter.setRowFilter(this.myModel.getFilter());
        this.myEntryTable.setRowSorter(sorter);
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.setDefaultRenderer(ModuleDependenciesTableItem.class, (TableCellRenderer)((Object)new TableItemRenderer()));
        if (this.myGradleBuildFile == null) {
            return;
        }
        boolean isAndroid = this.myGradleBuildFile.hasAndroidPlugin();
        boolean compat = GradleUtil.useCompatibilityConfigurationNames(project);
        ArrayList scopes = Lists.newArrayList((Iterable)Sets.filter(EnumSet.allOf(Dependency.Scope.class), input -> input != null && compat == input.isCompat() && (isAndroid ? input.isAndroidScope() : input.isJavaScope())));
        CollectionComboBoxModel boxModel = new CollectionComboBoxModel((List)scopes, null);
        ComboBox scopeEditor = new ComboBox((ComboBoxModel)boxModel);
        this.myEntryTable.setDefaultEditor(Dependency.Scope.class, (TableCellEditor)new DefaultCellEditor((JComboBox<?>)scopeEditor));
        this.myEntryTable.setDefaultRenderer(Dependency.Scope.class, (TableCellRenderer)new ComboBoxTableRenderer<Dependency.Scope>(Dependency.Scope.values()){

            protected String getTextFor(@NotNull Dependency.Scope value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                return value.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesPanel$1", "getTextFor"));
            }
        });
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        new SpeedSearchBase<JBTable>(this.myEntryTable){

            public int getSelectedIndex() {
                return ModuleDependenciesPanel.this.myEntryTable.getSelectedRow();
            }

            protected int convertIndexToModel(int viewIndex) {
                return ModuleDependenciesPanel.this.myEntryTable.convertRowIndexToModel(viewIndex);
            }

            @NotNull
            public Object[] getAllElements() {
                Object[] objectArray = ModuleDependenciesPanel.this.myModel.getItems().toArray();
                if (objectArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            @NotNull
            public String getElementText(Object element) {
                String string = ModuleDependenciesPanel.getCellAppearance((ModuleDependenciesTableItem)element).getText();
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void selectElement(@NotNull Object element, @NotNull String selectedText) {
                if (element == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (selectedText == null) {
                    2.$$$reportNull$$$0(3);
                }
                int count = ModuleDependenciesPanel.this.myModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ModuleDependenciesPanel.this.myModel.getItemAt(row))) continue;
                    int viewRow = ModuleDependenciesPanel.this.myEntryTable.convertRowIndexToView(row);
                    ModuleDependenciesPanel.this.myEntryTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)ModuleDependenciesPanel.this.myEntryTable);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesPanel$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectedText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementText";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesPanel$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "selectElement";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        TableColumn column = this.myEntryTable.getTableHeader().getColumnModel().getColumn(1);
        column.setResizable(false);
        column.setMaxWidth(120);
        column.setMinWidth(120);
        this.add((Component)this.createTableWithButtons(), "Center");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)this.myRemoveButton);
        PopupHandler.installPopupHandler((JComponent)this.myEntryTable, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    private JComponent createTableWithButtons() {
        this.myEntryTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateButtons();
        });
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myEntryTable);
        decorator.setAddAction(button -> {
            ImmutableList popupActions = ImmutableList.of((Object)new PopupAction(StudioIcons.Shell.Filetree.MAVEN, 1, "Library dependency"){

                @Override
                public void run() {
                    ModuleDependenciesPanel.this.addExternalDependency();
                }
            }, (Object)new PopupAction(StudioIcons.Shell.Filetree.LIBRARY_MODULE, 2, "Jar dependency"){

                @Override
                public void run() {
                    ModuleDependenciesPanel.this.addFileDependency();
                }
            }, (Object)new PopupAction(StudioIcons.Shell.Filetree.ANDROID_MODULE, 3, "Module dependency"){

                @Override
                public void run() {
                    ModuleDependenciesPanel.this.addModuleDependency();
                }
            });
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<PopupAction>(null, (List)popupActions){

                public Icon getIconFor(PopupAction value) {
                    return value.myIcon;
                }

                public boolean hasSubstep(PopupAction value) {
                    return false;
                }

                public boolean isMnemonicsNavigationEnabled() {
                    return true;
                }

                public PopupStep onChosen(PopupAction value, boolean finalChoice) {
                    return this.doFinalStep(value);
                }

                @NotNull
                public String getTextFor(PopupAction value) {
                    String string = "&" + value.myIndex + "  " + value.myTitle;
                    if (string == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesPanel$6", "getTextFor"));
                }
            });
            popup2.show(button.getPreferredPopupPoint());
        });
        decorator.setRemoveAction(button -> this.removeSelectedItems());
        decorator.setMoveUpAction(button -> this.moveSelectedRows(-1));
        decorator.setMoveDownAction(button -> this.moveSelectedRows(1));
        JPanel panel = decorator.createPanel();
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)panel);
        JPanel jPanel = panel;
        if (jPanel == null) {
            ModuleDependenciesPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void addExternalDependency() {
        Module module = GradleUtil.findModuleByGradlePath(this.myProject, this.myModulePath);
        MavenDependencyLookupDialog dialog = new MavenDependencyLookupDialog(this.myProject, module);
        dialog.setTitle("Choose Library Dependency");
        dialog.show();
        if (dialog.getExitCode() == 0) {
            String coordinateText = dialog.getSearchText();
            if ((coordinateText = this.installRepositoryIfNeeded(coordinateText)) != null) {
                Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
                this.myModel.addItem(new ModuleDependenciesTableItem(new Dependency(scope, Dependency.Type.EXTERNAL, coordinateText)));
            }
        }
        this.myModel.fireTableDataChanged();
    }

    private String installRepositoryIfNeeded(String coordinateText) {
        SdkMavenRepository repository;
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)coordinateText);
        assert (gradleCoordinate != null);
        SupportLibrary supportLibrary = SupportLibrary.forGradleCoordinate(gradleCoordinate);
        if (!"0.0.+".equals(gradleCoordinate.getRevision()) || supportLibrary == null) {
            return coordinateText;
        }
        String message = "Library " + gradleCoordinate.getArtifactId() + " is not installed. Install repository?";
        if (Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)"Install Repository", (Icon)Messages.getQuestionIcon()) != 0) {
            return null;
        }
        ArrayList requested = Lists.newArrayList();
        if (coordinateText.startsWith("com.android.support")) {
            repository = SdkMavenRepository.ANDROID;
        } else if (coordinateText.startsWith("com.google.android")) {
            repository = SdkMavenRepository.GOOGLE;
        } else {
            assert (false);
            return coordinateText + ':' + "0.0.+";
        }
        requested.add(repository.getPackageId());
        ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(this.myProject, requested);
        if (dialog != null) {
            dialog.setTitle("Install Missing Components");
            if (dialog.showAndGet()) {
                return RepositoryUrlManager.get().getLibraryStringCoordinate(supportLibrary, true);
            }
        }
        return null;
    }

    private void addFileDependency() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false);
        VirtualFile buildFile = this.myGradleBuildFile.getFile();
        VirtualFile parent = buildFile.getParent();
        descriptor.setRoots(new VirtualFile[]{parent});
        VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
        if (virtualFile != null) {
            String path = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)parent, (char)'/');
            if (path == null) {
                path = virtualFile.getPath();
            }
            Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
            this.myModel.addItem(new ModuleDependenciesTableItem(new Dependency(scope, Dependency.Type.FILES, path)));
        }
        this.myModel.fireTableDataChanged();
    }

    private void addModuleDependency() {
        ArrayList modules = Lists.newArrayList();
        for (String string : this.myGradleSettingsFile.getModules()) {
            modules.add(string);
        }
        List<BuildFileStatement> dependencies2 = this.myGradleBuildFile.getDependencies();
        for (BuildFileStatement dependency : dependencies2) {
            Object data;
            if (!(dependency instanceof Dependency) || !((data = ((Dependency)dependency).data) instanceof String)) continue;
            modules.remove(data);
        }
        modules.remove(this.myModulePath);
        ModuleDependenciesPanel moduleDependenciesPanel = this;
        String title = ProjectBundle.message((String)"classpath.chooser.title.add.module.dependency", (Object[])new Object[0]);
        String description = ProjectBundle.message((String)"classpath.chooser.description.add.module.dependency", (Object[])new Object[0]);
        ChooseElementsDialog<String> dialog = new ChooseElementsDialog<String>((Component)moduleDependenciesPanel, (List)modules, title, description, true){

            protected Icon getItemIcon(String item) {
                return StudioIcons.Shell.Filetree.ANDROID_MODULE;
            }

            protected String getItemText(String item) {
                return item;
            }
        };
        dialog.show();
        Dependency.Scope scope = Dependency.Scope.getDefaultScope(this.myProject);
        for (String module : dialog.getChosenElements()) {
            this.myModel.addItem(new ModuleDependenciesTableItem(new Dependency(scope, Dependency.Type.MODULE, module)));
        }
        this.myModel.fireTableDataChanged();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateButtons();
    }

    private void updateButtons() {
        int[] selectedRows = this.myEntryTable.getSelectedRows();
        boolean removeButtonEnabled = true;
        int minRow = this.myEntryTable.getRowCount() + 1;
        int maxRow = -1;
        for (int selectedRow : selectedRows) {
            minRow = Math.min(minRow, selectedRow);
            maxRow = Math.max(maxRow, selectedRow);
            ModuleDependenciesTableItem item = this.myModel.getItemAt(selectedRow);
            if (item.isRemovable()) continue;
            removeButtonEnabled = false;
        }
        if (this.myRemoveButton != null) {
            this.myRemoveButton.setEnabled(removeButtonEnabled && selectedRows.length > 0);
        }
    }

    private void removeSelectedItems() {
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        for (int modelRow = this.myModel.getRowCount() - 1; modelRow >= 0; --modelRow) {
            if (!this.myEntryTable.isCellSelected(this.myEntryTable.convertRowIndexToView(modelRow), 0)) continue;
            this.myModel.removeDataRow(modelRow);
        }
        this.myModel.fireTableDataChanged();
        this.myModel.setModified();
    }

    private void moveSelectedRows(int increment) {
        int modelRow;
        if (increment == 0) {
            return;
        }
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = this.myEntryTable.getSelectionModel();
        int n = modelRow = increment < 0 ? 0 : this.myModel.getRowCount() - 1;
        while (increment < 0 ? modelRow < this.myModel.getRowCount() : modelRow >= 0) {
            int visibleRow = this.myEntryTable.convertRowIndexToView(modelRow);
            if (selectionModel.isSelectedIndex(visibleRow)) {
                int newVisibleRow = this.myEntryTable.convertRowIndexToView(this.moveRow(modelRow, increment));
                selectionModel.removeSelectionInterval(visibleRow, visibleRow);
                this.myModel.fireTableDataChanged();
                selectionModel.addSelectionInterval(newVisibleRow, newVisibleRow);
            }
            modelRow += increment < 0 ? 1 : -1;
        }
        Rectangle cellRect = this.myEntryTable.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        this.myEntryTable.scrollRectToVisible(cellRect);
        this.myEntryTable.repaint();
    }

    private int moveRow(int row, int increment) {
        int newIndex = Math.abs(row + increment) % this.myModel.getRowCount();
        ModuleDependenciesTableItem item = this.myModel.removeDataRow(row);
        this.myModel.addItemAt(item, newIndex);
        return newIndex;
    }

    @NotNull
    private static CellAppearanceEx getCellAppearance(@NotNull ModuleDependenciesTableItem item) {
        if (item == null) {
            ModuleDependenciesPanel.$$$reportNull$$$0(3);
        }
        BuildFileStatement entry = item.getEntry();
        String data = "";
        Icon icon = null;
        if (entry instanceof Dependency) {
            Dependency dependency = (Dependency)entry;
            data = dependency.getValueAsString();
            switch (dependency.type) {
                case EXTERNAL: {
                    icon = StudioIcons.Shell.Filetree.MAVEN;
                    break;
                }
                case FILES: {
                    icon = StudioIcons.Shell.Filetree.LIBRARY_MODULE;
                    break;
                }
                case MODULE: {
                    icon = StudioIcons.Shell.Filetree.ANDROID_MODULE;
                }
            }
        } else if (entry != null) {
            data = entry.toString();
        }
        SimpleTextCellAppearance simpleTextCellAppearance = SimpleTextCellAppearance.regular((String)data, icon);
        if (simpleTextCellAppearance == null) {
            ModuleDependenciesPanel.$$$reportNull$$$0(4);
        }
        return simpleTextCellAppearance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply() {
        List<ModuleDependenciesTableItem> items = this.myModel.getItems();
        ArrayList dependencies2 = Lists.newArrayListWithExpectedSize((int)items.size());
        for (ModuleDependenciesTableItem item : items) {
            dependencies2.add(item.getEntry());
        }
        DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
        try {
            ActionRunner.runInsideWriteAction(() -> this.myGradleBuildFile.setValue(BuildFileKey.DEPENDENCIES, dependencies2));
        }
        catch (Exception e) {
            LOG.error("Unable to commit dependency changes", (Throwable)e);
        }
        finally {
            DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
        }
        this.myModel.resetModified();
    }

    @Override
    public boolean isModified() {
        return this.myModel.isModified();
    }

    public void select(@NotNull GradleCoordinate dependency) {
        int row;
        if (dependency == null) {
            ModuleDependenciesPanel.$$$reportNull$$$0(5);
        }
        if ((row = this.myModel.getRow(dependency)) >= 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableWithButtons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellAppearance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCellAppearance";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class PopupAction
    implements Runnable {
        private final Icon myIcon;
        private final int myIndex;
        private final String myTitle;

        protected PopupAction(Icon icon, int index, String title) {
            this.myIcon = icon;
            this.myIndex = index;
            this.myTitle = title;
        }

        public String toString() {
            return this.myTitle;
        }
    }

    private static class TableItemRenderer
    extends ColoredTableCellRenderer {
        private final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private TableItemRenderer() {
        }

        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(this.NO_FOCUS_BORDER);
            if (value != null && value instanceof ModuleDependenciesTableItem) {
                ModuleDependenciesTableItem tableItem = (ModuleDependenciesTableItem)value;
                ModuleDependenciesPanel.getCellAppearance(tableItem).customize((SimpleColoredComponent)this);
                this.setToolTipText(tableItem.getTooltipText());
            }
        }
    }
}

