/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.ClientData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.ddms.OpenVmTraceHandler;
import com.android.tools.idea.ddms.actions.DumpSysActions;
import com.android.tools.idea.ddms.actions.LayoutInspectorAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenshotAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.ddms.adb.AdbService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.MonitorContentFactory;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.ProjectTopics;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidToolWindowFactory
implements ToolWindowFactory,
DumbAware,
Condition<Project> {
    private static final String ANDROID_LOGCAT_CONTENT_ID = "Android Logcat";
    @NonNls
    private static final String ADBLOGS_CONTENT_ID = "AdbLogsContent";
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public void createToolWindowContent(final @NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(1);
        }
        ExecutionManager.getInstance((Project)project).getContentManager();
        RunnerLayoutUi layoutUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("Android", AndroidToolWindowFactory.getToolWindowId(), "Logcat", (Disposable)project);
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        DeviceContext deviceContext = new DeviceContext();
        if (AndroidToolWindowFactory.showMonitors()) {
            ClientData.setMethodProfilingHandler((ClientData.IMethodProfilingHandler)new OpenVmTraceHandler(project));
        }
        final AndroidLogcatView logcatView = new AndroidLogcatView(project, deviceContext, AndroidToolWindowFactory.getToolWindowId(), !AndroidToolWindowFactory.showMonitors());
        Content logcatContent = AndroidToolWindowFactory.createLogcatContent(layoutUi, project, logcatView);
        layoutUi.addContent(logcatContent, 0, PlaceInGrid.center, false);
        JPanel searchComponent = logcatView.createSearchComponent();
        DevicePanel devicePanel = new DevicePanel(project, deviceContext);
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)devicePanel.getComponent(), "West");
        if (AndroidToolWindowFactory.showMonitors()) {
            logcatContent.setSearchComponent((JComponent)searchComponent);
            MonitorContentFactory.createMonitorContent(project, deviceContext, layoutUi);
            layoutUi.getOptions().setLeftToolbar(this.getToolbarActions(project, deviceContext), "unknown");
            layoutUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

                public void selectionChanged(ContentManagerEvent event) {
                    Content selectedContent = event.getContent();
                    BaseMonitorView view = (BaseMonitorView)selectedContent.getUserData(BaseMonitorView.MONITOR_VIEW_KEY);
                    if (view != null && event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PROFILING).setKind(AndroidStudioEvent.EventKind.MONITOR_RUNNING).setMonitorType(view.getMonitorType()));
                    }
                }
            }, (Disposable)project);
        } else {
            searchComponent.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            northPanel.add((Component)searchComponent, "Center");
        }
        final JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project);
        northPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        loadingPanel.add((Component)northPanel, (Object)"North");
        loadingPanel.add((Component)layoutUi.getComponent(), (Object)"Center");
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)loadingPanel, "", true);
        c.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        c.putUserData(DEVICES_PANEL_KEY, (Object)devicePanel);
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ConsoleView console;
                logcatView.activate();
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.getToolWindowId());
                if (window != null && window.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                    AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                }
            }
        }, project.getDisposed());
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        loadingPanel.setLoadingText("Initializing ADB");
        loadingPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                Logger.getInstance(AndroidToolWindowFactory.class).info("Successfully obtained debug bridge");
                loadingPanel.stopLoading();
            }

            public void onFailure(@NotNull Throwable t) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                loadingPanel.stopLoading();
                Logger.getInstance(AndroidToolWindowFactory.class).info("Unable to obtain debug bridge", t);
                Messages.showErrorDialog((String)AdbService.getDebugBridgeDiagnosticErrorMessage(t, adb), (String)"ADB Connection Error");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/monitor/AndroidToolWindowFactory$3", "onFailure"));
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    public static String getToolWindowId() {
        return AndroidToolWindowFactory.showMonitors() ? "Android Monitor" : "Logcat";
    }

    @NotNull
    public ActionGroup getToolbarActions(Project project, DeviceContext deviceContext) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ScreenshotAction(project, deviceContext));
        group.add((AnAction)new ScreenRecorderAction(project, deviceContext));
        group.add((AnAction)DumpSysActions.create(project, deviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new TerminateVMAction(deviceContext));
        group.add((AnAction)new LayoutInspectorAction(project, deviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("Android Monitor", "http://developer.android.com/r/studio-ui/android-monitor.html"));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    private static Content createLogcatContent(RunnerLayoutUi layoutUi, final Project project, final AndroidLogcatView logcatView) {
        ToolWindowManagerEx.getInstanceEx((Project)project).addToolWindowManagerListener((ToolWindowManagerListener)new ToolWindowManagerAdapter(){
            boolean myToolWindowVisible;

            public void stateChanged() {
                boolean visible;
                ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidToolWindowFactory.getToolWindowId());
                if (window != null && (visible = window.isVisible()) != this.myToolWindowVisible) {
                    ConsoleView console;
                    this.myToolWindowVisible = visible;
                    logcatView.activate();
                    if (visible && (console = logcatView.getLogConsole().getConsole()) != null) {
                        AndroidToolWindowFactory.checkFacetAndSdk(project, console);
                    }
                }
            }
        });
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        JPanel logcatContentPanel = logcatView.getContentPanel();
        Content logcatContent = layoutUi.createContent(ANDROID_LOGCAT_CONTENT_ID, (JComponent)logcatContentPanel, "logcat", StudioIcons.Shell.ToolWindows.LOGCAT, null);
        logcatContent.putUserData(AndroidLogcatView.ANDROID_LOGCAT_VIEW_KEY, (Object)logcatView);
        logcatContent.setDisposer((Disposable)logcatView);
        logcatContent.setCloseable(false);
        logcatContent.setPreferredFocusableComponent((JComponent)logcatContentPanel);
        return logcatContent;
    }

    private static void checkFacetAndSdk(Project project, @NotNull ConsoleView console) {
        List facets;
        if (console == null) {
            AndroidToolWindowFactory.$$$reportNull$$$0(3);
        }
        if ((facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID)).isEmpty()) {
            console.clear();
            console.print(AndroidBundle.message("android.logcat.no.android.facets.error", new Object[0]), ConsoleViewContentType.ERROR_OUTPUT);
            return;
        }
        AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
        AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
        if (platform == null) {
            console.clear();
            final Module module = facet.getModule();
            if (!AndroidMavenUtil.isMavenizedModule(module)) {
                console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
                console.printHyperlink("configure", new HyperlinkInfo(){

                    public void navigate(Project project) {
                        AndroidSdkUtils.openModuleDependenciesConfigurable(module);
                    }
                });
                console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
            } else {
                console.print(AndroidBundle.message("android.maven.cannot.parse.android.sdk.error", module.getName()) + '\n', ConsoleViewContentType.ERROR_OUTPUT);
            }
        }
    }

    static boolean showMonitors() {
        return StudioFlags.PROFILER_ENABLED.get() == false;
    }

    public boolean value(Project project) {
        return !AndroidToolWindowFactory.showMonitors();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/AndroidToolWindowFactory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/AndroidToolWindowFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFacetAndSdk";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAndroidPlatformListener
    implements ModuleRootListener {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyAndroidPlatformListener.$$$reportNull$$$0(0);
            }
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(ModuleRootEvent event) {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(AndroidToolWindowFactory.getToolWindowId());
            if (window == null) {
                return;
            }
            if (window.isDisposed() || !window.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Comparing.equal((Object)this.myPrevPlatform, (Object)newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!window.isDisposed() && window.isVisible()) {
                        this.myView.activate();
                    }
                });
            }
        }

        @Nullable
        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (!facets.isEmpty()) {
                AndroidFacet facet = (AndroidFacet)((Object)facets.get(0));
                newPlatform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
            }
            return newPlatform;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/monitor/AndroidToolWindowFactory$MyAndroidPlatformListener", "<init>"));
        }
    }
}

