/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGenerator;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class MenuIconGenerator
extends GraphicGenerator {
    @Override
    public BufferedImage generate(GraphicGeneratorContext context, GraphicGenerator.Options options) {
        if (options.usePlaceholders) {
            return PLACEHOLDER_IMAGE;
        }
        BufferedImage sourceImage = MenuIconGenerator.getTrimmedAndPaddedImage(options);
        if (sourceImage == null) {
            sourceImage = AssetStudioUtils.createDummyImage();
        }
        Rectangle imageSizeHdpi = new Rectangle(0, 0, 48, 48);
        Rectangle targetRectHdpi = new Rectangle(8, 8, 32, 32);
        float scaleFactor = GraphicGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = AssetUtil.scaleRectangle((Rectangle)imageSizeHdpi, (float)scaleFactor);
        Rectangle targetRect = AssetUtil.scaleRectangle((Rectangle)targetRectHdpi, (float)scaleFactor);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)sourceImage, (Rectangle)targetRect);
        AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new GradientPaint(0.0f, 0.0f, new Color(0xA3A3A3), 0.0f, imageRect.height, new Color(0x787878))), new AssetUtil.ShadowEffect(0.0, (double)(2.0f * scaleFactor), (double)(2.0f * scaleFactor), Color.BLACK, 0.2, true), new AssetUtil.ShadowEffect(0.0, 1.0, 0.0, Color.BLACK, 0.35, true), new AssetUtil.ShadowEffect(0.0, -1.0, 0.0, Color.WHITE, 0.35, true)});
        g.dispose();
        g2.dispose();
        return outImage;
    }
}

