/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public final class VectorAsset
extends BaseAsset {
    private static final String ERROR_EMPTY_PREVIEW = "Could not generate a preview";
    private final ObjectProperty<FileType> myFileType;
    private final ObjectProperty<File> myPath;
    private final IntProperty myOpacity;
    private final BoolProperty myAutoMirrored;
    private final IntProperty myOutputWidth;
    private final IntProperty myOutputHeight;

    public VectorAsset(@NotNull FileType fileType) {
        if (fileType == null) {
            VectorAsset.$$$reportNull$$$0(0);
        }
        this.myFileType = new ObjectValueProperty<FileType>(FileType.SVG);
        this.myPath = new ObjectValueProperty<File>(new File(System.getProperty("user.home")));
        this.myOpacity = new IntValueProperty(100);
        this.myAutoMirrored = new BoolValueProperty();
        this.myOutputWidth = new IntValueProperty();
        this.myOutputHeight = new IntValueProperty();
        this.type().set(fileType);
    }

    @NotNull
    public static FileType typeFromExtension(@NotNull String path) {
        if (path == null) {
            VectorAsset.$$$reportNull$$$0(1);
        }
        String fullPath = new File(path).getAbsolutePath();
        int index = fullPath.lastIndexOf(46);
        String extension = path.substring(index + 1);
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "svg": {
                FileType fileType = FileType.SVG;
                if (fileType == null) {
                    VectorAsset.$$$reportNull$$$0(2);
                }
                return fileType;
            }
            case "psd": {
                FileType fileType = FileType.LAYERED_IMAGE;
                if (fileType == null) {
                    VectorAsset.$$$reportNull$$$0(3);
                }
                return fileType;
            }
        }
        FileType fileType = FileType.VECTOR_DRAWABLE;
        if (fileType == null) {
            VectorAsset.$$$reportNull$$$0(4);
        }
        return fileType;
    }

    @NotNull
    public ObjectProperty<FileType> type() {
        ObjectProperty<FileType> objectProperty = this.myFileType;
        if (objectProperty == null) {
            VectorAsset.$$$reportNull$$$0(5);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<File> path() {
        ObjectProperty<File> objectProperty = this.myPath;
        if (objectProperty == null) {
            VectorAsset.$$$reportNull$$$0(6);
        }
        return objectProperty;
    }

    @NotNull
    public IntProperty opacity() {
        IntProperty intProperty = this.myOpacity;
        if (intProperty == null) {
            VectorAsset.$$$reportNull$$$0(7);
        }
        return intProperty;
    }

    @NotNull
    public BoolProperty autoMirrored() {
        BoolProperty boolProperty = this.myAutoMirrored;
        if (boolProperty == null) {
            VectorAsset.$$$reportNull$$$0(8);
        }
        return boolProperty;
    }

    @NotNull
    public IntProperty outputWidth() {
        IntProperty intProperty = this.myOutputWidth;
        if (intProperty == null) {
            VectorAsset.$$$reportNull$$$0(9);
        }
        return intProperty;
    }

    @NotNull
    public IntProperty outputHeight() {
        IntProperty intProperty = this.myOutputHeight;
        if (intProperty == null) {
            VectorAsset.$$$reportNull$$$0(10);
        }
        return intProperty;
    }

    @NotNull
    public ParseResult parse(int previewWidth, boolean allowPropertyOverride) {
        ParseResult parseResult = this.tryParse(previewWidth, allowPropertyOverride);
        if (parseResult == null) {
            VectorAsset.$$$reportNull$$$0(11);
        }
        return parseResult;
    }

    @NotNull
    public ParseResult parse() {
        ParseResult parseResult = this.parse(0, true);
        if (parseResult == null) {
            VectorAsset.$$$reportNull$$$0(12);
        }
        return parseResult;
    }

    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        return Futures.immediateFuture((Object)this.parse().getImage());
    }

    @NotNull
    private ParseResult tryParse(int previewWidth, boolean allowPropertyOverride) {
        Document vdDocument;
        StringBuilder errorBuffer = new StringBuilder();
        File path = (File)this.myPath.get();
        if (!path.exists() || path.isDirectory()) {
            ParseResult parseResult = ParseResult.INVALID;
            if (parseResult == null) {
                VectorAsset.$$$reportNull$$$0(13);
            }
            return parseResult;
        }
        String xmlFileContent = null;
        FileType fileType = (FileType)((Object)this.myFileType.get());
        if (fileType.equals((Object)FileType.SVG)) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            String errorLog = Svg2Vector.parseSvgToXml((File)path, (OutputStream)outStream);
            errorBuffer.append(errorLog);
            xmlFileContent = ((Object)outStream).toString();
        } else if (fileType.equals((Object)FileType.LAYERED_IMAGE)) {
            try {
                xmlFileContent = new LayeredImageConverter().toVectorDrawableXml(path);
            }
            catch (IOException e) {
                errorBuffer.append(e.getMessage());
            }
        } else {
            try {
                xmlFileContent = Files.toString((File)path, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                errorBuffer.append(e.getMessage());
            }
        }
        BufferedImage image = null;
        int originalWidth = 0;
        int originalHeight = 0;
        if (xmlFileContent != null && (vdDocument = VdPreview.parseVdStringIntoDocument((String)xmlFileContent, (StringBuilder)errorBuffer)) != null) {
            String overriddenXml;
            VdPreview.SourceSize vdOriginalSize = VdPreview.getVdOriginalSize((Document)vdDocument);
            originalWidth = vdOriginalSize.getWidth();
            originalHeight = vdOriginalSize.getHeight();
            if (allowPropertyOverride && (overriddenXml = this.overrideXmlFileContent(vdDocument, vdOriginalSize, errorBuffer)) != null) {
                xmlFileContent = overriddenXml;
            }
            if (previewWidth <= 0) {
                previewWidth = (Integer)this.myOutputWidth.get() > 0 ? (Integer)this.myOutputWidth.get() : originalWidth;
            }
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)previewWidth);
            try {
                image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xmlFileContent, (StringBuilder)errorBuffer);
            }
            catch (Throwable e) {
                Logger.getInstance(this.getClass()).error(e);
            }
        }
        if (image == null) {
            errorBuffer.insert(0, "Could not generate a preview\n");
            ParseResult parseResult = new ParseResult(errorBuffer.toString());
            if (parseResult == null) {
                VectorAsset.$$$reportNull$$$0(14);
            }
            return parseResult;
        }
        ParseResult parseResult = new ParseResult(errorBuffer.toString(), image, originalWidth, originalHeight, xmlFileContent);
        if (parseResult == null) {
            VectorAsset.$$$reportNull$$$0(15);
        }
        return parseResult;
    }

    @Nullable
    private String overrideXmlFileContent(@NotNull Document vdDocument, @NotNull VdPreview.SourceSize vdOriginalSize, @NotNull StringBuilder errorBuffer) {
        if (vdDocument == null) {
            VectorAsset.$$$reportNull$$$0(16);
        }
        if (vdOriginalSize == null) {
            VectorAsset.$$$reportNull$$$0(17);
        }
        if (errorBuffer == null) {
            VectorAsset.$$$reportNull$$$0(18);
        }
        int finalWidth = vdOriginalSize.getWidth();
        int finalHeight = vdOriginalSize.getHeight();
        Integer outputWidth = (Integer)this.myOutputWidth.get();
        Integer outputHeight = (Integer)this.myOutputHeight.get();
        if (outputWidth > 0) {
            finalWidth = outputWidth;
        }
        if (outputHeight > 0) {
            finalHeight = outputHeight;
        }
        finalWidth = Math.max(1, finalWidth);
        finalHeight = Math.max(1, finalHeight);
        finalWidth = Math.min(4096, finalWidth);
        finalHeight = Math.min(4096, finalHeight);
        VdOverrideInfo overrideInfo = new VdOverrideInfo(finalWidth, finalHeight, ((Integer)this.myOpacity.get()).intValue(), ((Boolean)this.myAutoMirrored.get()).booleanValue());
        return VdPreview.overrideXmlContent((Document)vdDocument, (VdOverrideInfo)overrideInfo, (StringBuilder)errorBuffer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vdDocument";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vdOriginalSize";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "typeFromExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "path";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "opacity";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "autoMirrored";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "outputWidth";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "outputHeight";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tryParse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "typeFromExtension";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "overrideXmlFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ParseResult {
        private static final ParseResult INVALID = new ParseResult();
        @NotNull
        private final String myErrors;
        @Nullable
        private final BufferedImage myImage;
        private final int myOriginalWidth;
        private final int myOriginalHeight;
        private final boolean myIsValid;
        @NotNull
        private final String myXmlContent;

        private ParseResult() {
            this("", null, 0, 0, "");
        }

        public ParseResult(@NotNull String errors) {
            if (errors == null) {
                ParseResult.$$$reportNull$$$0(0);
            }
            this(errors, INVALID.getImage(), 0, 0, "");
        }

        public ParseResult(@NotNull String errors, @Nullable BufferedImage image, int originalWidth, int originalHeight, @NotNull String xmlContent) {
            if (errors == null) {
                ParseResult.$$$reportNull$$$0(1);
            }
            if (xmlContent == null) {
                ParseResult.$$$reportNull$$$0(2);
            }
            this.myErrors = errors;
            this.myImage = image;
            this.myOriginalWidth = originalWidth;
            this.myOriginalHeight = originalHeight;
            this.myXmlContent = xmlContent;
            this.myIsValid = originalWidth > 0 && originalHeight > 0;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        public int getOriginalWidth() {
            return this.myOriginalWidth;
        }

        public int getOriginalHeight() {
            return this.myOriginalHeight;
        }

        @NotNull
        public String getErrors() {
            String string = this.myErrors;
            if (string == null) {
                ParseResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public BufferedImage getImage() {
            return this.myImage;
        }

        @NotNull
        public String getXmlContent() {
            String string = this.myXmlContent;
            if (string == null) {
                ParseResult.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "xmlContent";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/VectorAsset$ParseResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrors";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getXmlContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum FileType {
        SVG,
        LAYERED_IMAGE,
        VECTOR_DRAWABLE;

    }
}

