/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.wizard;

import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import com.android.tools.idea.npw.assetstudio.icon.AndroidVectorIconGenerator;
import com.android.tools.idea.npw.assetstudio.ui.VectorAssetBrowser;
import com.android.tools.idea.npw.assetstudio.ui.VectorIconButton;
import com.android.tools.idea.npw.assetstudio.wizard.ConfirmGenerateIconsStep;
import com.android.tools.idea.npw.assetstudio.wizard.GenerateIconsModel;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.adapters.StringToIntAdapterProperty;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.Expression;
import com.android.tools.idea.observable.expressions.optional.AsOptionalExpression;
import com.android.tools.idea.observable.expressions.string.FormatExpression;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.SliderValueProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.ui.VectorImageComponent;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NewVectorAssetStep
extends ModelWizardStep<GenerateIconsModel> {
    private static final int DEFAULT_MATERIAL_ICON_SIZE = 24;
    private static final String ICON_PREFIX = "ic_";
    private static final String VECTOR_ASSET_PATH_PROPERTY = "VectorAssetImportPath";
    private final AndroidVectorIconGenerator myIconGenerator;
    private final ObjectProperty<VectorAsset> myActiveAsset;
    private final OptionalProperty<Dimension> myOriginalSize;
    private final BoolProperty isValidAsset;
    private final VectorPreviewUpdater myPreviewUpdater;
    private final IdeResourceNameValidator myNameValidator;
    private final BindingsManager myGeneralBindings;
    private final BindingsManager myActiveAssetBindings;
    private final ListenerManager myListeners;
    @NotNull
    private final AndroidFacet myFacet;
    private final ValidatorPanel myValidatorPanel;
    private JPanel myPanel;
    private VectorImageComponent myImagePreview;
    private JLabel myImageFileLabel;
    private JTextField myOutputNameField;
    private JPanel myErrorPanel;
    private JPanel myBrowserPanel;
    private JTextField myWidthTextField;
    private JTextField myHeightTextField;
    private JCheckBox myEnableAutoMirroredCheckBox;
    private JPanel myPreviewPanel;
    private JSlider myOpacitySlider;
    private JPanel myResizePanel;
    private JLabel mySizeLabel;
    private JPanel myResourceNamePanel;
    private JRadioButton myMaterialIconRadioButton;
    private JRadioButton myLocalFileRadioButton;
    private JPanel myOpacityPanel;
    private JPanel myIconPickerPanel;
    private JCheckBox myOverrideSizeCheckBox;
    private JBLabel myOpacityValueLabel;
    private JPanel myLeftPanel;
    private JPanel myRightPanel;
    private JPanel mySourceAssetRadioButtons;
    private JPanel mySourceAssetTypePanel;
    private VectorAssetBrowser myBrowser;
    private VectorIconButton myIconButton;
    private JBScrollPane myErrorsScrollPane;
    private JTextArea myErrorsTextArea;

    public NewVectorAssetStep(@NotNull GenerateIconsModel model, @NotNull AndroidFacet facet) {
        if (model == null) {
            NewVectorAssetStep.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            NewVectorAssetStep.$$$reportNull$$$0(1);
        }
        super(model, "Configure Vector Asset");
        this.$$$setupUI$$$();
        this.myOriginalSize = new OptionalValueProperty<Dimension>();
        this.isValidAsset = new BoolValueProperty();
        this.myPreviewUpdater = new VectorPreviewUpdater();
        this.myNameValidator = IdeResourceNameValidator.forFilename(ResourceFolderType.DRAWABLE);
        this.myGeneralBindings = new BindingsManager();
        this.myActiveAssetBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myFacet = facet;
        int minSdkVersion = AndroidModuleInfo.getInstance(this.myFacet).getMinSdkVersion().getApiLevel();
        this.myIconGenerator = new AndroidVectorIconGenerator(minSdkVersion);
        this.myMaterialIconRadioButton.setSelected(true);
        this.myActiveAsset = new ObjectValueProperty<VectorAsset>(this.myIconButton.getAsset());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        List<ConfirmGenerateIconsStep> list = Collections.singletonList(new ConfirmGenerateIconsStep((GenerateIconsModel)this.getModel(), AndroidSourceSet.getSourceSets(this.myFacet, null)));
        if (list == null) {
            NewVectorAssetStep.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            NewVectorAssetStep.$$$reportNull$$$0(3);
        }
        Runnable onAssetModified = this.myPreviewUpdater::enqueueUpdate;
        this.loadAssetPath();
        SelectedProperty iconSelected = new SelectedProperty(this.myMaterialIconRadioButton);
        this.myListeners.receiveAndFire(iconSelected, isIconActive -> {
            this.myIconPickerPanel.setVisible((boolean)isIconActive);
            this.myBrowserPanel.setVisible(isIconActive == false);
            this.myActiveAsset.set(isIconActive != false ? this.myIconButton.getAsset() : this.myBrowser.getAsset());
        });
        ActionListener assetListener = actionEvent -> {
            onAssetModified.run();
            this.saveAssetPath();
        };
        this.myIconButton.addAssetListener(assetListener);
        this.myBrowser.addAssetListener(assetListener);
        Disposer.register((Disposable)this, (Disposable)this.myIconButton);
        Disposer.register((Disposable)this, (Disposable)this.myBrowser);
        SelectedProperty overrideSize = new SelectedProperty(this.myOverrideSizeCheckBox);
        IntValueProperty width = new IntValueProperty();
        IntValueProperty height = new IntValueProperty();
        this.myGeneralBindings.bindTwoWay(new StringToIntAdapterProperty(new TextProperty(this.myWidthTextField)), width);
        this.myGeneralBindings.bindTwoWay(new StringToIntAdapterProperty(new TextProperty(this.myHeightTextField)), height);
        this.myGeneralBindings.bind(new EnabledProperty(this.myWidthTextField), overrideSize);
        this.myGeneralBindings.bind(new EnabledProperty(this.myHeightTextField), overrideSize);
        this.myListeners.listenAll(overrideSize, this.myOriginalSize).withAndFire(() -> {
            if (!((Boolean)overrideSize.get()).booleanValue() || !((Optional)this.myOriginalSize.get()).isPresent()) {
                width.set(24);
                height.set(24);
            } else {
                width.set(this.myOriginalSize.getValue().width);
                height.set(this.myOriginalSize.getValue().height);
            }
        });
        SliderValueProperty opacityValue = new SliderValueProperty(this.myOpacitySlider);
        this.myGeneralBindings.bind(new TextProperty((JLabel)this.myOpacityValueLabel), new FormatExpression("%d %%", opacityValue));
        SelectedProperty autoMirrored = new SelectedProperty(this.myEnableAutoMirroredCheckBox);
        this.myListeners.listenAll(this.myActiveAsset, overrideSize, width, height, opacityValue, autoMirrored).with(onAssetModified);
        TextProperty name = new TextProperty(this.myOutputNameField);
        this.myListeners.listenAndFire(this.myActiveAsset, sender -> {
            this.myActiveAssetBindings.releaseAll();
            this.myActiveAssetBindings.bind(name, new Expression<String>(new ObservableValue[]{((VectorAsset)this.myActiveAsset.get()).path()}){

                @Override
                @NotNull
                public String get() {
                    File path = (File)((VectorAsset)NewVectorAssetStep.this.myActiveAsset.get()).path().get();
                    if (path.exists() && !path.isDirectory()) {
                        String name1 = FileUtil.getNameWithoutExtension((File)path).toLowerCase(Locale.getDefault());
                        if (!name1.startsWith(NewVectorAssetStep.ICON_PREFIX)) {
                            name1 = NewVectorAssetStep.ICON_PREFIX + AndroidResourceUtil.getValidResourceFileName(name1);
                        }
                        String string = AndroidResourceUtil.getValidResourceFileName(name1);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }
                    if ("ic_vector_name" == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return "ic_vector_name";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/wizard/NewVectorAssetStep$1", "get"));
                }
            });
            this.myValidatorPanel.registerValidator((ObservableValue)name, value -> Validator.Result.fromNullableMessage((String)this.myNameValidator.getErrorText((String)value)));
            this.myValidatorPanel.registerTest((ObservableValue)this.isValidAsset, "The specified asset could not be parsed. Please choose another asset.");
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).opacity(), opacityValue);
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).autoMirrored(), autoMirrored);
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).outputWidth(), width);
            this.myActiveAssetBindings.bind(((VectorAsset)this.myActiveAsset.get()).outputHeight(), height);
        });
        ApplicationManager.getApplication().invokeLater(onAssetModified, ModalityState.any());
        this.myGeneralBindings.bind(this.myIconGenerator.sourceAsset(), new AsOptionalExpression<VectorAsset>(this.myActiveAsset));
        this.myGeneralBindings.bind(this.myIconGenerator.name(), name);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            NewVectorAssetStep.$$$reportNull$$$0(4);
        }
        return validatorPanel;
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            NewVectorAssetStep.$$$reportNull$$$0(5);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        ((GenerateIconsModel)this.getModel()).setIconGenerator(this.myIconGenerator);
    }

    @Override
    public void dispose() {
        this.myGeneralBindings.releaseAll();
        this.myActiveAssetBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myIconGenerator.dispose();
    }

    private void saveAssetPath() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myFacet.getModule().getProject());
        File path = (File)this.myBrowser.getAsset().path().get();
        properties.setValue(VECTOR_ASSET_PATH_PROPERTY, path.getParent());
    }

    private void loadAssetPath() {
        Project project = this.myFacet.getModule().getProject();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)project);
        String lastPath = properties.getValue(VECTOR_ASSET_PATH_PROPERTY);
        if (lastPath != null) {
            String defaultPath = FileUtil.toSystemDependentName((String)lastPath);
            this.myBrowser.getAsset().path().set(new File(defaultPath));
        } else {
            String projectPath = project.getBasePath();
            if (projectPath != null) {
                String defaultPath = FileUtil.toSystemDependentName((String)projectPath);
                this.myBrowser.getAsset().path().set(new File(defaultPath));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/wizard/NewVectorAssetStep";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/wizard/NewVectorAssetStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        VectorImageComponent vectorImageComponent;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JPanel jPanel3;
        JBLabel jBLabel;
        JSlider jSlider;
        JPanel jPanel4;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel5;
        JPanel jPanel6;
        VectorAssetBrowser vectorAssetBrowser;
        JLabel jLabel2;
        JPanel jPanel7;
        VectorIconButton vectorIconButton;
        JPanel jPanel8;
        JTextField jTextField;
        JPanel jPanel9;
        JPanel jPanel10;
        JTextArea jTextArea;
        JBScrollPane jBScrollPane;
        JPanel jPanel11;
        JPanel jPanel12;
        this.myPanel = jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.setMinimumSize(new Dimension(720, 512));
        jPanel12.setPreferredSize(new Dimension(-1, -1));
        jPanel12.setToolTipText("");
        this.myErrorPanel = jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel11).setEnabled(true);
        jPanel12.add((Component)jPanel11, new GridConstraints(1, 0, 1, 2, 2, 1, 3, 3, null, null, null));
        jPanel11.setBorder(BorderFactory.createTitledBorder(null, "Errors", 0, 0, null, null));
        this.myErrorsScrollPane = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel11.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        this.myErrorsTextArea = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myLeftPanel = jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.myResourceNamePanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel9, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        jPanel9.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, 15), null, null));
        this.myOutputNameField = jTextField = new JTextField();
        jTextField.setText("(name)");
        jPanel9.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, new Dimension(-1, 20), null, null));
        this.myIconPickerPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Icon:");
        jPanel8.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIconButton = vectorIconButton = new VectorIconButton();
        jPanel8.add((Component)vectorIconButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(24, 24), null));
        this.myBrowserPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel7).setVisible(true);
        jPanel10.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        this.myImageFileLabel = jLabel2 = new JLabel();
        jLabel2.setText("Path:");
        jPanel7.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBrowser = vectorAssetBrowser = new VectorAssetBrowser();
        jPanel7.add((Component)((Object)vectorAssetBrowser), new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.mySourceAssetTypePanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel6, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.mySourceAssetRadioButtons = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myMaterialIconRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Material Icon");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLocalFileRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Local file (SVG, PSD)");
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Asset Type:");
        jPanel6.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOpacityPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Opacity:");
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel13, new GridConstraints(0, 1, 1, 1, 8, 2, 7, 3, null, null, null));
        this.myOpacitySlider = jSlider = new JSlider();
        jSlider.setMajorTickSpacing(20);
        jSlider.setMinorTickSpacing(10);
        jSlider.setPaintLabels(false);
        jSlider.setPaintTicks(false);
        jSlider.setPaintTrack(true);
        jSlider.setValue(100);
        jPanel13.add((Component)jSlider, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myOpacityValueLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(4);
        jBLabel.setText("100 %");
        jPanel13.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(40, -1), null));
        this.myResizePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 3, null, null, null, 0, true));
        this.mySizeLabel = jLabel = new JLabel();
        jLabel.setText("Size:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel3.add((Component)jPanel14, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 3, new Dimension(-1, 25), null, null));
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        this.myWidthTextField = jFormattedTextField;
        jFormattedTextField.setText("24");
        jPanel14.add((Component)jFormattedTextField, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("dp  X ");
        jPanel14.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JFormattedTextField jFormattedTextField2 = new JFormattedTextField();
        this.myHeightTextField = jFormattedTextField2;
        jFormattedTextField2.setText("24");
        jPanel14.add((Component)jFormattedTextField2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("dp");
        jPanel14.add((Component)jLabel6, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOverrideSizeCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        jCheckBox2.setText("Override");
        jCheckBox2.setToolTipText("Check to override the default Material Design size");
        jPanel14.add((Component)jCheckBox2, new GridConstraints(0, 4, 1, 1, 8, 0, 7, 0, null, null, null, 1));
        this.myEnableAutoMirroredCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable auto mirroring for RTL layout");
        jCheckBox.setToolTipText("Check if your icon should flip in right-to-left layouts.");
        jPanel10.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel10.add((Component)spacer, new GridConstraints(7, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myRightPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPreviewPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 20, 0, 20), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 0, 3, 6, null, null, null));
        this.myImagePreview = vectorImageComponent = new VectorImageComponent();
        jPanel.add((Component)((Object)vectorImageComponent), new GridConstraints(0, 0, 1, 1, 1, 0, 3, 7, new Dimension(256, 256), new Dimension(256, 256), null, 1));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Vector Drawable Preview");
        jPanel.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private final class VectorPreviewUpdater {
        @Nullable
        private SwingWorker<Void, Void> myCurrentWorker;
        @Nullable
        private SwingWorker<Void, Void> myEnqueuedWorker;

        private VectorPreviewUpdater() {
        }

        public void enqueueUpdate() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myCurrentWorker == null) {
                this.myCurrentWorker = this.createWorker();
                this.myCurrentWorker.execute();
            } else if (this.myEnqueuedWorker == null) {
                this.myEnqueuedWorker = this.createWorker();
            }
        }

        private SwingWorker<Void, Void> createWorker() {
            return new SwingWorker<Void, Void>(){
                VectorAsset.ParseResult myParseResult;

                @Override
                protected Void doInBackground() throws Exception {
                    try {
                        this.myParseResult = ((VectorAsset)NewVectorAssetStep.this.myActiveAsset.get()).parse(NewVectorAssetStep.this.myImagePreview.getWidth(), true);
                    }
                    catch (Throwable t) {
                        Logger.getInstance(this.getClass()).error(t);
                        this.myParseResult = new VectorAsset.ParseResult("Internal error parsing " + ((File)((VectorAsset)NewVectorAssetStep.this.myActiveAsset.get()).path().get()).getName());
                    }
                    return null;
                }

                @Override
                protected void done() {
                    assert (this.myParseResult != null);
                    NewVectorAssetStep.this.isValidAsset.set(this.myParseResult.isValid());
                    if (this.myParseResult.isValid()) {
                        BufferedImage image = this.myParseResult.getImage();
                        NewVectorAssetStep.this.myImagePreview.setIcon(image == null ? null : new ImageIcon(image));
                        NewVectorAssetStep.this.myOriginalSize.setValue(new Dimension(this.myParseResult.getOriginalWidth(), this.myParseResult.getOriginalHeight()));
                    } else {
                        NewVectorAssetStep.this.myImagePreview.setIcon(null);
                        NewVectorAssetStep.this.myOriginalSize.clear();
                    }
                    String error = this.myParseResult.getErrors();
                    NewVectorAssetStep.this.myErrorPanel.setVisible(!error.isEmpty());
                    NewVectorAssetStep.this.myErrorsTextArea.setText(error);
                    ApplicationManager.getApplication().invokeLater(() -> NewVectorAssetStep.this.myErrorsScrollPane.getVerticalScrollBar().setValue(0), ModalityState.any());
                    VectorPreviewUpdater.this.myCurrentWorker = null;
                    if (VectorPreviewUpdater.this.myEnqueuedWorker != null) {
                        VectorPreviewUpdater.this.myCurrentWorker = VectorPreviewUpdater.this.myEnqueuedWorker;
                        VectorPreviewUpdater.this.myEnqueuedWorker = null;
                        ApplicationManager.getApplication().invokeLater(() -> VectorPreviewUpdater.this.myCurrentWorker.execute(), ModalityState.any());
                    }
                }
            };
        }
    }
}

