/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.platform.Language;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.JavaToKotlinHandler;
import com.android.tools.idea.npw.template.MultiTemplateRenderer;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderTemplateModel
extends WizardModel {
    private static final String PROPERTIES_RENDER_LANGUAGE_KEY = "SAVED_RENDER_LANGUAGE";
    @NotNull
    private final String myCommandName;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ObjectProperty<AndroidSourceSet> mySourceSet;
    @NotNull
    private final ObjectProperty<Language> myLanguageSet;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final BoolProperty myInstantApp;
    @NotNull
    private final MultiTemplateRenderer myMultiTemplateRenderer;
    private final boolean myIsNewProject;
    @Nullable
    private TemplateHandle myTemplateHandle;
    @NotNull
    private final Map<String, Object> myTemplateValues;
    @Nullable
    private AndroidIconGenerator myIconGenerator;

    public RenderTemplateModel(@NotNull Project project, @Nullable TemplateHandle templateHandle, @NotNull String initialPackageSuggestion, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        if (project == null) {
            RenderTemplateModel.$$$reportNull$$$0(0);
        }
        if (initialPackageSuggestion == null) {
            RenderTemplateModel.$$$reportNull$$$0(1);
        }
        if (sourceSet == null) {
            RenderTemplateModel.$$$reportNull$$$0(2);
        }
        if (commandName == null) {
            RenderTemplateModel.$$$reportNull$$$0(3);
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myTemplateValues = Maps.newHashMap();
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myInstantApp = new BoolValueProperty(false);
        this.myPackageName = new StringValueProperty(initialPackageSuggestion);
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.myMultiTemplateRenderer = new MultiTemplateRenderer();
        this.myLanguageSet = new ObjectValueProperty<Language>(RenderTemplateModel.getInitialSourceLanguage(project));
        this.myIsNewProject = this.myProject.getValueOrNull() == null;
        this.init();
    }

    public RenderTemplateModel(@NotNull NewModuleModel moduleModel, @Nullable TemplateHandle templateHandle, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        if (moduleModel == null) {
            RenderTemplateModel.$$$reportNull$$$0(4);
        }
        if (sourceSet == null) {
            RenderTemplateModel.$$$reportNull$$$0(5);
        }
        if (commandName == null) {
            RenderTemplateModel.$$$reportNull$$$0(6);
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myTemplateValues = Maps.newHashMap();
        this.myProject = moduleModel.getProject();
        this.myInstantApp = moduleModel.instantApp();
        this.myPackageName = moduleModel.packageName();
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
        this.myMultiTemplateRenderer = moduleModel.getMultiTemplateRenderer();
        this.myMultiTemplateRenderer.increment();
        this.myLanguageSet = new ObjectValueProperty<Language>(RenderTemplateModel.getInitialSourceLanguage(this.myProject.getValueOrNull()));
        this.myIsNewProject = this.myProject.getValueOrNull() == null;
        this.init();
    }

    private void init() {
        this.myLanguageSet.addListener(sender -> RenderTemplateModel.setInitialSourceLanguage((Language)((Object)((Object)this.myLanguageSet.get()))));
    }

    private static Logger getLog() {
        return Logger.getInstance(RenderTemplateModel.class);
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map = this.myTemplateValues;
        if (map == null) {
            RenderTemplateModel.$$$reportNull$$$0(7);
        }
        return map;
    }

    @NotNull
    public ObjectProperty<AndroidSourceSet> getSourceSet() {
        ObjectProperty<AndroidSourceSet> objectProperty = this.mySourceSet;
        if (objectProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(8);
        }
        return objectProperty;
    }

    @NotNull
    public ObjectProperty<Language> getLanguage() {
        ObjectProperty<Language> objectProperty = this.myLanguageSet;
        if (objectProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(9);
        }
        return objectProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(10);
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty instantApp() {
        BoolProperty boolProperty = this.myInstantApp;
        if (boolProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(11);
        }
        return boolProperty;
    }

    public void setTemplateHandle(@Nullable TemplateHandle templateHandle) {
        this.myTemplateHandle = templateHandle;
    }

    @Nullable
    public TemplateHandle getTemplateHandle() {
        return this.myTemplateHandle;
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(12);
        }
        return optionalProperty;
    }

    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    public void setIconGenerator(@NotNull AndroidIconGenerator iconGenerator) {
        if (iconGenerator == null) {
            RenderTemplateModel.$$$reportNull$$$0(13);
        }
        this.myIconGenerator = iconGenerator;
    }

    @Override
    protected void handleFinished() {
        this.myMultiTemplateRenderer.requestRender(new FreeMarkerTemplateRenderer());
    }

    @Override
    protected void handleSkipped() {
        this.myMultiTemplateRenderer.skipRender();
    }

    @NotNull
    private static Language getInitialSourceLanguage(@Nullable Project project) {
        if (project != null && JavaToKotlinHandler.hasKotlinFacet(project)) {
            Language language = Language.fromName(PropertiesComponent.getInstance().getValue(PROPERTIES_RENDER_LANGUAGE_KEY), Language.KOTLIN);
            if (language == null) {
                RenderTemplateModel.$$$reportNull$$$0(14);
            }
            return language;
        }
        Language language = Language.JAVA;
        if (language == null) {
            RenderTemplateModel.$$$reportNull$$$0(15);
        }
        return language;
    }

    private static void setInitialSourceLanguage(@NotNull Language language) {
        if (language == null) {
            RenderTemplateModel.$$$reportNull$$$0(16);
        }
        PropertiesComponent.getInstance().setValue(PROPERTIES_RENDER_LANGUAGE_KEY, language.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialPackageSuggestion";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/RenderTemplateModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconGenerator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/RenderTemplateModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceSet";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "instantApp";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSourceLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIconGenerator";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setInitialSourceLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FreeMarkerTemplateRenderer
    implements MultiTemplateRenderer.TemplateRenderer {
        private FreeMarkerTemplateRenderer() {
        }

        @Override
        public boolean doDryRun() {
            if (!((Optional)RenderTemplateModel.this.myProject.get()).isPresent() || RenderTemplateModel.this.myTemplateHandle == null) {
                RenderTemplateModel.getLog().error("RenderTemplateModel did not collect expected information and will not complete. Please report this error.");
                return false;
            }
            AndroidProjectPaths paths = ((AndroidSourceSet)RenderTemplateModel.this.mySourceSet.get()).getPaths();
            Project project = (Project)RenderTemplateModel.this.myProject.getValue();
            return this.renderTemplate(true, project, paths, null, null);
        }

        @Override
        public void render() {
            final AndroidProjectPaths paths = ((AndroidSourceSet)RenderTemplateModel.this.mySourceSet.get()).getPaths();
            final Project project = (Project)RenderTemplateModel.this.myProject.getValue();
            final ArrayList filesToOpen = Lists.newArrayListWithExpectedSize((int)3);
            final ArrayList filesToReformat = Lists.newArrayList();
            boolean success = (Boolean)new WriteCommandAction<Boolean>(project, RenderTemplateModel.this.myCommandName, new PsiFile[0]){

                protected void run(@NotNull Result<Boolean> result) throws Throwable {
                    boolean success;
                    if (result == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((success = FreeMarkerTemplateRenderer.this.renderTemplate(false, project, paths, filesToOpen, filesToReformat)) && RenderTemplateModel.this.myIconGenerator != null) {
                        RenderTemplateModel.this.myIconGenerator.generateImageIconsIntoPath(paths);
                    }
                    result.setResult((Object)success);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/template/RenderTemplateModel$FreeMarkerTemplateRenderer$1", "run"));
                }
            }.execute().getResultObject();
            if (success) {
                if (this.isKotlinTemplate()) {
                    JavaToKotlinHandler.convertJavaFilesToKotlin(project, filesToReformat, RenderTemplateModel.this.myIsNewProject, () -> {
                        for (int i = 0; i < filesToOpen.size(); ++i) {
                            File file = (File)filesToOpen.get(i);
                            if (!file.getName().endsWith(".java")) continue;
                            File ktFile = new File(file.getParent(), file.getName().replace(".java", ".kt"));
                            filesToOpen.set(i, ktFile);
                        }
                        TemplateUtils.openEditors(project, filesToOpen, true);
                    });
                } else {
                    DumbService.getInstance((Project)project).smartInvokeLater(() -> TemplateUtils.openEditors(project, filesToOpen, true));
                }
            }
        }

        private boolean isKotlinTemplate() {
            return StudioFlags.NPW_KOTLIN.get() != false && RenderTemplateModel.this.myTemplateValues.getOrDefault("includeKotlinSupport", false) != false;
        }

        private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull AndroidProjectPaths paths, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
            if (project == null) {
                FreeMarkerTemplateRenderer.$$$reportNull$$$0(0);
            }
            if (paths == null) {
                FreeMarkerTemplateRenderer.$$$reportNull$$$0(1);
            }
            Template template = RenderTemplateModel.this.myTemplateHandle.getTemplate();
            File moduleRoot = paths.getModuleRoot();
            if (moduleRoot == null) {
                return false;
            }
            RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(RenderTemplateModel.this.myCommandName).withDryRun(dryRun).withShowErrors(true).withModuleRoot(paths.getModuleRoot()).withParams(RenderTemplateModel.this.myTemplateValues).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
            return template.render(context, dryRun);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "paths";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/template/RenderTemplateModel$FreeMarkerTemplateRenderer";
            objectArray[2] = "renderTemplate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

