/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.ExportDialog;
import com.android.tools.idea.profilers.IntellijDataViewer;
import com.android.tools.idea.profilers.ResizableImage;
import com.android.tools.idea.profilers.actions.NavigateToCodeAction;
import com.android.tools.idea.profilers.stacktrace.IntelliJStackTraceView;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerComponents
implements IdeProfilerComponents {
    private static final String COMPONENT_CONTEXT_MENU = "ComponentContextMenu";
    private static final Map<String, FileType> FILE_TYPE_MAP = new ImmutableMap.Builder().put((Object)".html", (Object)StdFileTypes.HTML).put((Object)".xml", (Object)StdFileTypes.XML).put((Object)".json", (Object)FileTypeManager.getInstance().getStdFileType("JSON")).build();
    private static final ImmutableSet<String> IMAGE_EXTENSIONS = ImmutableSet.of((Object)".bmp", (Object)".gif", (Object)".jpeg", (Object)".jpg", (Object)".png");
    @NotNull
    private final Project myProject;

    public IntellijProfilerComponents(@NotNull Project project) {
        if (project == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public LoadingPanel createLoadingPanel(final int delayMs) {
        LoadingPanel loadingPanel = new LoadingPanel(){
            private final JBLoadingPanel myLoadingPanel;
            {
                this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)IntellijProfilerComponents.this.myProject, delayMs);
            }

            @NotNull
            public JComponent getComponent() {
                JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
                if (jBLoadingPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jBLoadingPanel;
            }

            public void setChildComponent(@Nullable Component comp) {
                this.myLoadingPanel.getContentPanel().removeAll();
                if (comp != null) {
                    this.myLoadingPanel.add(comp);
                }
            }

            public void setLoadingText(@NotNull String loadingText) {
                if (loadingText == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.myLoadingPanel.setLoadingText(loadingText);
            }

            public void startLoading() {
                this.myLoadingPanel.startLoading();
            }

            public void stopLoading() {
                this.myLoadingPanel.stopLoading();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/profilers/IntellijProfilerComponents$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loadingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/profilers/IntellijProfilerComponents$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setLoadingText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (loadingPanel == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(1);
        }
        return loadingPanel;
    }

    @NotNull
    public StackTraceView createStackView(@NotNull StackTraceModel model) {
        if (model == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(2);
        }
        IntelliJStackTraceView intelliJStackTraceView = new IntelliJStackTraceView(this.myProject, model);
        if (intelliJStackTraceView == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(3);
        }
        return intelliJStackTraceView;
    }

    public void installNavigationContextMenu(@NotNull JComponent component2, @NotNull CodeNavigator navigator, @NotNull Supplier<CodeLocation> codeLocationSupplier) {
        if (component2 == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(4);
        }
        if (navigator == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(5);
        }
        if (codeLocationSupplier == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(6);
        }
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component2);
        popupGroup.add((AnAction)new NavigateToCodeAction(codeLocationSupplier, navigator));
    }

    public void installContextMenu(@NotNull JComponent component2, final @NotNull ContextMenuItem contextMenuItem) {
        if (component2 == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(7);
        }
        if (contextMenuItem == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(8);
        }
        DefaultActionGroup popupGroup = this.createOrGetActionGroup(component2);
        popupGroup.add(new AnAction(null, null, contextMenuItem.getIcon()){

            public void update(AnActionEvent e) {
                super.update(e);
                Presentation presentation = e.getPresentation();
                presentation.setText(contextMenuItem.getText());
                presentation.setEnabled(contextMenuItem.isEnabled());
            }

            public void actionPerformed(AnActionEvent e) {
                contextMenuItem.run();
            }
        });
    }

    public void openExportDialog(@NotNull Supplier<String> dialogTitleSupplier, @NotNull Supplier<String> extensionSupplier, @NotNull Consumer<File> saveToFile) {
        if (dialogTitleSupplier == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(9);
        }
        if (extensionSupplier == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(10);
        }
        if (saveToFile == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ExportDialog dialog;
            String extension;
            if (extensionSupplier == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(21);
            }
            if (dialogTitleSupplier == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(22);
            }
            if (saveToFile == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(23);
            }
            if ((extension = (String)extensionSupplier.get()) != null && (dialog = new ExportDialog(this.myProject, (String)dialogTitleSupplier.get(), extension)).showAndGet()) {
                saveToFile.accept(dialog.getFile());
            }
        });
    }

    @NotNull
    private DefaultActionGroup createOrGetActionGroup(@NotNull JComponent component2) {
        DefaultActionGroup actionGroup;
        if (component2 == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(12);
        }
        if ((actionGroup = (DefaultActionGroup)component2.getClientProperty(COMPONENT_CONTEXT_MENU)) == null) {
            final DefaultActionGroup newActionGroup = new DefaultActionGroup();
            component2.putClientProperty(COMPONENT_CONTEXT_MENU, newActionGroup);
            component2.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)newActionGroup).getComponent().show(comp, x, y);
                }
            });
            actionGroup = newActionGroup;
        }
        DefaultActionGroup defaultActionGroup = actionGroup;
        if (defaultActionGroup == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(13);
        }
        return defaultActionGroup;
    }

    @NotNull
    public DataViewer createFileViewer(@NotNull File file) {
        String fileName;
        int dot;
        String extension;
        if (file == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(14);
        }
        String string = extension = (dot = (fileName = file.getName()).lastIndexOf(46)) >= 0 && dot < fileName.length() ? fileName.substring(dot) : "";
        if (IMAGE_EXTENSIONS.contains((Object)extension)) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image != null) {
                IntellijDataViewer intellijDataViewer = IntellijDataViewer.createImageViewer(image);
                if (intellijDataViewer == null) {
                    IntellijProfilerComponents.$$$reportNull$$$0(15);
                }
                return intellijDataViewer;
            }
            IntellijDataViewer intellijDataViewer = IntellijDataViewer.createInvalidViewer();
            if (intellijDataViewer == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(16);
            }
            return intellijDataViewer;
        }
        String content = null;
        if (file.exists()) {
            try {
                content = new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (content == null) {
            IntellijDataViewer intellijDataViewer = IntellijDataViewer.createInvalidViewer();
            if (intellijDataViewer == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(17);
            }
            return intellijDataViewer;
        }
        IntellijDataViewer intellijDataViewer = IntellijDataViewer.createEditorViewer(content, FILE_TYPE_MAP.getOrDefault(extension, null));
        if (intellijDataViewer == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(18);
        }
        return intellijDataViewer;
    }

    @NotNull
    public JComponent createResizableImageComponent(@NotNull BufferedImage image) {
        if (image == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(19);
        }
        ResizableImage resizableImage = new ResizableImage(image);
        if (resizableImage == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(20);
        }
        return resizableImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/IntellijProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeLocationSupplier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextMenuItem";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitleSupplier";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionSupplier";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saveToFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/IntellijProfilerComponents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoadingPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackView";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetActionGroup";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createResizableImageComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStackView";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installNavigationContextMenu";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "installContextMenu";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openExportDialog";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createOrGetActionGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewer";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createResizableImageComponent";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openExportDialog$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

