/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class AndroidProjectBuildNotifications {
    private static final Topic<AndroidProjectBuildListener> TOPIC = new Topic("Android Project Build", AndroidProjectBuildListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;

    public static void subscribe(@NotNull Project project, @NotNull AndroidProjectBuildListener listener) {
        if (project == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(1);
        }
        AndroidProjectBuildNotifications.subscribe(project, (Disposable)project, listener);
    }

    public static void subscribe(@NotNull Project project, @NotNull Disposable disposable, @NotNull AndroidProjectBuildListener listener) {
        if (project == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(4);
        }
        MessageBusConnection connection = project.getMessageBus().connect(disposable);
        connection.subscribe(TOPIC, (Object)listener);
    }

    @NotNull
    public static AndroidProjectBuildNotifications getInstance(@NotNull Project project) {
        if (project == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(5);
        }
        AndroidProjectBuildNotifications androidProjectBuildNotifications = (AndroidProjectBuildNotifications)ServiceManager.getService((Project)project, AndroidProjectBuildNotifications.class);
        if (androidProjectBuildNotifications == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(6);
        }
        return androidProjectBuildNotifications;
    }

    public AndroidProjectBuildNotifications(@NotNull Project project, @NotNull MessageBus messageBus) {
        if (project == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(7);
        }
        if (messageBus == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(8);
        }
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    public void notifyBuildComplete(@NotNull BuildContext context) {
        if (context == null) {
            AndroidProjectBuildNotifications.$$$reportNull$$$0(9);
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> {
            if (context == null) {
                AndroidProjectBuildNotifications.$$$reportNull$$$0(10);
            }
            ((AndroidProjectBuildListener)this.myMessageBus.syncPublisher(TOPIC)).buildComplete(context);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/project/AndroidProjectBuildNotifications";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/project/AndroidProjectBuildNotifications";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyBuildComplete";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyBuildComplete$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BuildContext {
    }

    public static interface AndroidProjectBuildListener {
        public void buildComplete(@NotNull BuildContext var1);
    }
}

