/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.resources.ResourceFolderType;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.rendering.webp.WebpConversionDialog;
import com.android.tools.idea.rendering.webp.WebpConversionSettings;
import com.android.tools.idea.rendering.webp.WebpConvertedFile;
import com.android.tools.idea.rendering.webp.WebpPreviewDialog;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConvertToWebpAction
extends DumbAwareAction {
    @Nls(capitalization=Nls.Capitalization.Title)
    public static final String TITLE = "Converting Images to WebP";

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            module = (Module)e.getData(LangDataKeys.MODULE_CONTEXT);
        }
        int minSdkVersion = Integer.MAX_VALUE;
        if (module != null) {
            AndroidModuleInfo info = AndroidModuleInfo.getInstance(module);
            if (info != null) {
                minSdkVersion = Math.min(minSdkVersion, info.getMinSdkVersion().getFeatureLevel());
            }
        } else {
            Module[] modules = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (modules != null) {
                for (Module m : modules) {
                    AndroidModuleInfo info = AndroidModuleInfo.getInstance(m);
                    if (info == null) continue;
                    minSdkVersion = Math.min(minSdkVersion, info.getMinSdkVersion().getFeatureLevel());
                }
            }
        }
        VirtualFile[] files = (VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        this.perform(project, minSdkVersion, files);
    }

    public void perform(@NotNull Project project, int minSdkVersion, VirtualFile[] files) {
        if (project == null) {
            ConvertToWebpAction.$$$reportNull$$$0(0);
        }
        WebpConversionSettings settings = new WebpConversionSettings();
        settings.skipTransparentImages = minSdkVersion < 18;
        settings.allowLossless = minSdkVersion >= 18;
        boolean singleFile = files.length == 1 && ConvertToWebpAction.isEligibleForConversion(files[0], null);
        WebpConversionDialog dialog = new WebpConversionDialog(project, minSdkVersion, settings, singleFile);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.toSettings(settings);
        this.convert(project, settings, true, Arrays.asList(files));
    }

    private static boolean isResourceDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            ConvertToWebpAction.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConvertToWebpAction.$$$reportNull$$$0(2);
        }
        if (file.isDirectory()) {
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)file.getName());
            if (folderType != null) {
                return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
            }
            return AndroidResourceUtil.isLocalResourceDirectory(file, project);
        }
        return false;
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null && e.getProject() != null) {
            for (VirtualFile file : files) {
                boolean directory = file.isDirectory();
                if ((!directory || !ConvertToWebpAction.isResourceDirectory(file, e.getProject())) && (directory || !ConvertToWebpAction.isEligibleForConversion(file, null))) continue;
                e.getPresentation().setEnabledAndVisible(true);
                return;
            }
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    public void convert(@NotNull Project project, @NotNull WebpConversionSettings settings, boolean showBalloon, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            ConvertToWebpAction.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            ConvertToWebpAction.$$$reportNull$$$0(4);
        }
        if (files == null) {
            ConvertToWebpAction.$$$reportNull$$$0(5);
        }
        boolean isUnitTest = ApplicationManager.getApplication().isUnitTestMode();
        WebpConversionTask task = new WebpConversionTask(project, settings, showBalloon && !isUnitTest, files);
        if (isUnitTest) {
            task.run((ProgressIndicator)new DumbProgressIndicator());
            settings.previewConversion = false;
            task.onFinished();
        } else {
            ProgressManager.getInstance().run((Task)task);
        }
    }

    public static boolean isEligibleForConversion(@Nullable VirtualFile file, @Nullable WebpConversionSettings settings) {
        if (file != null && !file.isDirectory()) {
            String name = file.getName();
            if (name.endsWith(".png")) {
                if (settings != null && settings.skipNinePatches && SdkUtils.endsWithIgnoreCase((String)name, (String)".9.png")) {
                    return false;
                }
                if (settings != null && settings.skipTransparentImages) {
                    try {
                        BufferedImage image = ImageIO.read(file.getInputStream());
                        if (image != null && ImageUtils.isNonOpaque((BufferedImage)image)) {
                            return false;
                        }
                    }
                    catch (IOException image) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name, (String)".jpg") || SdkUtils.endsWith((CharSequence)name, (CharSequence)".jpeg")) {
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name, (String)".bmp")) {
                return true;
            }
            if (SdkUtils.endsWithIgnoreCase((String)name, (String)".gif")) {
                ImageReader is = ImageIO.getImageReadersBySuffix("GIF").next();
                try {
                    ImageInputStream iis = ImageIO.createImageInputStream(file.getInputStream());
                    is.setInput(iis);
                    return is.getNumImages(true) == 1;
                }
                catch (IOException ignore) {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isNinePatchFile(@NotNull VirtualFile file) {
        if (file == null) {
            ConvertToWebpAction.$$$reportNull$$$0(6);
        }
        return file.getName().endsWith(".9.png") && !file.isDirectory();
    }

    static String formatSize(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " bytes";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = Character.toString("KMGTPE".charAt(exp - 1));
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    private static void refreshFolders(List<VirtualFile> toRefresh) {
        for (VirtualFile dir : toRefresh) {
            dir.refresh(true, true);
        }
    }

    @NotNull
    private static List<VirtualFile> computeParentFolders(@NotNull List<WebpConvertedFile> files) {
        if (files == null) {
            ConvertToWebpAction.$$$reportNull$$$0(7);
        }
        ArrayList toRefresh = Lists.newArrayList();
        for (WebpConvertedFile file : files) {
            VirtualFile parent = file.sourceFile.getParent();
            if (parent == null || toRefresh.contains(parent)) continue;
            toRefresh.add(parent);
        }
        ArrayList arrayList = toRefresh;
        if (arrayList == null) {
            ConvertToWebpAction.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/webp/ConvertToWebpAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/webp/ConvertToWebpAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeParentFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDirectory";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNinePatchFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeParentFolders";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class WebpConversionTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final boolean myShowBalloon;
        private final Collection<VirtualFile> myFiles;
        private final WebpConversionSettings mySettings;
        private int myNinePatchCount;
        private int myLauncherIconCount;
        private int myTransparentCount;
        private int myFileCount;
        private long mySaved;
        private int mySkipped;
        private List<VirtualFile> myParentFolders;
        private List<WebpConvertedFile> myConvertedFiles;

        public WebpConversionTask(Project project, WebpConversionSettings settings, boolean showBalloon, Collection<VirtualFile> files) {
            super(project, ConvertToWebpAction.TITLE, true);
            this.mySettings = settings;
            this.myProject = project;
            this.myShowBalloon = showBalloon;
            this.myFiles = files;
        }

        public void onFinished() {
            if (this.mySettings.previewConversion && !this.mySettings.lossless && !this.myConvertedFiles.isEmpty()) {
                WebpPreviewDialog dialog = new WebpPreviewDialog(this, this.myProject, this.mySettings, this.myConvertedFiles);
                if (!dialog.showAndGet()) {
                    return;
                }
                this.encode(this.myConvertedFiles, true);
            } else {
                this.encode(this.myConvertedFiles, false);
            }
            this.writeImages((Object)this, this.myProject, this.myConvertedFiles);
            if (this.myShowBalloon) {
                StringBuilder sb = new StringBuilder();
                if (this.myFiles.size() > 1 || this.myFileCount == 0) {
                    sb.append(Integer.toString(this.myFileCount)).append(" files were converted");
                }
                if (this.mySaved > 0L || this.myTransparentCount == 0 && this.myNinePatchCount == 0 && this.mySkipped == 0) {
                    sb.append("<br/>").append(ConvertToWebpAction.formatSize(this.mySaved)).append(" saved");
                }
                if (this.myNinePatchCount > 0) {
                    sb.append("<br>").append(Integer.toString(this.myNinePatchCount)).append(" 9-patch files were skipped");
                }
                if (this.myLauncherIconCount > 0) {
                    sb.append("<br>").append(Integer.toString(this.myLauncherIconCount)).append(" launcher icons were skipped");
                }
                if (this.myTransparentCount > 0) {
                    sb.append("<br>").append(Integer.toString(this.myTransparentCount)).append(" transparent images were skipped");
                }
                if (this.mySkipped > 0) {
                    sb.append("<br>").append(Integer.toString(this.mySkipped)).append(" files were skipped because there was no net space savings");
                }
                String message = sb.toString();
                new NotificationGroup("Convert to WebP", NotificationDisplayType.BALLOON, true).createNotification(message, NotificationType.INFORMATION).notify(this.myProject);
            }
            ConvertToWebpAction.refreshFolders(this.myParentFolders);
        }

        private void writeImages(Object requestor, Project project, List<WebpConvertedFile> files) {
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (WebpConvertedFile convertedFile : files) {
                    try {
                        if (convertedFile.encoded == null) {
                            ++this.myTransparentCount;
                            continue;
                        }
                        if (this.mySettings.skipLargerImages && convertedFile.saved < 0L) {
                            ++this.mySkipped;
                            continue;
                        }
                        this.mySaved += convertedFile.saved;
                        ++this.myFileCount;
                        convertedFile.apply(requestor);
                    }
                    catch (IOException e) {
                        Logger.getInstance(ConvertToWebpAction.class).warn((Throwable)e);
                    }
                }
            });
        }

        public void run(@NotNull ProgressIndicator progressIndicator) {
            if (progressIndicator == null) {
                WebpConversionTask.$$$reportNull$$$0(0);
            }
            LinkedList<VirtualFile> images = new LinkedList<VirtualFile>(this.myFiles);
            this.myConvertedFiles = this.findImages(progressIndicator, images);
            this.myParentFolders = ConvertToWebpAction.computeParentFolders(this.myConvertedFiles);
        }

        void encode(@NotNull List<WebpConvertedFile> files, boolean skipAlreadyEncoded) {
            if (files == null) {
                WebpConversionTask.$$$reportNull$$$0(1);
            }
            for (WebpConvertedFile file : files) {
                if (skipAlreadyEncoded && file.encoded != null) continue;
                if (this.mySettings.skipNinePatches && ConvertToWebpAction.isNinePatchFile(file.sourceFile)) {
                    assert (false) : file;
                    continue;
                }
                if (!file.convert(this.mySettings)) {
                    assert (false) : file;
                    continue;
                }
                if (this.mySettings.skipLargerImages && file.saved < 0L) {
                    ++this.mySkipped;
                    continue;
                }
                this.mySaved += file.saved;
                ++this.myFileCount;
            }
        }

        private Set<String> getLauncherIconNames(LinkedList<VirtualFile> roots) {
            HashSet modules = Sets.newHashSet();
            for (VirtualFile virtualFile : roots) {
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)this.myProject);
                if (module == null) continue;
                modules.add(module);
            }
            if (modules.isEmpty()) {
                modules.addAll(Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()));
            }
            HashSet facets = Sets.newHashSet();
            for (Module module : modules) {
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) continue;
                facets.add(facet);
            }
            HashSet hashSet = Sets.newHashSet();
            for (AndroidFacet facet : facets) {
                Element element;
                Document document = MergedManifest.get(facet).getDocument();
                if (document == null || document.getDocumentElement() == null || (element = XmlUtils.getFirstSubTagByName((Node)document.getDocumentElement(), (String)"application")) == null) continue;
                WebpConversionTask.addIcons(hashSet, element);
                for (Element child : XmlUtils.getSubTags((Node)element)) {
                    String tagName = child.getTagName();
                    if (!tagName.equals("activity") && !tagName.equals("activity-alias") && !tagName.equals("service") && !tagName.equals("provider") && !tagName.equals("receiver")) continue;
                    WebpConversionTask.addIcons(hashSet, element);
                }
            }
            hashSet.add("ic_launcher_round");
            hashSet.add("ic_launcher");
            return hashSet;
        }

        private static void addIcons(Set<String> names, Element element) {
            String icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "icon");
            if (icon != null) {
                if (icon.startsWith("@drawable/")) {
                    names.add(icon.substring("@drawable/".length()));
                } else if (icon.startsWith("@mipmap/")) {
                    names.add(icon.substring("@mipmap/".length()));
                }
            }
            if ((icon = element.getAttributeNS("http://schemas.android.com/apk/res/android", "roundIcon")) != null) {
                if (icon.startsWith("@drawable/")) {
                    names.add(icon.substring("@drawable/".length()));
                } else if (icon.startsWith("@mipmap/")) {
                    names.add(icon.substring("@mipmap/".length()));
                }
            }
        }

        @NotNull
        private List<WebpConvertedFile> findImages(@NotNull ProgressIndicator progressIndicator, @NotNull LinkedList<VirtualFile> images) {
            if (progressIndicator == null) {
                WebpConversionTask.$$$reportNull$$$0(2);
            }
            if (images == null) {
                WebpConversionTask.$$$reportNull$$$0(3);
            }
            ArrayList files = Lists.newArrayList();
            Set<String> launcherIconNames = this.getLauncherIconNames(images);
            while (!images.isEmpty()) {
                progressIndicator.checkCanceled();
                VirtualFile file = images.pop();
                progressIndicator.setText(file.getPath());
                if (file.isDirectory()) {
                    for (VirtualFile f : file.getChildren()) {
                        images.push(f);
                    }
                    continue;
                }
                if (!ConvertToWebpAction.isEligibleForConversion(file, null)) continue;
                if (launcherIconNames.contains(LintUtils.getBaseName((String)file.getName())) && file.getParent() != null && (file.getParent().getName().startsWith("drawable") || file.getParent().getName().startsWith("mipmap"))) {
                    ++this.myLauncherIconCount;
                    continue;
                }
                if (ConvertToWebpAction.isEligibleForConversion(file, this.mySettings)) {
                    WebpConvertedFile convertedFile = WebpConvertedFile.create(file, this.mySettings);
                    if (convertedFile == null) continue;
                    files.add(convertedFile);
                    continue;
                }
                if (this.mySettings.skipNinePatches && ConvertToWebpAction.isNinePatchFile(file)) {
                    ++this.myNinePatchCount;
                    continue;
                }
                ++this.myTransparentCount;
            }
            ArrayList arrayList = files;
            if (arrayList == null) {
                WebpConversionTask.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "images";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/rendering/webp/ConvertToWebpAction$WebpConversionTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/rendering/webp/ConvertToWebpAction$WebpConversionTask";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findImages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "encode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findImages";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

