/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.tools.idea.res.ResourceClassGenerator;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RDotTxtParser {
    private static final String INT_ID = "int id ";
    private static final int INT_ID_LEN = "int id ".length();
    private static Logger ourLog;
    private static final Splitter COMMA_SPLITTER;

    RDotTxtParser() {
    }

    @NotNull
    static Collection<String> getIdNames(final File rFile) {
        Collection collection;
        try {
            collection = (Collection)Files.readLines((File)rFile, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Collection<String>>(){
                Collection<String> idNames = new ArrayList<String>(32);

                public boolean processLine(@NotNull String line) throws IOException {
                    if (line == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!line.startsWith(RDotTxtParser.INT_ID)) {
                        return true;
                    }
                    int i = line.indexOf(32, INT_ID_LEN);
                    assert (i != -1) : "File not in expected format: " + rFile.getPath() + "\nExpected the ids to be in the format int id <name> <number>";
                    this.idNames.add(line.substring(INT_ID_LEN, i));
                    return true;
                }

                public Collection<String> getResult() {
                    return this.idNames;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/res/RDotTxtParser$1", "processLine"));
                }
            });
        }
        catch (IOException e) {
            RDotTxtParser.getLog().warn("Unable to read file: " + rFile.getPath(), (Throwable)e);
            List<String> list = Collections.emptyList();
            if (list == null) {
                RDotTxtParser.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (collection == null) {
            RDotTxtParser.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    static Integer[] getDeclareStyleableArray(File r, final List<AttrResourceValue> attrs, final String styleableName) {
        try {
            return (Integer[])Files.readLines((File)r, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Integer[]>(){
                private static final String ARRAY_STYLEABLE = "int[] styleable ";
                private static final String INT_STYLEABLE = "int styleable ";
                private final String myArrayStart;
                private final String myEntryStart;
                private Integer[] myValuesList;
                private String[] myDeclaredAttrs;
                private int myAttrsFound;
                {
                    this.myArrayStart = ARRAY_STYLEABLE + styleableName + " { ";
                    this.myEntryStart = INT_STYLEABLE + styleableName + "_";
                }

                public boolean processLine(@NotNull String line) throws IOException {
                    if (line == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (line.startsWith(this.myArrayStart)) {
                        String valuesList = line.substring(this.myArrayStart.length(), line.length() - 1);
                        int valuesCount = StringUtil.countChars((CharSequence)valuesList, (char)',') + 1;
                        if (valuesCount != attrs.size()) {
                            return false;
                        }
                        this.myValuesList = new Integer[valuesCount];
                        this.myDeclaredAttrs = new String[valuesCount];
                        int idx = 0;
                        for (String s : COMMA_SPLITTER.split((CharSequence)valuesList)) {
                            this.myValuesList[idx++] = Integer.decode(s);
                        }
                        return true;
                    }
                    if (this.myValuesList != null && line.startsWith(this.myEntryStart)) {
                        int lastSpace = line.lastIndexOf(32);
                        String name = line.substring(INT_STYLEABLE.length(), lastSpace);
                        int index = Integer.parseInt(line.substring(lastSpace + 1));
                        this.myDeclaredAttrs[index] = name;
                        ++this.myAttrsFound;
                        return this.myAttrsFound != this.myDeclaredAttrs.length;
                    }
                    return true;
                }

                public Integer[] getResult() {
                    if (this.myValuesList == null || this.myDeclaredAttrs == null) {
                        return null;
                    }
                    int index = 0;
                    for (AttrResourceValue attr : attrs) {
                        String name = ResourceClassGenerator.getResourceName(styleableName, attr);
                        for (int i = index; i < this.myDeclaredAttrs.length; ++i) {
                            String declaredAttr = this.myDeclaredAttrs[i];
                            if (!declaredAttr.equals(name)) continue;
                            ArrayUtil.swap((Object[])this.myDeclaredAttrs, (int)i, (int)index);
                            ArrayUtil.swap((Object[])this.myValuesList, (int)i, (int)index);
                            break;
                        }
                        ++index;
                    }
                    return this.myValuesList;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/res/RDotTxtParser$2", "processLine"));
                }
            });
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Logger getLog() {
        if (ourLog == null) {
            ourLog = Logger.getInstance(RDotTxtParser.class);
        }
        return ourLog;
    }

    static {
        COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/RDotTxtParser", "getIdNames"));
    }
}

