/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ResourceTable;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.sampledata.datasource.CombinerDataSource;
import com.android.tools.idea.sampledata.datasource.DateTimeGenerator;
import com.android.tools.idea.sampledata.datasource.LoremIpsumGenerator;
import com.android.tools.idea.sampledata.datasource.NumberGenerator;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class SampleDataResourceRepository
extends LocalResourceRepository {
    private static final ImmutableList<SampleDataResourceItem> PREDEFINED_SOURCES = ImmutableList.of((Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:full_names", new CombinerDataSource(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/names.txt"), SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/surnames.txt")))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:first_names", ResourceContent.fromInputStream(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/names.txt")))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:last_names", ResourceContent.fromInputStream(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/surnames.txt")))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:cities", ResourceContent.fromInputStream(SampleDataResourceRepository.class.getClassLoader().getResourceAsStream("sampleData/cities.txt")))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:us_zipcodes", new NumberGenerator("%05d", 20000, 99999))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:us_phones", new NumberGenerator("(800) 555-%04d", 0, 9999))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:lorem", new LoremIpsumGenerator(false))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:lorem/random", new LoremIpsumGenerator(true))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:avatars", ResourceContent.fromDirectory("avatars"))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:backgrounds/scenic", ResourceContent.fromDirectory("backgrounds/scenic"))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:date/day_of_week", new DateTimeGenerator(DateTimeFormatter.ofPattern("E"), ChronoUnit.DAYS))), (Object)((Object)SampleDataResourceItem.getFromStaticDataSource("tools:date/ddmmyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("dd-MM-yy"), ChronoUnit.DAYS))), (Object[])new SampleDataResourceItem[]{SampleDataResourceItem.getFromStaticDataSource("tools:date/mmddyy", new DateTimeGenerator(DateTimeFormatter.ofPattern("MM-dd-yy"), ChronoUnit.DAYS)), SampleDataResourceItem.getFromStaticDataSource("tools:date/hhmm", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm"), ChronoUnit.MINUTES)), SampleDataResourceItem.getFromStaticDataSource("tools:date/hhmmss", new DateTimeGenerator(DateTimeFormatter.ofPattern("hh:mm:ss"), ChronoUnit.SECONDS))});
    private final ResourceTable myFullTable;
    private AndroidFacet myAndroidFacet;

    @Contract(value="!null, true -> !null")
    public static VirtualFile getSampleDataDir(@NotNull AndroidFacet androidFacet, boolean create) throws IOException {
        VirtualFile contentRoot;
        if (androidFacet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(0);
        }
        if ((contentRoot = AndroidRootUtil.getMainContentRoot(androidFacet)) == null) {
            throw new IOException("Unable to find content root");
        }
        VirtualFile sampleDataDir = contentRoot.findFileByRelativePath("/sampledata");
        if (sampleDataDir == null && create) {
            sampleDataDir = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)androidFacet.getModule().getProject(), () -> {
                if (androidFacet == null) {
                    SampleDataResourceRepository.$$$reportNull$$$0(12);
                }
                return contentRoot.createChildDirectory((Object)androidFacet, "sampledata");
            });
        }
        return sampleDataDir;
    }

    protected SampleDataResourceRepository(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(1);
        }
        super("SampleData");
        Disposer.register((Disposable)androidFacet, (Disposable)this);
        this.myFullTable = new ResourceTable();
        this.myAndroidFacet = androidFacet;
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SampleDataResourceRepository.this.rootsUpdated(event);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                SampleDataResourceRepository.this.rootsUpdated(event);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                SampleDataResourceRepository.this.rootsUpdated((VirtualFileEvent)event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileMoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        PsiManager.getInstance((Project)androidFacet.getModule().getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                SampleDataResourceRepository.this.contentsUpdated(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                SampleDataResourceRepository.this.contentsUpdated(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                SampleDataResourceRepository.this.contentsUpdated(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                SampleDataResourceRepository.this.contentsUpdated(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(4);
                }
                SampleDataResourceRepository.this.contentsUpdated(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        this.invalidate();
    }

    private static void addItems(@NotNull ImmutableListMultimap.Builder<String, ResourceItem> items, @NotNull PsiFileSystemItem sampleDataFile) {
        if (items == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(2);
        }
        if (sampleDataFile == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(3);
        }
        try {
            SampleDataResourceItem.getFromPsiFileSystemItem(sampleDataFile).forEach(item -> {
                if (items == null) {
                    SampleDataResourceRepository.$$$reportNull$$$0(11);
                }
                items.put((Object)item.getName(), (Object)item);
            });
        }
        catch (IOException e) {
            LOG.warn("Error loading sample data file " + sampleDataFile.getName(), (Throwable)e);
        }
    }

    private static void addPredefinedItems(@NotNull ImmutableListMultimap.Builder<String, ResourceItem> items) {
        if (items == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(4);
        }
        PREDEFINED_SOURCES.forEach(source -> {
            if (items == null) {
                SampleDataResourceRepository.$$$reportNull$$$0(10);
            }
            items.put((Object)source.getName(), (Object)source);
        });
    }

    private void invalidate() {
        VirtualFile sampleDataDir = null;
        try {
            sampleDataDir = SampleDataResourceRepository.getSampleDataDir(this.myAndroidFacet, false);
        }
        catch (IOException e) {
            LOG.warn("Error getting 'sampledir'", (Throwable)e);
        }
        this.myFullTable.clear();
        ImmutableListMultimap.Builder projectItems = ImmutableListMultimap.builder();
        if (sampleDataDir != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myAndroidFacet.getModule().getProject());
            Stream<VirtualFile> childrenStream = Arrays.stream(sampleDataDir.getChildren());
            ApplicationManager.getApplication().runReadAction(() -> childrenStream.map(vf -> vf.isDirectory() ? psiManager.findDirectory(vf) : psiManager.findFile(vf)).filter(Objects::nonNull).forEach(f -> SampleDataResourceRepository.addItems((ImmutableListMultimap.Builder<String, ResourceItem>)projectItems, f)));
        }
        SampleDataResourceRepository.addPredefinedItems((ImmutableListMultimap.Builder<String, ResourceItem>)projectItems);
        this.myFullTable.put(null, (Object)ResourceType.SAMPLE_DATA, (Object)projectItems.build());
        this.setModificationCount(ourModificationCounter.incrementAndGet());
        this.invalidateParentCaches(null, ResourceType.SAMPLE_DATA);
    }

    private static boolean isSampleDataFile(@NotNull AndroidFacet facet, @NotNull VirtualFile file) {
        if (facet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(5);
        }
        if (file == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(6);
        }
        VirtualFile sampleDataDir = null;
        try {
            sampleDataDir = SampleDataResourceRepository.getSampleDataDir(facet, false);
        }
        catch (IOException e) {
            LOG.warn("Error getting 'sampledir'", (Throwable)e);
        }
        boolean relevant = sampleDataDir != null && VfsUtilCore.isAncestor((VirtualFile)sampleDataDir, (VirtualFile)file, (boolean)false);
        return relevant || "sampledata".equals(file.getName());
    }

    private void rootsUpdated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(7);
        }
        if (this.myAndroidFacet.isDisposed()) {
            return;
        }
        if (SampleDataResourceRepository.isSampleDataFile(this.myAndroidFacet, event.getFile())) {
            LOG.debug("sampledata roots updated " + event.getFile());
            this.invalidate();
        }
    }

    private void contentsUpdated(@NotNull PsiTreeChangeEvent event) {
        VirtualFile eventFile;
        if (event == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(8);
        }
        if (this.myAndroidFacet.isDisposed()) {
            return;
        }
        PsiFile psiFile = event.getFile();
        VirtualFile virtualFile = eventFile = psiFile != null ? psiFile.getVirtualFile() : null;
        if (eventFile != null && SampleDataResourceRepository.isSampleDataFile(this.myAndroidFacet, eventFile)) {
            LOG.debug("sampledata file updated " + eventFile);
            this.invalidate();
        }
    }

    protected ResourceTable getFullTable() {
        return this.myFullTable;
    }

    protected ListMultimap<String, ResourceItem> getMap(String namespace, ResourceType type, boolean create) {
        return (ListMultimap)this.myFullTable.get((Object)namespace, (Object)type);
    }

    public Set<String> getNamespaces() {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        ImmutableSet immutableSet = ImmutableSet.of();
        if (immutableSet == null) {
            SampleDataResourceRepository.$$$reportNull$$$0(9);
        }
        return immutableSet;
    }

    @Override
    public void dispose() {
        this.myAndroidFacet = null;
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleDataFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/SampleDataResourceRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/SampleDataResourceRepository";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResourceDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSampleDataDir";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedItems";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSampleDataFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rootsUpdated";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contentsUpdated";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addPredefinedItems$2";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addItems$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSampleDataDir$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

