/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidActivityAliasCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Set<String> aliases;
        if (parameters == null) {
            AndroidActivityAliasCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            AndroidActivityAliasCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        Editor editor = parameters.getEditor();
        LaunchOptionConfigurableContext context = (LaunchOptionConfigurableContext)editor.getUserData(LaunchOptionConfigurableContext.KEY);
        if (context == null) {
            return;
        }
        Module module = context.getModule();
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        String prefix = parameters.getEditor().getDocument().getText().substring(0, parameters.getOffset());
        result = result.withPrefixMatcher(prefix);
        PsiClass activityClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("android.app.Activity", module.getModuleWithDependenciesAndLibrariesScope(false));
        if (activityClass != null) {
            final CompletionResultSet finalResult = result;
            ClassInheritorsSearch.search((PsiClass)activityClass, (SearchScope)module.getModuleWithDependenciesScope(), (boolean)true, (boolean)true, (boolean)false).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    String qName;
                    PsiModifierList modifierList = psiClass.getModifierList();
                    if (modifierList != null && modifierList.hasModifierProperty("public") && !modifierList.hasModifierProperty("abstract") && (qName = psiClass.getQualifiedName()) != null && !qName.isEmpty()) {
                        finalResult.addElement((LookupElement)JavaLookupElementBuilder.forClass((PsiClass)psiClass, (String)qName));
                    }
                    return true;
                }
            });
        }
        if (!(aliases = AndroidActivityAliasCompletionContributor.collectActivityAliases(facet)).isEmpty()) {
            for (String alias : aliases) {
                LookupElementBuilder element = LookupElementBuilder.create((String)alias);
                String shortName = StringUtilRt.getShortName((String)alias);
                if (!shortName.equals(alias)) {
                    element = element.withLookupString(shortName);
                }
                result.addElement((LookupElement)element);
            }
        }
        result.stopHere();
    }

    @NotNull
    private static Set<String> collectActivityAliases(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidActivityAliasCompletionContributor.$$$reportNull$$$0(2);
        }
        HashSet result = new HashSet();
        AndroidActivityAliasCompletionContributor.doCollectActivityAliases(facet, (Set<String>)result);
        for (AndroidFacet depFacet : AndroidUtils.getAllAndroidDependencies(facet.getModule(), true)) {
            AndroidActivityAliasCompletionContributor.doCollectActivityAliases(depFacet, (Set<String>)result);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            AndroidActivityAliasCompletionContributor.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void doCollectActivityAliases(@NotNull AndroidFacet facet, @NotNull Set<String> result) {
        Manifest manifest;
        if (facet == null) {
            AndroidActivityAliasCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result == null) {
            AndroidActivityAliasCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((manifest = facet.getManifest()) == null) {
            return;
        }
        String aPackage = manifest.getPackage().getStringValue();
        Application application = manifest.getApplication();
        if (application == null) {
            return;
        }
        for (ActivityAlias activityAlias : application.getActivityAliases()) {
            String alias = activityAlias.getName().getStringValue();
            if (alias == null || alias.isEmpty()) continue;
            if (!alias.startsWith(".")) {
                if (alias.indexOf(46) > 0) {
                    result.add(alias);
                }
                alias = "." + alias;
            }
            if (aPackage == null || aPackage.isEmpty() || StringUtil.commonPrefixLength((CharSequence)aPackage, (CharSequence)alias) != 0) continue;
            result.add(aPackage + alias);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidActivityAliasCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidActivityAliasCompletionContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectActivityAliases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectActivityAliases";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCollectActivityAliases";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

