/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApplicationLogListener;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProcessHandler
extends ProcessHandler
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IClientChangeListener {
    private static final Logger LOG = Logger.getInstance(AndroidProcessHandler.class);
    private static final long TIMEOUT_MS = 10000L;
    @NotNull
    private final String myApplicationId;
    private final boolean myMonitoringRemoteProcess;
    @NotNull
    private final List<String> myDevices;
    @NotNull
    private final Set<Client> myClients;
    @NotNull
    private final LogcatOutputCapture myLogcatOutputCapture;
    private long myDeviceAdded;
    private boolean myNoKill;

    public AndroidProcessHandler(@NotNull String applicationId) {
        if (applicationId == null) {
            AndroidProcessHandler.$$$reportNull$$$0(0);
        }
        this(applicationId, true);
    }

    public AndroidProcessHandler(@NotNull String applicationId, boolean monitorRemoteProcess) {
        if (applicationId == null) {
            AndroidProcessHandler.$$$reportNull$$$0(1);
        }
        this.myApplicationId = applicationId;
        this.myDevices = new SmartList();
        this.myClients = Sets.newHashSet();
        this.myLogcatOutputCapture = new LogcatOutputCapture(applicationId);
        this.myMonitoringRemoteProcess = monitorRemoteProcess;
        if (this.myMonitoringRemoteProcess) {
            AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void addTargetDevice(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(2);
        }
        this.myDevices.add(device.getSerialNumber());
        this.setMinDeviceApiLevel(device.getVersion());
        Client client = device.getClient(this.myApplicationId);
        if (client != null) {
            this.addClient(client);
        } else {
            this.notifyTextAvailable("Client not ready yet..", ProcessOutputTypes.STDOUT);
        }
        LOG.info("Adding device " + device.getName() + " to monitor for launched app: " + this.myApplicationId);
        this.myDeviceAdded = System.currentTimeMillis();
    }

    private void addClient(@NotNull Client client) {
        if (client == null) {
            AndroidProcessHandler.$$$reportNull$$$0(3);
        }
        if (!this.myClients.add(client)) {
            return;
        }
        IDevice device = client.getDevice();
        this.notifyTextAvailable("Connected to process " + client.getClientData().getPid() + " on device " + device.getName() + "\n", ProcessOutputTypes.STDOUT);
        this.myLogcatOutputCapture.startCapture(device, client, (arg_0, arg_1) -> ((AndroidProcessHandler)this).notifyTextAvailable(arg_0, arg_1));
    }

    private void setMinDeviceApiLevel(@NotNull AndroidVersion deviceVersion) {
        AndroidVersion apiLevel;
        if (deviceVersion == null) {
            AndroidProcessHandler.$$$reportNull$$$0(4);
        }
        if ((apiLevel = (AndroidVersion)this.getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL)) == null || apiLevel.compareTo(deviceVersion) > 0) {
            this.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, deviceVersion);
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    protected void detachProcessImpl() {
        this.notifyProcessDetached();
        this.cleanup();
    }

    protected void destroyProcessImpl() {
        this.notifyProcessTerminated(0);
        this.killProcesses();
        this.cleanup();
    }

    private void killProcesses() {
        if (this.myNoKill) {
            return;
        }
        AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
        if (bridge == null) {
            return;
        }
        for (IDevice device : bridge.getDevices()) {
            if (!this.myDevices.contains(device.getSerialNumber())) continue;
            try {
                device.executeShellCommand("am force-stop " + this.myApplicationId, (IShellOutputReceiver)new NullOutputReceiver());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Client client = device.getClient(this.myApplicationId);
            if (client == null) continue;
            client.kill();
        }
    }

    public void setNoKill() {
        this.myNoKill = true;
    }

    private void cleanup() {
        this.myDevices.clear();
        this.myClients.clear();
        this.myLogcatOutputCapture.stopAll();
        if (this.myMonitoringRemoteProcess) {
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(5);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(6);
        }
        if (!this.myDevices.contains(device.getSerialNumber())) {
            return;
        }
        this.print("Device " + device.getName() + "disconnected, monitoring stopped.");
        this.stopMonitoring(device);
    }

    private void stopMonitoring(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(7);
        }
        this.myLogcatOutputCapture.stopCapture(device);
        this.myDevices.remove(device.getSerialNumber());
        if (this.myDevices.isEmpty()) {
            this.detachProcess();
        }
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(8);
        }
        if ((changeMask & 2) != 2) {
            return;
        }
        if (!this.myDevices.contains(device.getSerialNumber())) {
            return;
        }
        Client client = device.getClient(this.myApplicationId);
        if (client != null) {
            this.addClient(client);
            return;
        }
        if (!this.myClients.isEmpty()) {
            for (Client c : this.myClients) {
                if (!device.equals(c.getDevice())) continue;
                this.stopMonitoring(device);
                this.print("Application terminated.");
                return;
            }
        }
        if (System.currentTimeMillis() - this.myDeviceAdded > 10000L) {
            this.print("Timed out waiting for process to appear on " + device.getName());
            this.stopMonitoring(device);
        } else {
            this.print("Waiting for process to come online");
        }
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        String name;
        if (client == null) {
            AndroidProcessHandler.$$$reportNull$$$0(9);
        }
        if ((changeMask & 1) != 1) {
            return;
        }
        if (!this.myDevices.contains(client.getDevice().getSerialNumber())) {
            return;
        }
        if (StringUtil.equals((CharSequence)this.myApplicationId, (CharSequence)client.getClientData().getClientDescription())) {
            this.addClient(client);
        }
        if ((name = client.getClientData().getClientDescription()) != null && this.myApplicationId.equals(name) && !client.isValid()) {
            this.print("Process " + client.getClientData().getPid() + " is not valid anymore!");
            this.stopMonitoring(client.getDevice());
        }
    }

    @NotNull
    public List<IDevice> getDevices() {
        HashSet devices = Sets.newHashSet();
        for (Client client : this.myClients) {
            devices.add(client.getDevice());
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)devices);
        if (arrayList == null) {
            AndroidProcessHandler.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public Client getClient(@NotNull IDevice device) {
        if (device == null) {
            AndroidProcessHandler.$$$reportNull$$$0(11);
        }
        String serial = device.getSerialNumber();
        for (Client client : this.myClients) {
            if (!StringUtil.equals((CharSequence)client.getDevice().getSerialNumber(), (CharSequence)serial)) continue;
            return client;
        }
        return null;
    }

    @NotNull
    public Set<Client> getClients() {
        Set<Client> set = this.myClients;
        if (set == null) {
            AndroidProcessHandler.$$$reportNull$$$0(12);
        }
        return set;
    }

    private void print(@NotNull String s) {
        if (s == null) {
            AndroidProcessHandler.$$$reportNull$$$0(13);
        }
        this.notifyTextAvailable(s + "\n", ProcessOutputTypes.STDOUT);
    }

    public void reset() {
        this.myDevices.clear();
        this.myClients.clear();
        this.myLogcatOutputCapture.stopAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceVersion";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidProcessHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClients";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTargetDevice";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addClient";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMinDeviceApiLevel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stopMonitoring";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "clientChanged";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClient";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class LogcatOutputCapture {
        @NotNull
        private final String myApplicationId;
        @GuardedBy(value="myLock")
        @NotNull
        private final Map<IDevice, AndroidLogcatService.LogcatListener> myLogListeners;
        @NotNull
        private final Object myLock;

        public LogcatOutputCapture(@NotNull String applicationId) {
            if (applicationId == null) {
                LogcatOutputCapture.$$$reportNull$$$0(0);
            }
            this.myLogListeners = new HashMap<IDevice, AndroidLogcatService.LogcatListener>();
            this.myLock = new Object();
            this.myApplicationId = applicationId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startCapture(final @NotNull IDevice device, @NotNull Client client, final @NotNull BiConsumer<String, Key> consumer) {
            AndroidLogcatService.LogcatListener previousListener;
            if (device == null) {
                LogcatOutputCapture.$$$reportNull$$$0(1);
            }
            if (client == null) {
                LogcatOutputCapture.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                LogcatOutputCapture.$$$reportNull$$$0(3);
            }
            if (!StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get().booleanValue()) {
                return;
            }
            if (!LogcatOutputSettings.getInstance().isRunOutputEnabled()) {
                return;
            }
            LOG.info(String.format("startCapture(\"%s\")", device.getName()));
            ApplicationLogListener logListener = new ApplicationLogListener(this.myApplicationId, client.getClientData().getPid()){
                private final String SIMPLE_FORMAT;
                private final AtomicBoolean myIsFirstMessage;
                {
                    super(packageName, pid);
                    this.SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
                    this.myIsFirstMessage = new AtomicBoolean(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected String formatLogLine(@NotNull LogCatMessage line) {
                    if (line == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String message = AndroidLogcatFormatter.formatMessage(this.SIMPLE_FORMAT, line.getHeader(), line.getMessage());
                    Object object = myLock;
                    synchronized (object) {
                        if (myLogListeners.size() > 1) {
                            return String.format("[%1$s]: %2$s", device.getName(), message);
                        }
                        return message;
                    }
                }

                @Override
                protected void notifyTextAvailable(@NotNull String message, @NotNull Key key) {
                    if (message == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (key == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (this.myIsFirstMessage.compareAndSet(true, false)) {
                        consumer.accept("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
                    }
                    consumer.accept(message, key);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "line";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "message";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                    }
                    objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler$LogcatOutputCapture$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "formatLogLine";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "notifyTextAvailable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            AndroidLogcatService.getInstance().addListener(device, logListener, true);
            Object object = this.myLock;
            synchronized (object) {
                previousListener = this.myLogListeners.put(device, logListener);
            }
            if (previousListener != null) {
                LOG.warn(String.format("The device \"%s\" already has a registered logcat listener for application \"%s\". Removing it", device.getName(), this.myApplicationId));
                AndroidLogcatService.getInstance().removeListener(device, previousListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopCapture(@NotNull IDevice device) {
            AndroidLogcatService.LogcatListener previousListener;
            if (device == null) {
                LogcatOutputCapture.$$$reportNull$$$0(4);
            }
            LOG.info(String.format("stopCapture(\"%s\")", device.getName()));
            Object object = this.myLock;
            synchronized (object) {
                previousListener = this.myLogListeners.remove(device);
            }
            if (previousListener != null) {
                AndroidLogcatService.getInstance().removeListener(device, previousListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAll() {
            ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>> listeners;
            LOG.info("stopAll()");
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                listeners = new ArrayList<Map.Entry<IDevice, AndroidLogcatService.LogcatListener>>(this.myLogListeners.entrySet());
                this.myLogListeners.clear();
            }
            for (Map.Entry entry : listeners) {
                AndroidLogcatService.getInstance().removeListener((IDevice)entry.getKey(), (AndroidLogcatService.LogcatListener)entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationId";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/AndroidProcessHandler$LogcatOutputCapture";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startCapture";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopCapture";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

