/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.sampledata.CsvEditor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/sampledata/CsvEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "file", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "designer"})
public final class CsvEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        if (!StudioFlags.NELE_SAMPLE_DATA.get().booleanValue()) {
            return false;
        }
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, virtualFile);
        if (psiFile instanceof PsiPlainTextFile) {
            boolean bl;
            VirtualFile sampleDataDirectory;
            VirtualFile virtualFile2;
            AndroidFacet it;
            AndroidFacet androidFacet;
            AndroidFacet androidFacet2 = AndroidFacet.getInstance((PsiElement)psiFile);
            if (androidFacet2 != null) {
                it = androidFacet = androidFacet2;
                virtualFile2 = SampleDataResourceRepository.getSampleDataDir(it, false);
            } else {
                virtualFile2 = null;
            }
            VirtualFile virtualFile3 = sampleDataDirectory = virtualFile2;
            if (virtualFile3 != null) {
                it = androidFacet = virtualFile3;
                bl = VfsUtilCore.isAncestor((VirtualFile)sampleDataDirectory, (VirtualFile)virtualFile, (boolean)true);
            } else {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(project, file);
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiPlainTextFile");
        }
        return new CsvEditor((PsiPlainTextFile)psiFile, project);
    }

    @NotNull
    public String getEditorTypeId() {
        return "sample-data-csv-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

