/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.ArrayList;
import java.util.List;

public class SelectSameTypeAction
extends AnAction {
    private final SelectionModel myModel;

    public SelectSameTypeAction(SelectionModel model) {
        super("Select Same Type", "Select Same Type", null);
        this.myModel = model;
    }

    private static void addSameType(NlComponent root, List<NlComponent> all, List<NlComponent> selection) {
        for (NlComponent selected : selection) {
            if (!root.getTagName().equals(selected.getTagName())) continue;
            all.add(root);
        }
        for (NlComponent child : root.getChildren()) {
            SelectSameTypeAction.addSameType(child, all, selection);
        }
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabled(!this.myModel.isEmpty());
    }

    public void actionPerformed(AnActionEvent e) {
        ImmutableList<NlComponent> selection = this.myModel.getSelection();
        ArrayList all = Lists.newArrayList();
        NlComponent first = (NlComponent)selection.get(0);
        for (NlComponent root : first.getModel().getComponents()) {
            SelectSameTypeAction.addSameType(root, all, selection);
        }
        if (selection.size() == 1) {
            this.myModel.setSelection(all, first);
        } else {
            this.myModel.setSelection(all);
        }
    }
}

