/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.ide.common.repository.GradleVersion;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.util.XmlTagUtil;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\"\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a8\u0010\u0010\u001a\u0004\u0018\u00010\u000b*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005\u001a0\u0010\u001d\u001a\u00020\u001e*\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!\u001a\u0012\u0010\"\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0005\u001a\u0012\u0010#\u001a\u00020\u001e*\u00020\b2\u0006\u0010$\u001a\u00020%\u001a\u001e\u0010&\u001a\u00020\u001e*\u00020\b2\b\b\u0001\u0010'\u001a\u00020(2\b\b\u0001\u0010)\u001a\u00020(\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"BASE_ID_PATTERN", "Lkotlin/text/Regex;", "getBASE_ID_PATTERN", "()Lkotlin/text/Regex;", "CUSTOM_DENSITY_ID", "", "addDependencies", "", "Lcom/android/tools/idea/common/model/NlModel;", "toAdd", "", "Lcom/android/tools/idea/common/model/NlComponent;", "insertType", "Lcom/android/tools/idea/uibuilder/api/InsertType;", "canAddComponents", "receiver", "createComponent", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "parent", "before", "createComponents", "item", "Lcom/android/tools/idea/uibuilder/model/DnDTransferItem;", "getModuleDependencyVersion", "Lcom/android/ide/common/repository/GradleVersion;", "artifact", "handleAddition", "", "added", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "isModuleDependency", "overrideConfigurationDensity", "density", "Lcom/android/resources/Density;", "overrideConfigurationScreenSize", "xDimension", "", "yDimension", "designer"})
public final class NlModelHelperKt {
    @NotNull
    public static final String CUSTOM_DENSITY_ID = "Custom Density";
    @NotNull
    private static final Regex BASE_ID_PATTERN = new Regex("(.*[^0-9])([0-9]+)?");

    @NotNull
    public static final Regex getBASE_ID_PATTERN() {
        return BASE_ID_PATTERN;
    }

    public static final boolean isModuleDependency(@NotNull NlModel $receiver, @NotNull String artifact) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        AndroidModuleModel gradleModel = AndroidModuleModel.get($receiver.getFacet());
        return gradleModel != null && GradleUtil.dependsOn(gradleModel, artifact);
    }

    @Nullable
    public static final GradleVersion getModuleDependencyVersion(@NotNull NlModel $receiver, @NotNull String artifact) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        AndroidModuleModel gradleModel = AndroidModuleModel.get($receiver.getFacet());
        return gradleModel != null ? GradleUtil.getModuleDependencyVersion(gradleModel, artifact) : null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationScreenSize(@NotNull NlModel $receiver, int xDimension, int yDimension) {
        State newState;
        VirtualFile better;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Device original = $receiver.getConfiguration().getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device = deviceBuilder.build();
        for (State state : device.getAllStates()) {
            Screen screen = state.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi = screen.getPixelDensity().getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.sqrt(width * width + height * height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(AvdScreenData.getScreenSize(diagonalLength));
            screen.setRatio(AvdScreenData.getScreenRatio(xDimension, yDimension));
            screen.setScreenRound(device.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device.getDefaultHardware().getScreen().getChin());
        }
        List<Device> devices = $receiver.getConfiguration().getConfigurationManager().getDevices();
        boolean customDeviceReplaced = false;
        int screen = 0;
        int dpi = ((Collection)devices).size();
        while (screen < dpi) {
            void i;
            if (Intrinsics.areEqual((Object)"Custom", (Object)devices.get((int)i).getId())) {
                devices.set((int)i, device);
                customDeviceReplaced = true;
                break;
            }
            ++i;
        }
        if (!customDeviceReplaced) {
            devices.add(device);
        }
        if (xDimension > yDimension) {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Landscape", null, null);
            newState = device.getState("Landscape");
        } else {
            better = ConfigurationMatcher.getBetterMatch($receiver.getConfiguration(), device, "Portrait", null, null);
            newState = device.getState("Portrait");
        }
        if (better != null) {
            VirtualFile virtualFile = $receiver.getConfiguration().getFile();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile old = virtualFile;
            Project project = $receiver.getProject();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, better, -1);
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor selectedEditor = manager.getSelectedEditor(old);
            manager.openEditor(descriptor, true);
            if (selectedEditor instanceof NlEditor) {
                manager.setSelectedEditor(better, "android-designer2");
            } else if (selectedEditor != null) {
                manager.setSelectedEditor(better, TextEditorProvider.getInstance().getEditorTypeId());
            }
            AndroidFacet facet = AndroidFacet.getInstance($receiver.getConfiguration().getModule());
            if (facet != null) {
                Configuration configuration = ConfigurationManager.getOrCreateInstance(facet).getConfiguration(better);
                configuration.setEffectiveDevice(device, newState);
            }
        } else {
            $receiver.getConfiguration().setEffectiveDevice(device, newState);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void overrideConfigurationDensity(@NotNull NlModel $receiver, @NotNull Density density) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Device original = $receiver.getConfiguration().getDevice();
        Device.Builder deviceBuilder = new Device.Builder(original);
        if (original != null) {
            deviceBuilder.setTagId(original.getTagId());
        }
        deviceBuilder.setName("Custom");
        deviceBuilder.setId(CUSTOM_DENSITY_ID);
        Device device = deviceBuilder.build();
        Iterable iterable = device.getAllStates();
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            State state = (State)item$iv$iv;
            Collection collection = destination$iv$iv;
            Screen screen = it.getHardware().getScreen();
            collection.add(screen);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Screen it = (Screen)element$iv;
            it.setPixelDensity(density);
        }
        $receiver.getConfiguration().setEffectiveDevice(device, device.getDefaultState());
    }

    public static final boolean canAddComponents(@NotNull NlModel $receiver, @NotNull NlComponent receiver, @NotNull List<? extends NlComponent> toAdd) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull(toAdd, (String)"toAdd");
        if (!NlComponentHelperKt.getHasNlComponentInfo(receiver)) {
            return false;
        }
        ViewHandler viewHandler = NlComponentHelperKt.getViewHandler(receiver);
        if (!(viewHandler instanceof ViewGroupHandler)) {
            viewHandler = null;
        }
        ViewGroupHandler viewGroupHandler = (ViewGroupHandler)viewHandler;
        if (viewGroupHandler == null) {
            return false;
        }
        ViewGroupHandler parentHandler = viewGroupHandler;
        for (NlComponent nlComponent : toAdd) {
            if (!parentHandler.acceptsChild(receiver, nlComponent)) {
                return false;
            }
            ViewHandler handler = ViewHandlerManager.get($receiver.getProject()).getHandler(nlComponent);
            if (handler == null || handler.acceptsParent(receiver, nlComponent)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static final NlComponent createComponent(@NotNull NlModel $receiver, @NotNull SceneView sceneView, @NotNull XmlTag tag, @Nullable NlComponent parent, @Nullable NlComponent before, @NotNull InsertType insertType) {
        ViewHandler parentHandler;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)sceneView, (String)"sceneView");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        NlComponent child = $receiver.createComponent(tag, parent, before);
        XmlTag realTag = child.getTag();
        if (parent != null) {
            if (realTag.getAttribute("layout_width", "http://schemas.android.com/apk/res/android") == null) {
                realTag.setAttribute("layout_width", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
            if (realTag.getAttribute("layout_height", "http://schemas.android.com/apk/res/android") == null) {
                realTag.setAttribute("layout_height", "http://schemas.android.com/apk/res/android", "wrap_content");
            }
        } else {
            if (realTag.getAttribute("android:layout_width") == null) {
                realTag.setAttribute("android:layout_width", "wrap_content");
            }
            if (realTag.getAttribute("android:layout_height") == null) {
                realTag.setAttribute("android:layout_height", "wrap_content");
            }
        }
        ViewHandlerManager viewHandlerManager = ViewHandlerManager.get($receiver.getProject());
        ViewHandler childHandler = viewHandlerManager.getHandler(child);
        ViewEditorImpl editor = new ViewEditorImpl(sceneView);
        if (childHandler != null) {
            boolean ok = childHandler.onCreate(editor, parent, child, insertType);
            if (parent != null) {
                ok &= NlModelHelperKt.addDependencies($receiver, (List)ImmutableList.of((Object)child), InsertType.CREATE);
            }
            if (!ok) {
                NlComponent nlComponent = parent;
                if (nlComponent != null) {
                    nlComponent.removeChild(child);
                }
                realTag.delete();
                return null;
            }
        }
        if (parent != null && (parentHandler = viewHandlerManager.getHandler(parent)) instanceof ViewGroupHandler) {
            ((ViewGroupHandler)parentHandler).onChildInserted(editor, parent, child, insertType);
        }
        return child;
    }

    public static final boolean addDependencies(@NotNull NlModel $receiver, @Nullable List<? extends NlComponent> toAdd, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        if (toAdd == null || insertType.isMove()) {
            return true;
        }
        HashSet artifacts = new HashSet();
        Iterable $receiver$iv = toAdd;
        for (Object element$iv : $receiver$iv) {
            NlComponent it = (NlComponent)element$iv;
            NlComponentHelperKt.getDependencies(it, artifacts);
        }
        List dependencies2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)artifacts), (Function1)addDependencies.dependencies.1.INSTANCE), (Function1)addDependencies.dependencies.2.INSTANCE));
        GradleDependencyManager manager = GradleDependencyManager.getInstance($receiver.getProject());
        return manager.ensureLibraryIsIncluded($receiver.getModule(), dependencies2, null);
    }

    @NotNull
    public static final List<NlComponent> createComponents(@NotNull NlModel $receiver, @NotNull SceneView sceneView, @NotNull DnDTransferItem item, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)sceneView, (String)"sceneView");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        ArrayList<NlComponent> components = new ArrayList<NlComponent>(item.getComponents().size());
        for (DnDTransferComponent dndComponent : item.getComponents()) {
            NlComponent component2;
            XmlTag tag;
            XmlTag xmlTag = tag = XmlTagUtil.createTag(sceneView.getModel().getProject(), dndComponent.getRepresentation());
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag, (String)"tag");
            if (NlModelHelperKt.createComponent($receiver, sceneView, xmlTag, null, null, insertType) == null) {
                List<NlComponent> list = Collections.emptyList();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
                return list;
            }
            NlComponentHelperKt.setW(component2, dndComponent.getWidth());
            NlComponentHelperKt.setH(component2, dndComponent.getHeight());
            components.add(component2);
        }
        return components;
    }

    public static final void handleAddition(@NotNull NlModel $receiver, @NotNull List<? extends NlComponent> added, @NotNull NlComponent receiver, @NotNull InsertType insertType, @NotNull DesignSurface surface) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(added, (String)"added");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
        InsertType realInsertType = insertType;
        if (!NlComponentHelperKt.getHasNlComponentInfo(receiver)) {
            return;
        }
        HashSet ids = Sets.newHashSet((Iterable)NlComponent.getIds($receiver));
        ViewGroupHandler viewGroupHandler = (ViewGroupHandler)NlComponentHelperKt.getViewHandler(receiver);
        if (viewGroupHandler == null) {
            Intrinsics.throwNpe();
        }
        ViewGroupHandler groupHandler = viewGroupHandler;
        SceneView sceneView = surface.getCurrentSceneView();
        if (sceneView == null) {
            Intrinsics.throwNpe();
        }
        SceneView view = sceneView;
        ViewEditorImpl editor = new ViewEditorImpl(view);
        for (NlComponent nlComponent : added) {
            if (insertType.isMove()) {
                InsertType insertType2 = realInsertType = nlComponent.getParent() == receiver ? InsertType.MOVE_WITHIN : InsertType.MOVE_INTO;
            }
            if (NlComponentHelperKt.needsDefaultId(nlComponent) && !realInsertType.isMove()) {
                String id = nlComponent.getId();
                CharSequence charSequence = id;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    ids.add(nlComponent.assignId(ids));
                } else {
                    String string = id;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id!!");
                    Object object = Regex.find$default((Regex)BASE_ID_PATTERN, (CharSequence)string, (int)0, (int)2, null);
                    if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null) {
                        CharSequence it = charSequence = object;
                        ids.add(nlComponent.assignId((String)it, ids));
                    }
                }
            }
            groupHandler.onChildInserted(editor, receiver, nlComponent, realInsertType);
        }
    }
}

